/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.tools.FontSizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListChooser
extends JDialog {
    private JPanel checkPane = new JPanel();
    private Object[] objects;
    private boolean[] selections;
    private JCheckBox[] checkBoxes;
    private JLabel instructions;
    private boolean applyChanges = false;
    private String separator = ":  ";
    private Font lightFont;

    public ListChooser(String string, String string2) {
        this(string, string2, null);
    }

    public ListChooser(String string, String string2, Component component) {
        super(JOptionPane.getFrameForComponent(component), true);
        this.setTitle(string);
        this.instructions = new JLabel(" " + string2);
        this.instructions.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        this.createGUI();
    }

    public ListChooser(String string, String string2, JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.setTitle(string);
        this.instructions = new JLabel(" " + string2);
        this.instructions.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        this.createGUI();
    }

    private void createGUI() {
        this.lightFont = new JLabel().getFont().deriveFont(0);
        JButton jButton = new JButton(ControlsRes.getString("Chooser.Button.Cancel"));
        JButton jButton2 = new JButton(ControlsRes.getString("Chooser.Button.OK"));
        JButton jButton3 = new JButton(ControlsRes.getString("Chooser.Button.SelectAll"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListChooser.this.setVisible(false);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < ListChooser.this.checkBoxes.length) {
                    ((ListChooser)ListChooser.this).selections[n] = ListChooser.this.checkBoxes[n].isSelected();
                    ++n;
                }
                ListChooser.this.applyChanges = true;
                ListChooser.this.setVisible(false);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < ListChooser.this.checkBoxes.length) {
                    ListChooser.this.checkBoxes[n].setSelected(true);
                    ++n;
                }
            }
        });
        this.getRootPane().setDefaultButton(jButton2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.instructions);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton3);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.checkPane.setLayout(new BoxLayout(this.checkPane, 1));
        this.checkPane.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this.checkPane);
        jScrollPane.setPreferredSize(new Dimension(250, 180));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(jButton2);
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel3.add(jButton);
        Container container = this.getContentPane();
        container.add((Component)jPanel, "North");
        container.add((Component)jPanel2, "Center");
        container.add((Component)jPanel3, "South");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = new Rectangle(dimension);
        if (this.getOwner() != null) {
            rectangle = this.getOwner().getBounds();
        }
        int n = rectangle.x + (rectangle.width - this.getBounds().width) / 2;
        int n2 = rectangle.y + (rectangle.height - this.getBounds().height) / 2;
        this.setLocation(n, n2);
    }

    public void setSeparator(String string) {
        if (string != null) {
            this.separator = string;
        }
    }

    public boolean choose(Collection<?> collection, Collection<String> collection2) {
        return this.choose(collection, collection2, null);
    }

    public boolean choose(Collection<?> collection, Collection<String> collection2, Collection<?> collection3) {
        boolean[] blArray = new boolean[collection.size()];
        return this.choose(collection, collection2, collection3, blArray);
    }

    public boolean choose(Collection<?> collection, Collection<String> collection2, Collection<?> collection3, boolean[] blArray) {
        boolean[] blArray2 = new boolean[collection.size()];
        return this.choose(collection, collection2, collection3, blArray, blArray2);
    }

    public boolean choose(Collection<?> collection, Collection<String> collection2, Collection<?> collection3, boolean[] blArray, boolean[] blArray2) {
        return this.choose(collection, collection2, collection3, null, blArray, blArray2);
    }

    public boolean choose(Collection<?> collection, Collection<String> collection2, Collection<?> collection3, Collection<String> collection4, boolean[] blArray) {
        boolean[] blArray2 = new boolean[collection.size()];
        return this.choose(collection, collection2, collection3, collection4, blArray, blArray2);
    }

    public boolean choose(Collection<?> collection, Collection<String> collection2, Collection<?> collection3, Collection<String> collection4, boolean[] blArray, boolean[] blArray2) {
        this.checkPane.removeAll();
        this.checkBoxes = new JCheckBox[collection.size()];
        this.selections = new boolean[collection.size()];
        this.objects = new Object[collection.size()];
        ArrayList<String> arrayList = new ArrayList<String>();
        if (collection2 != null) {
            arrayList.addAll(collection2);
        }
        ArrayList arrayList2 = new ArrayList();
        if (collection3 != null) {
            arrayList2.addAll(collection3);
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (collection4 != null) {
            arrayList3.addAll(collection4);
        }
        Iterator<?> iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object;
            this.objects[n] = iterator.next();
            this.selections[n] = false;
            if (arrayList.size() <= n || arrayList.get(n) == null) {
                this.checkBoxes[n] = new JCheckBox(this.objects[n].toString());
            } else {
                object = (String)arrayList.get(n);
                if (arrayList2.size() > n && arrayList2.get(n) != null) {
                    object = String.valueOf(object) + this.separator + arrayList2.get(n);
                }
                this.checkBoxes[n] = new JCheckBox((String)object);
            }
            this.checkBoxes[n].setSelected(blArray[n]);
            this.checkBoxes[n].setEnabled(!blArray2[n]);
            this.checkBoxes[n].setBackground(Color.white);
            this.checkBoxes[n].setFont(this.lightFont);
            this.checkBoxes[n].setIconTextGap(10);
            object = Box.createHorizontalBox();
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 8));
            ((Container)object).add(this.checkBoxes[n]);
            ((Container)object).add(Box.createHorizontalGlue());
            this.checkPane.add((Component)object);
            if (arrayList3.size() > n && arrayList3.get(n) != null) {
                JLabel jLabel = new JLabel((String)arrayList3.get(n));
                jLabel.setFont(this.lightFont);
                ((Container)object).add(jLabel);
            }
            ++n;
        }
        FontSizer.setFonts(this, FontSizer.getLevel());
        this.pack();
        this.setVisible(true);
        if (!this.applyChanges) {
            return false;
        }
        n = 0;
        while (n < this.objects.length) {
            if (!this.selections[n]) {
                collection.remove(this.objects[n]);
            }
            ++n;
        }
        return true;
    }
}

