/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.davidson.applets;

import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JApplet;
import javax.swing.JFrame;
import org.opensourcephysics.controls.MainFrame;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.display.TextFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameApplet
extends JApplet
implements Renderable {
    JFrame mainFrame = null;
    String targetClassName;
    String contentName;
    ArrayList<Frame> newFrames = new ArrayList();
    ArrayList<Frame> existingFrames = new ArrayList();
    String[] args = null;
    Renderable renderPanel;
    boolean singleFrame = false;

    public String getParameter(String string, String string2) {
        return this.getParameter(string) != null ? this.getParameter(string) : string2;
    }

    @Override
    public void init() {
        super.init();
        if (this.getParameter("showLog", "false").toLowerCase().trim().equals("true")) {
            OSPLog.showLog();
        }
        OSPRuntime.applet = this;
        OSPRuntime.appletMode = true;
        String string = this.getParameter("xmldata", null);
        if (string != null) {
            this.args = new String[1];
            this.args[0] = string;
        }
        this.targetClassName = this.getParameter("target", null);
        if (this.targetClassName == null) {
            this.targetClassName = this.getParameter("app", null);
        }
        this.contentName = this.getParameter("content", null);
        this.singleFrame = this.getParameter("singleframe", "false").trim().equalsIgnoreCase("true");
    }

    @Override
    public void start() {
        int n;
        int n2;
        Object object;
        if (this.mainFrame != null) {
            return;
        }
        this.createTarget();
        if (this.contentName != null) {
            object = Frame.getFrames();
            n2 = 0;
            n = ((Frame[])object).length;
            while (n2 < n) {
                if (object[n2] instanceof JFrame && object[n2].getName().equalsIgnoreCase(this.contentName)) {
                    this.mainFrame = (JFrame)object[n2];
                    break;
                }
                ++n2;
            }
        }
        if (this.mainFrame == null) {
            System.out.println("Main frame not found.");
            return;
        }
        this.removeWindowListeners(this.mainFrame);
        this.mainFrame.setVisible(false);
        object = this.mainFrame.getContentPane();
        if (this.mainFrame instanceof OSPFrame && ((OSPFrame)this.mainFrame).isAnimated()) {
            this.renderPanel = (Renderable)((Object)GUIUtils.findInstance((Container)object, Renderable.class));
        }
        if (this.mainFrame instanceof OSPFrame) {
            ((OSPFrame)this.mainFrame).setKeepHidden(true);
        } else {
            this.mainFrame.dispose();
        }
        this.getRootPane().setContentPane((Container)object);
        this.getRootPane().requestFocus();
        if (!this.singleFrame) {
            OSPRuntime.appletMode = false;
            n2 = 0;
            n = this.newFrames.size();
            while (n2 < n) {
                if (this.newFrames.get(n2) instanceof OSPFrame && this.newFrames.get(n2) != this.mainFrame) {
                    ((OSPFrame)this.newFrames.get(n2)).setKeepHidden(false);
                }
                ++n2;
            }
            GUIUtils.showDrawingAndTableFrames();
        }
    }

    private void removeWindowListeners(Window window) {
        WindowListener[] windowListenerArray = window.getWindowListeners();
        int n = 0;
        int n2 = windowListenerArray.length;
        while (n < n2) {
            this.mainFrame.removeWindowListener(windowListenerArray[n]);
            ++n;
        }
    }

    @Override
    public BufferedImage render() {
        if (this.renderPanel != null) {
            return this.renderPanel.render();
        }
        return null;
    }

    @Override
    public BufferedImage render(BufferedImage bufferedImage) {
        if (this.renderPanel != null) {
            this.renderPanel.render(bufferedImage);
        }
        return bufferedImage;
    }

    static boolean isLaunchable(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        try {
            clazz.getMethod("main", String[].class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    @Override
    public void destroy() {
        this.disposeOwnedFrames();
        this.mainFrame = null;
        super.destroy();
    }

    private Class<?> createTarget() {
        Class<?> clazz = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            clazz = classLoader.loadClass(this.targetClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found: " + this.targetClassName);
            return null;
        }
        if (!FrameApplet.isLaunchable(clazz)) {
            System.err.println("Main method not found in " + this.targetClassName);
            return null;
        }
        Frame[] frameArray = Frame.getFrames();
        this.existingFrames.clear();
        int n = 0;
        int n2 = frameArray.length;
        while (n < n2) {
            this.existingFrames.add(frameArray[n]);
            ++n;
        }
        String string = this.getParameter("htmldata", null);
        if (string != null) {
            TextFrame textFrame = new TextFrame(string, clazz);
            textFrame.setVisible(true);
        }
        try {
            Method method = clazz.getMethod("main", String[].class);
            method.invoke(clazz, new Object[]{this.args});
            frameArray = Frame.getFrames();
            int n3 = 0;
            int n4 = frameArray.length;
            while (n3 < n4) {
                if (this.mainFrame == null && frameArray[n3] instanceof MainFrame) {
                    this.mainFrame = ((MainFrame)((Object)frameArray[n3])).getMainFrame();
                }
                ++n3;
            }
            n3 = 0;
            n4 = frameArray.length;
            while (n3 < n4) {
                if (frameArray[n3] instanceof JFrame && ((JFrame)frameArray[n3]).getDefaultCloseOperation() == 3) {
                    ((JFrame)frameArray[n3]).setDefaultCloseOperation(1);
                    if (this.mainFrame == null) {
                        this.mainFrame = (JFrame)frameArray[n3];
                    }
                }
                if (!this.existingFrames.contains(frameArray[n3])) {
                    this.newFrames.add(frameArray[n3]);
                }
                ++n3;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException);
        }
        if (this.newFrames.size() > 0 && this.mainFrame == null && this.newFrames.get(0) instanceof JFrame) {
            this.mainFrame = (JFrame)this.newFrames.get(0);
        }
        return clazz;
    }

    private void disposeOwnedFrames() {
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        int n2 = frameArray.length;
        while (n < n2) {
            if (frameArray[n] instanceof JFrame && ((JFrame)frameArray[n]).getDefaultCloseOperation() == 3) {
                ((JFrame)frameArray[n]).setDefaultCloseOperation(2);
            }
            if (!this.existingFrames.contains(frameArray[n])) {
                frameArray[n].setVisible(false);
                this.removeWindowListeners(frameArray[n]);
                frameArray[n].dispose();
            }
            ++n;
        }
    }
}

