/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.CircleLoader;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;

public class Circle
implements Drawable {
    public Color color = Color.red;
    public int pixRadius = 6;
    protected double x = 0.0;
    protected double y = 0.0;

    public Circle() {
        this(0.0, 0.0);
    }

    public Circle(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Circle(double d, double d2, int n) {
        this.x = d;
        this.y = d2;
        this.pixRadius = n;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n = drawingPanel.xToPix(this.x) - this.pixRadius;
        int n2 = drawingPanel.yToPix(this.y) - this.pixRadius;
        graphics.setColor(this.color);
        graphics.fillOval(n, n2, 2 * this.pixRadius, 2 * this.pixRadius);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        this.x = d;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setXY(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = String.valueOf(string.substring(1 + string.lastIndexOf("."))) + '[';
        string = String.valueOf(string) + "x=" + this.x;
        string = String.valueOf(string) + ",y=" + this.y;
        string = String.valueOf(string) + ",r_pix=" + this.pixRadius + ']';
        return string;
    }

    public static XML.ObjectLoader getLoader() {
        return new CircleLoader();
    }
}

