/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display2d.ByteLattice;
import org.opensourcephysics.display2d.CellLatticeOSX;
import org.opensourcephysics.display2d.CellLatticePC;
import org.opensourcephysics.display2d.SiteLattice;

public class CellLattice
implements ByteLattice {
    ByteLattice lattice = null;
    static String osName;

    static {
        try {
            osName = System.getProperty("os.name", "");
        }
        catch (Exception exception) {
            osName = "";
        }
    }

    public CellLattice() {
        this.lattice = osName.indexOf("Mac") > -1 ? new CellLatticeOSX() : new CellLatticePC();
    }

    public CellLattice(int n, int n2) {
        this.lattice = osName.indexOf("Mac") > -1 ? new CellLatticeOSX(n, n2) : new CellLatticePC(n, n2);
    }

    public double getXMin() {
        return this.lattice.getXMin();
    }

    public double getXMax() {
        return this.lattice.getXMax();
    }

    public double getYMin() {
        return this.lattice.getYMin();
    }

    public double getYMax() {
        return this.lattice.getYMax();
    }

    public boolean isMeasured() {
        return this.lattice.isMeasured();
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        this.lattice.draw(drawingPanel, graphics);
    }

    public int getNx() {
        return this.lattice.getNx();
    }

    public int getNy() {
        return this.lattice.getNy();
    }

    public int indexFromPoint(double d, double d2) {
        return this.lattice.indexFromPoint(d, d2);
    }

    public int xToIndex(double d) {
        return this.lattice.xToIndex(d);
    }

    public int yToIndex(double d) {
        return this.lattice.yToIndex(d);
    }

    public byte getValue(int n, int n2) {
        return this.lattice.getValue(n, n2);
    }

    public void setValue(int n, int n2, byte by) {
        this.lattice.setValue(n, n2, by);
    }

    public void randomize() {
        this.lattice.randomize();
    }

    public void resizeLattice(int n, int n2) {
        this.lattice.resizeLattice(n, n2);
    }

    public void setAll(byte[][] byArray, double d, double d2, double d3, double d4) {
        this.lattice.setAll(byArray, d, d2, d3, d4);
    }

    public void setBlock(int n, int n2, byte[][] byArray) {
        this.lattice.setBlock(n, n2, byArray);
    }

    public void setBlock(byte[][] byArray) {
        this.lattice.setBlock(byArray);
    }

    public void setCol(int n, int n2, byte[] byArray) {
        this.lattice.setCol(n, n2, byArray);
    }

    public void setRow(int n, int n2, byte[] byArray) {
        this.lattice.setRow(n, n2, byArray);
    }

    public void setShowGridLines(boolean bl) {
        this.lattice.setShowGridLines(bl);
    }

    public void setGridLineColor(Color color) {
        this.lattice.setGridLineColor(color);
    }

    public JFrame showLegend() {
        return this.lattice.showLegend();
    }

    public void setVisible(boolean bl) {
        this.lattice.setVisible(bl);
    }

    public void setColorPalette(Color[] colorArray) {
        this.lattice.setColorPalette(colorArray);
    }

    public void setIndexedColor(int n, Color color) {
        this.lattice.setIndexedColor(n, color);
    }

    public void setMinMax(double d, double d2, double d3, double d4) {
        this.lattice.setMinMax(d, d2, d3, d4);
    }

    public SiteLattice createSiteLattice() {
        if (osName.indexOf("Mac") > -1) {
            return ((CellLatticeOSX)this.lattice).createSiteLattice();
        }
        return ((CellLatticePC)this.lattice).createSiteLattice();
    }

    public void setBlock(int n, int n2, int[][] nArray) {
        if (osName.indexOf("Mac") > -1) {
            ((CellLatticeOSX)this.lattice).setBlock(n, n2, nArray);
        } else {
            ((CellLatticePC)this.lattice).setBlock(n, n2, nArray);
        }
    }

    public void setXMin(double d) {
        this.lattice.setXMin(d);
    }

    public void setXMax(double d) {
        this.lattice.setXMax(d);
    }

    public void setYMin(double d) {
        this.lattice.setYMin(d);
    }

    public void setYMax(double d) {
        this.lattice.setYMax(d);
    }

    public void createDefaultColors() {
        this.lattice.createDefaultColors();
    }
}

