/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Random;
import javax.swing.JFrame;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.ByteLattice;
import org.opensourcephysics.display2d.CellLattice;

public class SiteLattice
extends Grid
implements Measurable,
ByteLattice {
    boolean visible = true;
    Color[] colors = new Color[256];
    byte[][] data;
    int sx;
    int sy;
    private JFrame legendFrame;

    public SiteLattice(int n, int n2) {
        super(n - 1, n2 - 1);
        this.sx = n;
        this.sy = n2;
        this.createDefaultColors();
        this.data = new byte[n][n2];
        this.color = Color.lightGray;
    }

    public void resizeLattice(int n, int n2) {
        this.sx = n;
        this.sy = n2;
        this.nx = this.sx - 1;
        this.ny = this.sy - 1;
        this.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
        this.data = new byte[this.sx][this.sy];
    }

    public ByteLattice createCellLattice() {
        CellLattice cellLattice = new CellLattice(this.sx, this.sy);
        cellLattice.setBlock(this.data);
        cellLattice.setMinMax(this.getXMin(), this.getXMax(), this.getYMin(), this.getYMax());
        cellLattice.setColorPalette(this.colors);
        return cellLattice;
    }

    public int getNx() {
        return this.sx;
    }

    public int getNy() {
        return this.sy;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        super.draw(drawingPanel, graphics);
        double d = this.xmin;
        double d2 = this.ymin;
        int n = (int)Math.min(Math.abs(drawingPanel.getXPixPerUnit() * this.dx), 4.0);
        n = Math.max(1, n);
        int n2 = (int)Math.min(Math.abs(drawingPanel.getYPixPerUnit() * this.dy), 4.0);
        n2 = Math.max(1, n2);
        int n3 = 0;
        while (n3 < this.sx) {
            int n4 = 0;
            while (n4 < this.sy) {
                int n5 = this.data[n3][n4] & 0xFF;
                graphics.setColor(this.colors[n5]);
                graphics.fillOval(drawingPanel.xToPix(d) - n, drawingPanel.yToPix(d2) - n2, 2 * n, 2 * n2);
                if (n > 3 && n2 > 3) {
                    graphics.setColor(this.color);
                    graphics.drawOval(drawingPanel.xToPix(d) - n, drawingPanel.yToPix(d2) - n2, 2 * n, 2 * n2);
                }
                d2 += this.dy;
                ++n4;
            }
            d += this.dx;
            d2 = this.ymin;
            ++n3;
        }
    }

    public void setAll(byte[][] byArray) {
        if (this.getNx() != byArray.length || this.getNy() != byArray[0].length) {
            this.resizeLattice(byArray.length, byArray[0].length);
        }
        this.setBlock(0, 0, byArray);
    }

    public void setAll(byte[][] byArray, double d, double d2, double d3, double d4) {
        this.setAll(byArray);
        this.setMinMax(d, d2, d3, d4);
    }

    public void setBlock(int n, int n2, byte[][] byArray) {
        if (n2 < 0 || n2 + byArray[0].length > this.sy) {
            throw new IllegalArgumentException("Row offset " + n2 + " out of range.");
        }
        if (n < 0 || n + byArray.length > this.sx) {
            throw new IllegalArgumentException("Column offset " + n + " out of range.");
        }
        int n3 = n2;
        int n4 = byArray[0].length + n2;
        while (n3 < n4) {
            int n5 = n;
            int n6 = byArray.length + n;
            while (n5 < n6) {
                this.data[n5][n3] = byArray[n5 - n][n3 - n2];
                ++n5;
            }
            ++n3;
        }
    }

    public void setBlock(int n, int n2, int[][] nArray) {
        if (n2 < 0 || n2 + nArray[0].length > this.sy) {
            throw new IllegalArgumentException("Row offset " + n2 + " out of range.");
        }
        if (n < 0 || n + nArray.length > this.sx) {
            throw new IllegalArgumentException("Column offset " + n + " out of range.");
        }
        int n3 = n2;
        int n4 = nArray[0].length + n2;
        while (n3 < n4) {
            int n5 = n;
            int n6 = nArray.length + n;
            while (n5 < n6) {
                this.data[n5][n3] = (byte)nArray[n5 - n][n3 - n2];
                ++n5;
            }
            ++n3;
        }
    }

    public void setBlock(byte[][] byArray) {
        this.setBlock(0, 0, byArray);
    }

    public void setCol(int n, int n2, byte[] byArray) {
        if (n2 < 0 || n2 + byArray.length > this.sy) {
            throw new IllegalArgumentException("Row offset " + n2 + " out of range.");
        }
        if (n < 0 || n >= this.sx) {
            throw new IllegalArgumentException("Column index " + n + " out of range.");
        }
        int n3 = n2;
        int n4 = byArray.length + n2;
        while (n3 < n4) {
            this.data[n][n3] = byArray[n3 - n2];
            ++n3;
        }
    }

    public void setRow(int n, int n2, byte[] byArray) {
        if (n < 0 || n >= this.sy) {
            throw new IllegalArgumentException("Y index out of range in binary lattice setRow.");
        }
        if (n2 < 0 || n2 + byArray.length > this.sx) {
            throw new IllegalArgumentException("X offset out of range in binary lattice setRow.");
        }
        int n3 = n2;
        int n4 = byArray.length + n2;
        while (n3 < n4) {
            this.data[n3][n] = byArray[n3 - n2];
            ++n3;
        }
    }

    public void setValue(int n, int n2, byte by) {
        if (n2 < 0 || n2 >= this.sy) {
            throw new IllegalArgumentException("Row index " + n2 + " out of range.");
        }
        if (n < 0 || n >= this.sx) {
            throw new IllegalArgumentException("Column index " + n + " out of range.");
        }
        this.data[n][n2] = by;
    }

    public byte getValue(int n, int n2) {
        return this.data[n][n2];
    }

    public int indexFromPoint(double d, double d2) {
        int n = this.getNx();
        int n2 = this.getNy();
        double d3 = this.getXMin();
        double d4 = this.getXMax();
        double d5 = this.getYMin();
        double d6 = this.getYMax();
        double d7 = (d - d3) / (d4 - d3);
        double d8 = (d2 - d5) / (d6 - d5);
        int n3 = (int)(d7 * (double)n);
        int n4 = (int)(d8 * (double)n2);
        if (n3 < 0 || n4 < 0 || n3 >= n || n4 >= n2) {
            return -1;
        }
        return n4 * n + n3;
    }

    public int xToIndex(double d) {
        double d2;
        int n = this.getNx();
        double d3 = this.getXMin();
        double d4 = (d - d3) / ((d2 = this.getXMax()) - d3);
        int n2 = (int)(d4 * (double)n);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    public int yToIndex(double d) {
        double d2;
        int n = this.getNy();
        double d3 = this.getYMin();
        double d4 = (d - d3) / ((d2 = this.getYMax()) - d3);
        int n2 = (int)(d4 * (double)n);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    public void setShowVisible(boolean bl) {
        this.visible = bl;
    }

    public void setShowGridLines(boolean bl) {
        ((Grid)this).visible = bl;
    }

    public void randomize() {
        Random random = new Random();
        int n = 0;
        int n2 = this.data[0].length;
        while (n < n2) {
            int n3 = 0;
            int n4 = this.data.length;
            while (n3 < n4) {
                this.data[n3][n] = (byte)random.nextInt(256);
                ++n3;
            }
            ++n;
        }
    }

    public JFrame showLegend() {
        InteractivePanel interactivePanel = new InteractivePanel();
        interactivePanel.setPreferredSize(new Dimension(300, 66));
        interactivePanel.setPreferredGutters(0, 0, 0, 35);
        interactivePanel.setClipAtGutter(false);
        if (this.legendFrame == null || !this.legendFrame.isDisplayable()) {
            this.legendFrame = new JFrame(DisplayRes.getString("GUIUtils.Legend"));
        }
        this.legendFrame.setDefaultCloseOperation(2);
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(interactivePanel);
        CellLattice cellLattice = new CellLattice(256, 1);
        cellLattice.setMinMax(-128.0, 127.0, 0.0, 1.0);
        byte[][] byArray = new byte[256][1];
        int n = 0;
        while (n < 256) {
            byArray[n][0] = (byte)(-128 + n);
            ++n;
        }
        cellLattice.setBlock(0, 0, byArray);
        interactivePanel.addDrawable(cellLattice);
        XAxis xAxis = new XAxis("");
        xAxis.setLocationType(2);
        xAxis.setLocation(-0.5);
        xAxis.setEnabled(true);
        interactivePanel.addDrawable(xAxis);
        this.legendFrame.pack();
        this.legendFrame.setVisible(true);
        return this.legendFrame;
    }

    public void setColorPalette(Color[] colorArray) {
        int n = Math.min(256, colorArray.length);
        int n2 = 0;
        while (n2 < n) {
            this.colors[n2] = colorArray[n2];
            ++n2;
        }
        n2 = n;
        while (n2 < 256) {
            this.colors[n2] = Color.black;
            ++n2;
        }
    }

    public void setGridLineColor(Color color) {
        this.color = color;
    }

    public void setIndexedColor(int n, Color color) {
        n = (n + 256) % this.colors.length;
        this.colors[n] = color;
    }

    public boolean isMeasured() {
        return true;
    }

    public double getXMin() {
        return this.xmin - this.dx / 2.0;
    }

    public double getXMax() {
        return this.xmax + this.dx / 2.0;
    }

    public double getYMin() {
        return this.ymin - this.dy / 2.0;
    }

    public double getYMax() {
        return this.ymax + this.dy / 2.0;
    }

    public void setXMin(double d) {
        this.xmin = d + this.dy / 2.0;
        this.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public void setXMax(double d) {
        this.xmax = d - this.dy / 2.0;
        this.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public void setYMin(double d) {
        this.ymin = d + this.dy / 2.0;
        this.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public void setYMax(double d) {
        this.ymax = d - this.dy / 2.0;
        this.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public void createDefaultColors() {
        int n = 0;
        while (n < 256) {
            double d = n < 128 ? (double)(n - 100) / 255.0 : -1.0;
            double d2 = Math.exp(-d * d * 8.0);
            int n2 = (int)(255.0 * d2);
            d = n < 128 ? (double)n / 255.0 : (double)(255 - n) / 255.0;
            d2 = Math.exp(-d * d * 8.0);
            int n3 = (int)(255.0 * d2);
            d = n < 128 ? -1.0 : (double)(n - 156) / 255.0;
            d2 = Math.exp(-d * d * 8.0);
            int n4 = (int)(255.0 * d2);
            this.colors[n] = new Color(n2, n3, n4);
            ++n;
        }
    }
}

