/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.Random;
import javax.swing.JFrame;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.axes.XAxis;

public class TriangularByteLattice
implements Measurable {
    int nrow;
    int ncol;
    byte[][] data;
    double xmin;
    double ymin;
    double xmax;
    double ymax;
    double xminLattice;
    double yminLattice;
    double xmaxLattice;
    double ymaxLattice;
    static final double SQRT3_OVER2 = Math.sqrt(3.0) / 2.0;
    boolean visible = true;
    Color[] colors = new Color[256];
    static final int radius = 3;
    static final int diameter = 6;
    JFrame legendFrame;

    public TriangularByteLattice(int n, int n2) {
        this.nrow = n;
        this.ncol = n2;
        this.createDefaultColors();
        this.data = new byte[this.nrow][this.ncol];
        this.xmin = 0.0;
        this.xminLattice = 0.0;
        this.xmaxLattice = this.xmax = (double)this.ncol - 0.5;
        this.ymin = (double)(this.nrow - 1) * SQRT3_OVER2;
        if (this.ymin == 0.0) {
            this.ymin = SQRT3_OVER2;
        }
        this.yminLattice = this.ymin;
        this.ymax = 0.0;
        this.ymaxLattice = 0.0;
    }

    public void resizeLattice(int n, int n2) {
        this.nrow = n;
        this.ncol = n2;
        this.data = new byte[this.nrow][this.ncol];
        this.xmin = 0.0;
        this.xminLattice = 0.0;
        this.xmaxLattice = this.xmax = (double)this.ncol - 0.5;
        this.ymin = (double)(this.nrow - 1) * SQRT3_OVER2;
        if (this.ymin == 0.0) {
            this.ymin = SQRT3_OVER2;
        }
        this.yminLattice = this.ymin;
        this.ymax = 0.0;
        this.ymaxLattice = 0.0;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setMinMax(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        Shape shape = graphics.getClip();
        graphics.setClip(null);
        double d = (this.xmax - this.xmin) / (this.xmaxLattice - this.xminLattice);
        double d2 = -(this.ymax - this.ymin) / (this.ymaxLattice - this.yminLattice);
        int n = 0;
        while (n < this.nrow) {
            int n2 = 0;
            while (n2 < this.ncol) {
                double d3;
                double d4;
                byte by = this.data[n][n2];
                graphics.setColor(this.colors[by & 0xFF]);
                if (n % 2 == 1) {
                    d4 = ((double)n2 + 0.5) * d + this.xmin;
                    d3 = (double)n * SQRT3_OVER2 * d2 + this.ymin;
                    graphics.fillOval(drawingPanel.xToPix(d4) - 3, drawingPanel.yToPix(d3) - 3, 6, 6);
                } else {
                    d4 = (double)n2 * d + this.xmin;
                    d3 = (double)n * SQRT3_OVER2 * d2 + this.ymin;
                    graphics.fillOval(drawingPanel.xToPix(d4) - 3, drawingPanel.yToPix(d3) - 3, 6, 6);
                }
                ++n2;
            }
            ++n;
        }
        graphics.setClip(shape);
    }

    public void setBlock(int n, int n2, byte[][] byArray) {
        if (n < 0 || n + byArray.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (n2 < 0 || n2 + byArray[0].length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int n3 = n;
        int n4 = byArray.length + n;
        while (n3 < n4) {
            int n5 = n2;
            int n6 = byArray[0].length + n2;
            while (n5 < n6) {
                this.data[n3][n5] = byArray[n3 - n][n5 - n2];
                ++n5;
            }
            ++n3;
        }
    }

    public void setBlock(int n, int n2, int[][] nArray) {
        if (n < 0 || n + nArray.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (n2 < 0 || n2 + nArray[0].length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int n3 = n;
        int n4 = nArray.length + n;
        while (n3 < n4) {
            int n5 = n2;
            int n6 = nArray[0].length + n2;
            while (n5 < n6) {
                this.data[n3][n5] = (byte)nArray[n3 - n][n5 - n2];
                ++n5;
            }
            ++n3;
        }
    }

    public void setCol(int n, int n2, byte[] byArray) {
        if (n < 0 || n + byArray.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (n2 < 0 || n2 >= this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int n3 = n;
        int n4 = byArray.length + n;
        while (n3 < n4) {
            this.data[n3][n2] = byArray[n3 - n];
            ++n3;
        }
    }

    public void setRow(int n, int n2, byte[] byArray) {
        if (n < 0 || n >= this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (n2 < 0 || n2 + byArray.length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int n3 = n2;
        int n4 = byArray.length + n2;
        while (n3 < n4) {
            this.data[n][n3] = byArray[n3 - n2];
            ++n3;
        }
    }

    public void setCell(int n, int n2, byte by) {
        this.data[n][n2] = by;
    }

    public int getCell(int n, int n2) {
        return this.data[n][n2];
    }

    public void randomize() {
        Random random = new Random();
        int n = 0;
        int n2 = this.data.length;
        while (n < n2) {
            int n3 = 0;
            int n4 = this.data[0].length;
            while (n3 < n4) {
                this.data[n][n3] = (byte)random.nextInt(256);
                ++n3;
            }
            ++n;
        }
    }

    public void showLegend() {
        InteractivePanel interactivePanel = new InteractivePanel();
        interactivePanel.setPreferredSize(new Dimension(300, 66));
        interactivePanel.setPreferredGutters(0, 0, 0, 35);
        interactivePanel.setClipAtGutter(false);
        if (this.legendFrame == null || !this.legendFrame.isDisplayable()) {
            this.legendFrame = new JFrame(DisplayRes.getString("GUIUtils.Legend"));
        }
        this.legendFrame.setDefaultCloseOperation(2);
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(interactivePanel);
        TriangularByteLattice triangularByteLattice = new TriangularByteLattice(1, 256);
        triangularByteLattice.setMinMax(-128.0, 127.0, 0.0, 1.0);
        byte[][] byArray = new byte[1][256];
        int n = 0;
        while (n < 256) {
            byArray[0][n] = (byte)n;
            ++n;
        }
        triangularByteLattice.setBlock(0, 0, byArray);
        interactivePanel.addDrawable(triangularByteLattice);
        XAxis xAxis = new XAxis("");
        xAxis.setLocationType(2);
        xAxis.setLocation(-0.5);
        xAxis.setEnabled(true);
        interactivePanel.addDrawable(xAxis);
        this.legendFrame.pack();
        this.legendFrame.setVisible(true);
    }

    public void setColorPalette(Color[] colorArray) {
        int n = 0;
        int n2 = colorArray.length;
        while (n < n2) {
            this.colors[n] = colorArray[n];
            ++n;
        }
        n = colorArray.length;
        while (n < 256) {
            this.colors[n] = Color.black;
            ++n;
        }
    }

    public void setIndexedColor(int n, Color color) {
        n = (n + 256) % this.colors.length;
        this.colors[n] = color;
    }

    public boolean isMeasured() {
        return true;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMax() {
        return this.ymax;
    }

    public void createDefaultColors() {
        int n = 0;
        while (n < 256) {
            Color color;
            this.colors[n] = color = Color.getHSBColor((-0.07f + 0.8f * (float)n / 255.0f) % 1.0f, 1.0f, 1.0f);
            ++n;
        }
    }
}

