/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.core;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Camera;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.VisualizationHints;
import org.opensourcephysics.display3d.core.interaction.InteractionSource;
import org.opensourcephysics.tools.VideoTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DrawingPanel3D
extends InteractionSource {
    public static final int TARGET_PANEL = 0;
    public static final int BOTTOM_LEFT = 0;
    public static final int BOTTOM_RIGHT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int TOP_LEFT = 3;
    public static final int MODE_XYZ = 0;
    public static final int MODE_YXZ = 1;
    public static final int MODE_XZY = 2;
    public static final int MODE_YZX = 3;
    public static final int MODE_ZYX = 4;
    public static final int MODE_ZXY = 5;
    public static final int BACKGROUND = 0;
    public static final int AMBIENT_LIGHT = 1;
    public static final int DIRECTIONAL_LIGHT = 2;
    public static final int POINT_LIGHT = 3;
    public static final int SPOT_LIGHT = 4;

    public Component getComponent();

    public void setBackgroundImage(String var1);

    public String getBackgroundImage();

    public void setPreferredMinMax(double var1, double var3, double var5, double var7, double var9, double var11);

    public double getPreferredMinX();

    public double getPreferredMaxX();

    public double getPreferredMinY();

    public double getPreferredMaxY();

    public double getPreferredMinZ();

    public double getPreferredMaxZ();

    public void setScaleFactor(double var1, double var3, double var5);

    public double getScaleFactorX();

    public double getScaleFactorY();

    public double getScaleFactorZ();

    public void setAxesMode(int var1);

    public int getAxesMode();

    public void zoomToFit();

    public void setSquareAspect(boolean var1);

    public boolean isSquareAspect();

    public VisualizationHints getVisualizationHints();

    public Camera getCamera();

    public VideoTool getVideoTool();

    public void setVideoTool(VideoTool var1);

    public BufferedImage render();

    public BufferedImage render(BufferedImage var1);

    public void repaint();

    public void addElement(Element var1);

    public void removeElement(Element var1);

    public void removeAllElements();

    public List<Element> getElements();

    public void setLightEnabled(boolean var1, int var2);

    public static abstract class Loader
    implements XML.ObjectLoader {
        public abstract Object createObject(XMLControl var1);

        public void saveObject(XMLControl xMLControl, Object object) {
            DrawingPanel3D drawingPanel3D = (DrawingPanel3D)object;
            xMLControl.setValue("preferred x min", drawingPanel3D.getPreferredMinX());
            xMLControl.setValue("preferred x max", drawingPanel3D.getPreferredMaxX());
            xMLControl.setValue("preferred y min", drawingPanel3D.getPreferredMinY());
            xMLControl.setValue("preferred y max", drawingPanel3D.getPreferredMaxY());
            xMLControl.setValue("preferred z min", drawingPanel3D.getPreferredMinZ());
            xMLControl.setValue("preferred z max", drawingPanel3D.getPreferredMaxZ());
            xMLControl.setValue("visualization hints", drawingPanel3D.getVisualizationHints());
            xMLControl.setValue("camera", drawingPanel3D.getCamera());
            xMLControl.setValue("elements", drawingPanel3D.getElements());
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            DrawingPanel3D drawingPanel3D = (DrawingPanel3D)object;
            double d = xMLControl.getDouble("preferred x min");
            double d2 = xMLControl.getDouble("preferred x max");
            double d3 = xMLControl.getDouble("preferred y min");
            double d4 = xMLControl.getDouble("preferred y max");
            double d5 = xMLControl.getDouble("preferred z min");
            double d6 = xMLControl.getDouble("preferred z max");
            drawingPanel3D.setPreferredMinMax(d, d2, d3, d4, d5, d6);
            Collection collection = (Collection)Collection.class.cast(xMLControl.getObject("elements"));
            if (collection != null) {
                drawingPanel3D.removeAllElements();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    drawingPanel3D.addElement((Element)iterator.next());
                }
            }
            return object;
        }
    }
}

