/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.Object3D;

public class InteractiveText
extends AbstractInteractiveElement {
    private double a1 = 0.0;
    private double b1 = 0.0;
    private double[] coordinates = new double[3];
    private double[] pixelOrigin = new double[3];
    private Object3D[] objects = new Object3D[]{new Object3D(this, 0)};

    public InteractiveText() {
        this("");
    }

    public InteractiveText(String string) {
        this.style.setFont(new Font("Dialog", 0, 18));
        this.style.setDisplayObject(string);
        this.sizeEnabled = false;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged || drawingPanel != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel);
        }
        if (this.positionEnabled && Math.abs(this.pixelOrigin[0] - (double)n) < 5.0 && Math.abs(this.pixelOrigin[1] - (double)n2) < 5.0) {
            return new InteractionTargetElementPosition(this);
        }
        return null;
    }

    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged || drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        return this.objects;
    }

    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        Color color = drawingPanel3D.projectColor(this.style.edgeColor, this.objects[0].distance);
        Paint paint = this.style.fillPattern;
        if (paint instanceof Color) {
            paint = drawingPanel3D.projectColor((Color)paint, this.objects[0].distance);
        }
        this.drawIt(graphics2D, color, paint);
    }

    public void drawQuickly(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D) {
        if (!this.visible) {
            return;
        }
        if (this.hasChanged || drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        this.drawIt(graphics2D, this.style.edgeColor, this.style.fillPattern);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        this.projectPoints(drawingPanel);
        this.drawIt((Graphics2D)graphics, this.style.edgeColor, this.style.fillPattern);
    }

    protected void projectPoints(DrawingPanel drawingPanel) {
        if (this.group != null) {
            this.coordinates[0] = this.group.x + this.x * this.group.sizex;
            this.coordinates[1] = this.group.y + this.y * this.group.sizey;
            this.coordinates[2] = this.group.z + this.z * this.group.sizez;
        } else {
            this.coordinates[0] = this.x;
            this.coordinates[1] = this.y;
            this.coordinates[2] = this.z;
        }
        drawingPanel.project(this.coordinates, this.pixelOrigin);
        this.objects[0].distance = this.pixelOrigin[2];
        this.a1 = this.pixelOrigin[0];
        this.b1 = this.pixelOrigin[1];
        if (this.style.displayObject != null) {
            FontMetrics fontMetrics = this.style.font != null ? drawingPanel.getFontMetrics(this.style.font) : drawingPanel.getFontMetrics(drawingPanel.getFont());
            int n = fontMetrics.stringWidth(this.style.displayObject.toString());
            int n2 = fontMetrics.getHeight() / 2;
            switch (this.style.position) {
                default: {
                    this.a1 -= (double)n / 2.0;
                    this.b1 += (double)n2 / 2.0;
                    break;
                }
                case 1: {
                    this.a1 -= (double)n / 2.0;
                    this.b1 += (double)n2;
                    break;
                }
                case 2: {
                    this.a1 -= (double)n / 2.0;
                    break;
                }
                case 3: {
                    this.a1 -= (double)n;
                    this.b1 += (double)n2 / 2.0;
                    break;
                }
                case 5: {
                    this.a1 -= (double)n;
                    this.b1 += (double)n2;
                    break;
                }
                case 7: {
                    this.a1 -= (double)n;
                    break;
                }
                case 4: {
                    this.b1 += (double)n2 / 2.0;
                    break;
                }
                case 6: {
                    this.b1 += (double)n2;
                }
                case 8: 
            }
        }
        this.hasChanged = false;
        this.panelWithValidProjection = drawingPanel;
    }

    private void drawIt(Graphics2D graphics2D, Color color, Paint paint) {
        if (this.style.displayObject == null) {
            return;
        }
        if (this.style.font != null) {
            graphics2D.setFont(this.style.font);
        }
        graphics2D.setColor(color);
        graphics2D.drawString(this.style.displayObject.toString(), (int)this.a1, (int)this.b1);
    }
}

