/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.ObjectValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ConstantParser {
    public static final Color NULL_COLOR = new Color(0, 0, 0, 0);
    private static Font defaultFont = new Font("Dialog", 12, 0);

    public static Value fontConstant(Font font, String string) {
        if (string.indexOf(44) < 0) {
            return null;
        }
        if (font == null) {
            font = defaultFont;
        }
        int n = font.getStyle();
        int n2 = font.getSize();
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals(",")) {
                string2 = font.getName();
            } else if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
        } else {
            string2 = font.getName();
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().toLowerCase();
            n = font.getStyle();
            if (!string3.equals(",")) {
                if (string3.indexOf("plain") != -1) {
                    n = 0;
                }
                if (string3.indexOf("bold") != -1) {
                    n = 1;
                }
                if (string3.indexOf("italic") != -1) {
                    n |= 2;
                }
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                }
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            try {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                n2 = font.getSize();
            }
        }
        return new ObjectValue(new Font(string2, n, n2));
    }

    public static Value booleanConstant(String string) {
        if (string.equals("true")) {
            return new BooleanValue(true);
        }
        if (string.equals("false")) {
            return new BooleanValue(false);
        }
        return null;
    }

    public static Value colorConstant(String string) {
        if (string.indexOf(44) >= 0) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":,");
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                int n4 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 255;
                if (n < 0) {
                    n = 0;
                } else if (n > 255) {
                    n = 255;
                }
                if (n2 < 0) {
                    n2 = 0;
                } else if (n2 > 255) {
                    n2 = 255;
                }
                if (n3 < 0) {
                    n3 = 0;
                } else if (n3 > 255) {
                    n3 = 255;
                }
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 > 255) {
                    n4 = 255;
                }
                return new ObjectValue(new Color(n, n2, n3, n4));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        if (string.equals("null") || string.equals("none")) {
            return new ObjectValue(NULL_COLOR);
        }
        if (string.equals("black") || string.equals("Color.black")) {
            return new ObjectValue(Color.black);
        }
        if (string.equals("blue") || string.equals("Color.blue")) {
            return new ObjectValue(Color.blue);
        }
        if (string.equals("cyan") || string.equals("Color.cyan")) {
            return new ObjectValue(Color.cyan);
        }
        if (string.equals("darkGray") || string.equals("Color.darkGray")) {
            return new ObjectValue(Color.darkGray);
        }
        if (string.equals("gray") || string.equals("Color.gray")) {
            return new ObjectValue(Color.gray);
        }
        if (string.equals("green") || string.equals("Color.green")) {
            return new ObjectValue(Color.green);
        }
        if (string.equals("lightGray") || string.equals("Color.lightGray")) {
            return new ObjectValue(Color.lightGray);
        }
        if (string.equals("magenta") || string.equals("Color.magenta")) {
            return new ObjectValue(Color.magenta);
        }
        if (string.equals("orange") || string.equals("Color.orange")) {
            return new ObjectValue(Color.orange);
        }
        if (string.equals("pink") || string.equals("Color.pink")) {
            return new ObjectValue(Color.pink);
        }
        if (string.equals("red") || string.equals("Color.red")) {
            return new ObjectValue(Color.red);
        }
        if (string.equals("white") || string.equals("Color.white")) {
            return new ObjectValue(Color.white);
        }
        if (string.equals("yellow") || string.equals("Color.yellow")) {
            return new ObjectValue(Color.yellow);
        }
        return null;
    }

    public static Value formatConstant(String string) {
        if (string.indexOf(";") == -1) {
            int n = string.indexOf("0");
            int n2 = string.indexOf("#");
            int n3 = -1;
            if (n > 0 && n2 > 0) {
                n3 = n < n2 ? n : n2;
            } else if (n > 0) {
                n3 = n;
            } else if (n2 > 0) {
                n3 = n2;
            }
            if (n3 > 0) {
                string = String.valueOf(string) + ";" + string.substring(0, n3) + "-" + string.substring(n3);
            }
        }
        try {
            return new ObjectValue(new DecimalFormat(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static Value rectangleConstant(String string) {
        if (string.indexOf(44) < 0) {
            return null;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            return new ObjectValue(new Rectangle(n, n2, n3, n4));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

