/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.awt.Frame;
import java.util.Collection;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.ParsableTextArea;
import org.opensourcephysics.controls.VariableNotFoundException;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.GroupControl;
import org.opensourcephysics.ejs.control.swing.ControlInputArea;
import org.opensourcephysics.ejs.control.swing.ControlTextArea;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjsControl
extends GroupControl
implements Control {
    static String _RETURN_ = System.getProperty("line.separator");
    private ControlTextArea messageArea = null;
    private ParsableTextArea inputArea = null;
    private StringValue strValue = new StringValue("");

    public EjsControl(Object object) {
        super(object);
    }

    public EjsControl(Object object, String string, Frame frame) {
        super(object, string, frame);
    }

    public EjsControl() {
    }

    @Override
    public ControlElement addObject(Object object, String string, String string2) {
        ControlElement controlElement = super.addObject(object, string, string2);
        if (controlElement instanceof ControlTextArea) {
            this.messageArea = (ControlTextArea)controlElement;
        } else if (controlElement instanceof ControlInputArea) {
            this.inputArea = (ParsableTextArea)((ControlInputArea)controlElement).getVisual();
        }
        return controlElement;
    }

    @Override
    public void reset() {
        this.clearValues();
        this.clearMessages();
        super.reset();
    }

    @Override
    public void setLockValues(boolean bl) {
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.variableTable.keySet();
    }

    @Override
    public void clearValues() {
        if (this.inputArea != null) {
            this.inputArea.setText("");
            this.inputArea.setCaretPosition(this.inputArea.getText().length());
        }
    }

    @Override
    public void clearMessages() {
        if (this.messageArea != null) {
            this.messageArea.clear();
        }
    }

    @Override
    public void println(String string) {
        this.print(String.valueOf(string) + _RETURN_);
    }

    @Override
    public void println() {
        this.println("");
    }

    @Override
    public void print(String string) {
        if (this.messageArea != null) {
            this.messageArea.print(string);
        } else {
            System.out.print(string);
        }
    }

    @Override
    public void calculationDone(String string) {
        this.println(string);
    }

    @Override
    public void setValue(String string, Value value) {
        if (!this.isVariableRegistered(string) && this.inputArea != null) {
            this.inputArea.setValue(string, value.getString());
        } else {
            super.setValue(string, value);
        }
    }

    @Override
    public Value getValue(String string) {
        if (!this.isVariableRegistered(string) && this.inputArea != null) {
            try {
                this.strValue.value = this.inputArea.getValue(string);
                return this.strValue;
            }
            catch (VariableNotFoundException variableNotFoundException) {}
        }
        return super.getValue(string);
    }
}

