/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlComboBox
extends ControlSwingElement {
    private static final int VARIABLE = 0;
    private static final int FOREGROUND = 12;
    protected JComboBox combo;
    private Component editorComponent;
    private String optionsString;
    private StringValue internalValue;
    private boolean defaultValueSet;
    private boolean defaultEditable;
    private boolean doNotUpdate = false;
    private String defaultValue;
    private Color defaultColor;
    private Color editingColor;
    private static ArrayList<String> infoList = null;

    public ControlComboBox(Object object) {
        super(object);
    }

    @Override
    protected Component createVisual(Object object) {
        this.combo = object instanceof JComboBox ? (JComboBox)object : new JComboBox();
        this.defaultEditable = this.combo.isEditable();
        this.combo.addActionListener(new MyActionListener());
        this.editorComponent = this.combo.getEditor().getEditorComponent();
        this.editorComponent.addKeyListener(new MyKeyListener());
        this.defaultValue = "";
        this.defaultValueSet = false;
        this.internalValue = new StringValue(this.defaultValue);
        this.decideColors(this.editorComponent.getBackground());
        return this.combo;
    }

    @Override
    public void reset() {
        if (this.defaultValueSet) {
            this.setTheValue(this.defaultValue);
            this.setInternalValue(this.defaultValue);
        }
    }

    private void setTheValue(String string) {
        if (this.internalValue.value != null && this.internalValue.value.equals(string)) {
            return;
        }
        this.internalValue.value = string;
        this.combo.setSelectedItem(this.internalValue.value);
        this.setColor(this.defaultColor);
    }

    private void setInternalValue(String string) {
        this.internalValue.value = string;
        this.variableChanged(0, this.internalValue);
        this.invokeActions();
    }

    private void setTheOptions(String string) {
        if (string == null) {
            if (this.optionsString != null) {
                this.combo.removeAllItems();
                this.optionsString = null;
            }
            return;
        }
        if (string.equals(this.optionsString)) {
            return;
        }
        this.doNotUpdate = true;
        this.combo.removeAllItems();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            this.combo.addItem(stringTokenizer.nextToken());
        }
        this.optionsString = string;
        this.doNotUpdate = false;
        if (this.combo.getItemCount() > 0) {
            this.setTheValue(this.combo.getItemAt(0).toString());
        }
    }

    @Override
    public ArrayList<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("variable");
            infoList.add("options");
            infoList.add("value");
            infoList.add("editable");
            infoList.add("editBackground");
            infoList.add("action");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("variable")) {
            return "String VARIABLE_EXPECTED";
        }
        if (string.equals("options")) {
            return "String PREVIOUS TRANSLATABLE";
        }
        if (string.equals("value")) {
            return "String CONSTANT";
        }
        if (string.equals("editable")) {
            return "boolean";
        }
        if (string.equals("editBackground")) {
            return "Color|Object";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.setTheValue(value.getString());
                break;
            }
            case 1: {
                this.setTheOptions(value.getString());
                break;
            }
            case 2: {
                this.defaultValueSet = true;
                this.defaultValue = value.getString();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 3: {
                this.combo.setEditable(value.getBoolean());
                break;
            }
            case 4: {
                if (value.getObject() instanceof Color) {
                    this.editorComponent.setBackground((Color)value.getObject());
                }
                this.decideColors(this.editorComponent.getBackground());
                break;
            }
            case 5: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            default: {
                super.setValue(n - 6, value);
                break;
            }
            case 12: {
                super.setValue(6, value);
                if (!(value.getObject() instanceof Color)) break;
                this.editorComponent.setForeground((Color)value.getObject());
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.setTheOptions(null);
                break;
            }
            case 2: {
                this.defaultValueSet = false;
                break;
            }
            case 3: {
                this.combo.setEditable(this.defaultEditable);
                break;
            }
            case 4: {
                this.editorComponent.setBackground(Color.white);
                this.decideColors(this.editorComponent.getBackground());
                break;
            }
            case 5: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            default: {
                super.setDefaultValue(n - 6);
                break;
            }
            case 12: {
                super.setDefaultValue(6);
                this.editorComponent.setForeground(Color.black);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        return super.getValue(n - 6);
    }

    private void setColor(Color color) {
        if (this.combo.isEditable()) {
            this.editorComponent.setBackground(color);
        }
    }

    private void decideColors(Color color) {
        if (color == null) {
            return;
        }
        this.defaultColor = color;
        this.editingColor = this.defaultColor.equals(Color.yellow) ? Color.orange : Color.yellow;
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ControlComboBox.this.doNotUpdate) {
                return;
            }
            ControlComboBox.this.setInternalValue((String)ControlComboBox.this.combo.getSelectedItem());
            ControlComboBox.this.setColor(ControlComboBox.this.defaultColor);
        }
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 0);
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 1);
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 2);
        }

        private void processKeyEvent(KeyEvent keyEvent, int n) {
            if (!ControlComboBox.this.combo.isEditable()) {
                return;
            }
            if (keyEvent.getKeyChar() != '\n') {
                ControlComboBox.this.setColor(ControlComboBox.this.editingColor);
            }
            if (keyEvent.getKeyCode() == 27) {
                ControlComboBox.this.setValue(0, ControlComboBox.this.internalValue);
            }
        }
    }
}

