/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JTextField;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlNumberField
extends ControlSwingElement {
    private static final int VARIABLE = 0;
    private static final int BACKGROUND = 12;
    protected static final DecimalFormat defaultFormat = new DecimalFormat("0.000;-0.000");
    protected JTextField textfield;
    protected DoubleValue internalValue;
    protected double defaultValue;
    protected boolean defaultValueSet;
    protected DecimalFormat format;
    protected Color defaultColor;
    protected Color editingColor;
    protected Color errorColor;
    private static ArrayList<String> infoList = null;

    public ControlNumberField(Object object) {
        super(object);
    }

    @Override
    protected Component createVisual(Object object) {
        this.textfield = object instanceof JTextField ? (JTextField)object : new JTextField();
        this.format = defaultFormat;
        this.defaultValue = 0.0;
        this.defaultValueSet = false;
        this.internalValue = new DoubleValue(this.defaultValue);
        this.textfield.setText(this.format.format(this.internalValue.value));
        this.textfield.addActionListener(new MyActionListener());
        this.textfield.addKeyListener(new MyKeyListener());
        this.decideColors(this.textfield.getBackground());
        return this.textfield;
    }

    @Override
    public void reset() {
        if (this.defaultValueSet) {
            this.setTheValue(this.defaultValue);
            this.setInternalValue(this.defaultValue);
        }
    }

    private void setTheValue(double d) {
        if (d != this.internalValue.value) {
            this.internalValue.value = d;
            this.textfield.setText(this.format.format(d));
            this.setColor(this.defaultColor);
        }
    }

    protected void setInternalValue(double d) {
        this.internalValue.value = d;
        this.variableChanged(0, this.internalValue);
        this.invokeActions();
    }

    @Override
    public ArrayList<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("variable");
            infoList.add("value");
            infoList.add("editable");
            infoList.add("format");
            infoList.add("action");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("variable")) {
            return "int|double";
        }
        if (string.equals("value")) {
            return "int|double";
        }
        if (string.equals("editable")) {
            return "boolean";
        }
        if (string.equals("format")) {
            return "Format|Object TRANSLATABLE";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.setTheValue(value.getDouble());
                break;
            }
            case 1: {
                this.defaultValueSet = true;
                this.defaultValue = value.getDouble();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 2: {
                this.textfield.setEditable(value.getBoolean());
                break;
            }
            case 3: {
                if (!(value.getObject() instanceof DecimalFormat)) break;
                if (this.format == (DecimalFormat)value.getObject()) {
                    return;
                }
                this.format = (DecimalFormat)value.getObject();
                this.setActive(false);
                try {
                    this.setInternalValue(this.format.parse(this.textfield.getText()).doubleValue());
                }
                catch (Exception exception) {}
                this.setActive(true);
                this.textfield.setText(this.format.format(this.internalValue.value));
                break;
            }
            case 4: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 12: {
                super.setValue(7, value);
                this.decideColors(this.getVisual().getBackground());
                break;
            }
            default: {
                super.setValue(n - 5, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.defaultValueSet = false;
                break;
            }
            case 2: {
                this.textfield.setEditable(true);
                break;
            }
            case 3: {
                this.format = defaultFormat;
                this.setActive(false);
                try {
                    this.setInternalValue(this.format.parse(this.textfield.getText()).doubleValue());
                }
                catch (Exception exception) {}
                this.setActive(true);
                this.textfield.setText(this.format.format(this.internalValue.value));
                break;
            }
            case 4: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 12: {
                super.setDefaultValue(7);
                this.decideColors(this.getVisual().getBackground());
                break;
            }
            default: {
                super.setDefaultValue(n - 5);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(n - 5);
    }

    protected void setColor(Color color) {
        if (this.textfield.isEditable()) {
            this.getVisual().setBackground(color);
        }
    }

    protected void decideColors(Color color) {
        if (color == null) {
            return;
        }
        this.defaultColor = color;
        this.editingColor = this.defaultColor.equals(Color.yellow) ? Color.orange : Color.yellow;
        this.errorColor = this.defaultColor.equals(Color.red) ? Color.magenta : Color.red;
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlNumberField.this.setColor(ControlNumberField.this.defaultColor);
            try {
                ControlNumberField.this.setInternalValue(ControlNumberField.this.format.parse(ControlNumberField.this.textfield.getText()).doubleValue());
            }
            catch (Exception exception) {
                ControlNumberField.this.setColor(ControlNumberField.this.errorColor);
            }
        }
    }

    protected class MyKeyListener
    implements KeyListener {
        protected MyKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 0);
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 1);
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 2);
        }

        private void processKeyEvent(KeyEvent keyEvent, int n) {
            if (!ControlNumberField.this.textfield.isEditable()) {
                return;
            }
            if (keyEvent.getKeyChar() != '\n') {
                ControlNumberField.this.setColor(ControlNumberField.this.editingColor);
            }
            if (keyEvent.getKeyCode() == 27) {
                ControlNumberField.this.setValue(0, ControlNumberField.this.internalValue);
            }
        }
    }
}

