/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AxisFactory;
import org.opensourcephysics.display.axes.CartesianAxes;
import org.opensourcephysics.display.axes.CartesianType1;
import org.opensourcephysics.display.axes.CartesianType2;
import org.opensourcephysics.display.axes.CartesianType3;
import org.opensourcephysics.display.axes.DrawableAxes;
import org.opensourcephysics.display.axes.PolarAxes;
import org.opensourcephysics.display.axes.PolarType1;
import org.opensourcephysics.display.axes.PolarType2;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionTarget;
import org.opensourcephysics.displayejs.Point3D;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.swing.ControlDrawable;
import org.opensourcephysics.ejs.control.swing.ControlDrawablesParent;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlPlottingPanel
extends ControlDrawablesParent
implements InteractiveMouseHandler {
    protected static final int ADDEDBYPLOTTINGPANEL = 28;
    static final int FONT = 36;
    private static final int[] posIndex = new int[]{18, 19};
    protected PlottingPanel plottingPanel;
    private String title;
    private String titleFontname;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private Rectangle myGutters;
    private DrawableAxes axes;
    private boolean axisGridX;
    private boolean axisGridY;
    private boolean xaxisLog;
    private boolean yaxisLog;
    private int axesType;
    private double xaxisPos;
    private double yaxisPos;
    private double deltaR;
    private double deltaTheta;
    private String xLabel;
    private String yLabel;
    private String labelFontname;
    private DoubleValue[] posValues = new DoubleValue[]{new DoubleValue(0.0), new DoubleValue(0.0)};
    private static ArrayList infoList = null;
    private InteractionTarget targetHit = null;

    public ControlPlottingPanel(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        if (object instanceof PlottingPanel) {
            this.plottingPanel = (PlottingPanel)object;
        } else {
            this.plottingPanel = new PlottingPanel("", "", "");
            this.plottingPanel.enableInspector(false);
            this.plottingPanel.setSquareAspect(false);
            this.plottingPanel.setAutoscaleX(true);
            this.plottingPanel.setAutoscaleY(true);
        }
        this.plottingPanel.removeOptionController();
        this.axes = this.plottingPanel.getAxes();
        this.axes.setVisible(true);
        this.axisGridX = true;
        this.axes.setShowMajorXGrid(true);
        this.axisGridY = true;
        this.axes.setShowMajorYGrid(true);
        this.yaxisLog = false;
        this.xaxisLog = false;
        this.deltaR = 1.0;
        this.deltaTheta = 0.39269908169872414;
        if (this.axes instanceof CartesianAxes) {
            this.xaxisLog = ((CartesianAxes)this.axes).isXLog();
            this.yaxisLog = ((CartesianAxes)this.axes).isYLog();
            this.axesType = this.axes instanceof CartesianType1 ? 1 : (this.axes instanceof CartesianType2 ? 2 : (this.axes instanceof CartesianType3 ? 3 : 1));
        } else if (this.axes instanceof PolarAxes) {
            this.deltaR = ((PolarAxes)this.axes).getDeltaR();
            this.deltaTheta = ((PolarAxes)this.axes).getDeltaTheta();
            this.axesType = this.axes instanceof PolarType1 ? 4 : (this.axes instanceof PolarType2 ? 5 : 4);
        } else {
            this.axesType = 0;
        }
        this.minX = this.plottingPanel.getXMin();
        this.maxX = this.plottingPanel.getXMax();
        this.minY = this.plottingPanel.getYMin();
        this.maxY = this.plottingPanel.getYMax();
        this.plottingPanel.setInteractiveMouseHandler(this);
        return this.plottingPanel;
    }

    protected int[] getPosIndex() {
        return posIndex;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("title");
            infoList.add("titleFont");
            infoList.add("axesType");
            infoList.add("titleX");
            infoList.add("titleY");
            infoList.add("xaxisType");
            infoList.add("yaxisType");
            infoList.add("deltaR");
            infoList.add("deltaTheta");
            infoList.add("interiorBackground");
            infoList.add("majorTicksX");
            infoList.add("majorTicksY");
            infoList.add("autoscaleX");
            infoList.add("autoscaleY");
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("x");
            infoList.add("y");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("square");
            infoList.add("showCoordinates");
            infoList.add("gutters");
            infoList.add("xaxisPos");
            infoList.add("yaxisPos");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("title")) {
            return "String";
        }
        if (string.equals("titleFont")) {
            return "Font|Object BASIC";
        }
        if (string.equals("axesType")) {
            return "int|AxesType BASIC";
        }
        if (string.equals("titleX")) {
            return "String";
        }
        if (string.equals("titleY")) {
            return "String";
        }
        if (string.equals("xaxisType")) {
            return "int|CartesianAxisType BASIC";
        }
        if (string.equals("yaxisType")) {
            return "int|CartesianAxisType BASIC";
        }
        if (string.equals("deltaR")) {
            return "int|double BASIC";
        }
        if (string.equals("deltaTheta")) {
            return "int|double BASIC";
        }
        if (string.equals("interiorBackground")) {
            return "Color|Object BASIC";
        }
        if (string.equals("majorTicksX")) {
            return "boolean BASIC";
        }
        if (string.equals("majorTicksY")) {
            return "boolean BASIC";
        }
        if (string.equals("autoscaleX")) {
            return "boolean";
        }
        if (string.equals("autoscaleY")) {
            return "boolean";
        }
        if (string.equals("minimumX")) {
            return "int|double";
        }
        if (string.equals("maximumX")) {
            return "int|double";
        }
        if (string.equals("minimumY")) {
            return "int|double";
        }
        if (string.equals("maximumY")) {
            return "int|double";
        }
        if (string.equals("x")) {
            return "int|double";
        }
        if (string.equals("y")) {
            return "int|double";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("square")) {
            return "boolean BASIC";
        }
        if (string.equals("showCoordinates")) {
            return "boolean BASIC";
        }
        if (string.equals("gutters")) {
            return "Margins|Object BASIC";
        }
        if (string.equals("xaxisPos")) {
            return "int|double BASIC";
        }
        if (string.equals("yaxisPos")) {
            return "int|double BASIC";
        }
        return super.getPropertyInfo(string);
    }

    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("CartesianAxisType") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("linear")) {
                return new IntegerValue(0);
            }
            if (string2.equals("log10")) {
                return new IntegerValue(1);
            }
        }
        if (string.indexOf("AxesType") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("cartesian1")) {
                return new IntegerValue(1);
            }
            if (string2.equals("cartesian2")) {
                return new IntegerValue(2);
            }
            if (string2.equals("cartesian3")) {
                return new IntegerValue(3);
            }
            if (string2.equals("polar1")) {
                return new IntegerValue(4);
            }
            if (string2.equals("polar2")) {
                return new IntegerValue(5);
            }
        }
        return super.parseConstant(string, string2);
    }

    public ControlElement setProperty(String string, String string2) {
        if ((string = string.trim()).equals("xaxis")) {
            return super.setProperty("xaxisPos", string2);
        }
        if (string.equals("yaxis")) {
            return super.setProperty("yaxisPos", string2);
        }
        return super.setProperty(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.title = value.getString();
                this.plottingPanel.setTitle(this.title, this.titleFontname);
                break;
            }
            case 1: {
                if (!(value.getObject() instanceof Font)) break;
                Font font = (Font)value.getObject();
                this.titleFontname = font.getFamily();
                if (font.isPlain()) {
                    this.titleFontname = String.valueOf(this.titleFontname) + "-PLAIN";
                } else if (font.isItalic()) {
                    this.titleFontname = font.isBold() ? String.valueOf(this.titleFontname) + "-BOLDITALIC" : String.valueOf(this.titleFontname) + "-ITALIC";
                } else if (font.isBold()) {
                    this.titleFontname = String.valueOf(this.titleFontname) + "-BOLD";
                }
                this.titleFontname = String.valueOf(this.titleFontname) + "-" + font.getSize();
                if (this.title == null) break;
                this.axes.setTitle(this.title, this.titleFontname);
                break;
            }
            case 2: {
                if (this.axesType == value.getInteger()) break;
                this.axesType = value.getInteger();
                switch (this.axesType) {
                    default: {
                        this.axes = AxisFactory.createAxesType1(this.plottingPanel);
                        ((CartesianType1)this.axes).setXLog(this.xaxisLog);
                        ((CartesianType1)this.axes).setYLog(this.yaxisLog);
                        break;
                    }
                    case 2: {
                        this.axes = AxisFactory.createAxesType2(this.plottingPanel);
                        ((CartesianType2)this.axes).setXLog(this.xaxisLog);
                        ((CartesianType2)this.axes).setYLog(this.yaxisLog);
                        break;
                    }
                    case 3: {
                        this.axes = AxisFactory.createAxesType3(this.plottingPanel);
                        ((CartesianType3)this.axes).setXLog(this.xaxisLog);
                        ((CartesianType3)this.axes).setYLog(this.yaxisLog);
                        break;
                    }
                    case 4: {
                        this.axes = new PolarType1(this.plottingPanel);
                        ((PolarAxes)this.axes).setDeltaR(this.deltaR);
                        ((PolarAxes)this.axes).setDeltaTheta(this.deltaTheta);
                        break;
                    }
                    case 5: {
                        this.axes = new PolarType2(this.plottingPanel);
                        ((PolarAxes)this.axes).setDeltaR(this.deltaR);
                        ((PolarAxes)this.axes).setDeltaTheta(this.deltaTheta);
                    }
                }
                if (this.xLabel != null) {
                    this.axes.setXLabel(this.xLabel, this.labelFontname);
                }
                if (this.yLabel != null) {
                    this.axes.setYLabel(this.yLabel, this.labelFontname);
                }
                if (this.title != null) {
                    this.axes.setTitle(this.title, this.titleFontname);
                }
                this.axes.setShowMajorXGrid(this.axisGridX);
                this.axes.setShowMajorYGrid(this.axisGridY);
                if (this.axes instanceof CartesianAxes) {
                    ((CartesianAxes)this.axes).setX(this.xaxisPos);
                    ((CartesianAxes)this.axes).setY(this.yaxisPos);
                }
                this.plottingPanel.setAxes(this.axes);
                break;
            }
            case 3: {
                this.xLabel = value.getString();
                this.plottingPanel.setXLabel(this.xLabel, this.labelFontname);
                break;
            }
            case 4: {
                this.yLabel = value.getString();
                this.plottingPanel.setYLabel(this.yLabel, this.labelFontname);
                break;
            }
            case 5: {
                if (this.xaxisLog && value.getInteger() != 1) {
                    this.xaxisLog = false;
                    this.plottingPanel.setLogScale(false, this.yaxisLog);
                    break;
                }
                if (this.xaxisLog || value.getInteger() != 1) break;
                this.xaxisLog = true;
                this.plottingPanel.setLogScale(true, this.yaxisLog);
                break;
            }
            case 6: {
                if (this.yaxisLog && value.getInteger() != 1) {
                    this.yaxisLog = false;
                    this.plottingPanel.setLogScale(this.xaxisLog, false);
                    break;
                }
                if (this.yaxisLog || value.getInteger() != 1) break;
                this.yaxisLog = true;
                this.plottingPanel.setLogScale(this.xaxisLog, true);
                break;
            }
            case 7: {
                if (value.getDouble() == this.deltaR) break;
                this.deltaR = value.getDouble();
                if (!(this.axes instanceof PolarAxes)) break;
                ((PolarAxes)this.axes).setDeltaR(this.deltaR);
                break;
            }
            case 8: {
                if (value.getDouble() == this.deltaTheta) break;
                this.deltaTheta = value.getDouble();
                if (!(this.axes instanceof PolarAxes)) break;
                ((PolarAxes)this.axes).setDeltaTheta(this.deltaTheta);
                break;
            }
            case 9: {
                if (!(value.getObject() instanceof Color)) break;
                this.axes.setInteriorBackground((Color)value.getObject());
                break;
            }
            case 10: {
                this.axes.setShowMajorXGrid(value.getBoolean());
                break;
            }
            case 11: {
                this.axes.setShowMajorYGrid(value.getBoolean());
                break;
            }
            case 12: {
                this.plottingPanel.setAutoscaleX(value.getBoolean());
                break;
            }
            case 13: {
                this.plottingPanel.setAutoscaleY(value.getBoolean());
                break;
            }
            case 14: {
                if (value.getDouble() == this.minX) break;
                this.minX = value.getDouble();
                this.plottingPanel.setPreferredMinMaxX(this.minX, this.maxX);
                break;
            }
            case 15: {
                if (value.getDouble() == this.maxX) break;
                this.maxX = value.getDouble();
                this.plottingPanel.setPreferredMinMaxX(this.minX, this.maxX);
                break;
            }
            case 16: {
                if (value.getDouble() == this.minY) break;
                this.minY = value.getDouble();
                this.plottingPanel.setPreferredMinMaxY(this.minY, this.maxY);
                break;
            }
            case 17: {
                if (value.getDouble() == this.maxY) break;
                this.maxY = value.getDouble();
                this.plottingPanel.setPreferredMinMaxY(this.minY, this.maxY);
                break;
            }
            case 18: {
                this.posValues[0].value = value.getDouble();
                break;
            }
            case 19: {
                this.posValues[1].value = value.getDouble();
                break;
            }
            case 20: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, value.getString());
                break;
            }
            case 21: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, value.getString());
                break;
            }
            case 22: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 23: {
                this.plottingPanel.setSquareAspect(value.getBoolean());
                break;
            }
            case 24: {
                this.plottingPanel.setShowCoordinates(value.getBoolean());
                break;
            }
            case 25: {
                Rectangle rectangle;
                if (!(value.getObject() instanceof Rectangle) || (rectangle = (Rectangle)value.getObject()) == this.myGutters) break;
                this.plottingPanel.setPreferredGutters(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.myGutters = rectangle;
                break;
            }
            case 26: {
                if (this.xaxisPos == value.getDouble() || !(this.axes instanceof CartesianAxes)) break;
                this.xaxisPos = value.getDouble();
                ((CartesianAxes)this.axes).setX(this.xaxisPos);
                break;
            }
            case 27: {
                if (this.yaxisPos == value.getDouble() || !(this.axes instanceof CartesianAxes)) break;
                this.yaxisPos = value.getDouble();
                ((CartesianAxes)this.axes).setY(this.yaxisPos);
                break;
            }
            default: {
                super.setValue(n - 28, value);
                break;
            }
            case 36: {
                if (value.getObject() instanceof Font) {
                    Font font = (Font)value.getObject();
                    this.labelFontname = font.getFamily();
                    if (font.isPlain()) {
                        this.labelFontname = String.valueOf(this.labelFontname) + "-PLAIN";
                    } else if (font.isItalic()) {
                        this.labelFontname = font.isBold() ? String.valueOf(this.labelFontname) + "-BOLDITALIC" : String.valueOf(this.labelFontname) + "-ITALIC";
                    } else if (font.isBold()) {
                        this.labelFontname = String.valueOf(this.labelFontname) + "-BOLD";
                    }
                    this.labelFontname = String.valueOf(this.labelFontname) + "-" + font.getSize();
                    if (this.xLabel != null) {
                        this.axes.setXLabel(this.xLabel, this.labelFontname);
                    }
                    if (this.yLabel != null) {
                        this.axes.setYLabel(this.yLabel, this.labelFontname);
                    }
                }
                super.setValue(8, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.title = "";
                this.plottingPanel.setTitle("", this.titleFontname);
                break;
            }
            case 1: {
                this.titleFontname = "Helvetica-BOLD-14";
                if (this.title == null) break;
                this.axes.setTitle(this.title, this.titleFontname);
                break;
            }
            case 2: {
                this.axesType = 1;
                this.axes = AxisFactory.createAxesType1(this.plottingPanel);
                ((CartesianType1)this.axes).setXLog(this.xaxisLog);
                ((CartesianType1)this.axes).setYLog(this.yaxisLog);
                if (this.xLabel != null) {
                    this.axes.setXLabel(this.xLabel, this.labelFontname);
                }
                if (this.yLabel != null) {
                    this.axes.setYLabel(this.yLabel, this.labelFontname);
                }
                if (this.title != null) {
                    this.axes.setTitle(this.title, this.titleFontname);
                }
                this.axes.setShowMajorXGrid(this.axisGridX);
                this.axes.setShowMajorYGrid(this.axisGridY);
                break;
            }
            case 3: {
                this.xLabel = "";
                this.plottingPanel.setXLabel("", this.labelFontname);
                break;
            }
            case 4: {
                this.yLabel = "";
                this.plottingPanel.setYLabel("", this.labelFontname);
                break;
            }
            case 5: {
                this.xaxisLog = false;
                this.plottingPanel.setLogScale(false, this.yaxisLog);
                break;
            }
            case 6: {
                this.yaxisLog = false;
                this.plottingPanel.setLogScale(this.xaxisLog, false);
                break;
            }
            case 7: {
                this.deltaR = 1.0;
                if (!(this.axes instanceof PolarAxes)) break;
                ((PolarAxes)this.axes).setDeltaR(this.deltaR);
                break;
            }
            case 8: {
                this.deltaTheta = 0.39269908169872414;
                if (!(this.axes instanceof PolarAxes)) break;
                ((PolarAxes)this.axes).setDeltaTheta(this.deltaTheta);
                break;
            }
            case 9: {
                this.axes.setInteriorBackground(Color.white);
                break;
            }
            case 10: {
                this.axes.setShowMajorXGrid(true);
                break;
            }
            case 11: {
                this.axes.setShowMajorYGrid(true);
                break;
            }
            case 12: {
                this.plottingPanel.setAutoscaleX(false);
                break;
            }
            case 13: {
                this.plottingPanel.setAutoscaleY(false);
                break;
            }
            case 14: {
                this.minX = 0.0;
                this.plottingPanel.setPreferredMinMaxX(0.0, this.maxX);
                break;
            }
            case 15: {
                this.maxX = 1.0;
                this.plottingPanel.setPreferredMinMaxX(this.minX, 1.0);
                break;
            }
            case 16: {
                this.minY = 0.0;
                this.plottingPanel.setPreferredMinMaxY(0.0, this.maxY);
                break;
            }
            case 17: {
                this.maxY = 1.0;
                this.plottingPanel.setPreferredMinMaxY(this.minY, 1.0);
                break;
            }
            case 18: {
                this.posValues[0].value = (this.minX + this.maxX) / 2.0;
                break;
            }
            case 19: {
                this.posValues[1].value = (this.minY + this.maxY) / 2.0;
                break;
            }
            case 20: {
                this.removeAction(10, this.getProperty("pressaction"));
                break;
            }
            case 21: {
                this.removeAction(1, this.getProperty("dragaction"));
                break;
            }
            case 22: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 23: {
                this.plottingPanel.setSquareAspect(false);
                break;
            }
            case 24: {
                this.plottingPanel.setShowCoordinates(true);
                break;
            }
            case 25: {
                this.plottingPanel.setPreferredGutters(0, 0, 0, 0);
                this.myGutters = null;
                break;
            }
            case 26: {
                if (!(this.axes instanceof CartesianAxes)) break;
                this.xaxisPos = Double.NaN;
                ((CartesianAxes)this.axes).setX(Double.NaN);
                break;
            }
            case 27: {
                if (!(this.axes instanceof CartesianAxes)) break;
                this.yaxisPos = Double.NaN;
                ((CartesianAxes)this.axes).setY(Double.NaN);
                break;
            }
            default: {
                super.setDefaultValue(n - 28);
                break;
            }
            case 36: {
                this.labelFontname = "Helvetica-PLAIN-12";
                if (this.xLabel != null) {
                    this.axes.setXLabel(this.xLabel, this.labelFontname);
                }
                if (this.yLabel != null) {
                    this.axes.setYLabel(this.yLabel, this.labelFontname);
                }
                super.setDefaultValue(8);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return null;
            }
            case 18: {
                return this.posValues[0];
            }
            case 19: {
                return this.posValues[1];
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return null;
            }
        }
        return super.getValue(n - 28);
    }

    public ControlDrawable getSelectedDrawable() {
        if (this.targetHit != null && this.targetHit.getSource() instanceof ControlDrawable) {
            return (ControlDrawable)((Object)this.targetHit.getSource());
        }
        return null;
    }

    public void handleMouseAction(InteractivePanel interactivePanel, MouseEvent mouseEvent) {
        switch (interactivePanel.getMouseAction()) {
            case 1: {
                Interactive interactive = interactivePanel.getInteractive();
                if (interactive instanceof InteractionTarget) {
                    this.targetHit = (InteractionTarget)interactive;
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2000, null, this.targetHit));
                    break;
                }
                this.targetHit = null;
                this.mousePressed(interactivePanel.getMouseX(), interactivePanel.getMouseY());
                break;
            }
            case 3: {
                if (this.targetHit != null) {
                    Point3D point3D = new Point3D(interactivePanel.getMouseX(), interactivePanel.getMouseY(), 0.0);
                    this.targetHit.updateHotspot(interactivePanel, point3D);
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2001, null, this.targetHit));
                    interactivePanel.repaint();
                    break;
                }
                this.mouseDragged(interactivePanel.getMouseX(), interactivePanel.getMouseY());
                break;
            }
            case 2: {
                if (this.targetHit != null) {
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2002, null, this.targetHit));
                } else {
                    this.mouseReleased(interactivePanel.getMouseX(), interactivePanel.getMouseY());
                }
            }
            case 6: {
                this.targetHit = null;
                break;
            }
            case 7: {
                if (interactivePanel.getInteractive() != null) {
                    interactivePanel.setMouseCursor(Cursor.getPredefinedCursor(12));
                    break;
                }
                interactivePanel.setMouseCursor(Cursor.getPredefinedCursor(1));
            }
        }
    }

    public void mousePressed(double d, double d2) {
        this.invokeActions(10);
        this.mouseDragged(d, d2);
    }

    public void mouseDragged(double d, double d2) {
        this.posValues[0].value = d;
        this.posValues[1].value = d2;
        this.variablesChanged(this.getPosIndex(), this.posValues);
    }

    public void mouseReleased(double d, double d2) {
        this.invokeActions(0);
    }
}

