/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlTextArea
extends ControlSwingElement {
    static String _RETURN_ = System.getProperty("line.separator");
    protected JTextArea textarea;
    private JScrollPane panel;
    private TitledBorder titledBorder;
    private EtchedBorder etchedBorder;
    private static ArrayList<String> infoList = null;

    public ControlTextArea(Object object) {
        super(object);
    }

    @Override
    protected Component createVisual(Object object) {
        if (object instanceof JTextArea) {
            this.textarea = (JTextArea)object;
        } else {
            this.textarea = new JTextArea(5, 5);
            this.textarea.setEditable(false);
        }
        this.panel = new JScrollPane(this.textarea);
        this.etchedBorder = new EtchedBorder(1);
        this.titledBorder = new TitledBorder(this.etchedBorder, "");
        this.titledBorder.setTitleJustification(2);
        this.panel.setBorder(this.etchedBorder);
        return this.textarea;
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public void reset() {
        this.textarea.setText("");
    }

    @Override
    public ArrayList<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("title");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("title")) {
            return "String TRANSLATABLE";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getString().equals(this.titledBorder.getTitle())) break;
                this.titledBorder.setTitle(value.getString());
                this.panel.setBorder(this.titledBorder);
                this.panel.repaint();
                break;
            }
            default: {
                super.setValue(n - 1, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.panel.setBorder(this.etchedBorder);
                this.panel.repaint();
                break;
            }
            default: {
                super.setDefaultValue(n - 1);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
        }
        return super.getValue(n - 1);
    }

    public void clear() {
        this.textarea.setText("");
        this.textarea.setCaretPosition(this.textarea.getText().length());
    }

    public void println(String string) {
        this.print(String.valueOf(string) + _RETURN_);
    }

    public void print(String string) {
        this.textarea.append(string);
        this.textarea.setCaretPosition(this.textarea.getText().length());
    }
}

