/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.value;

import java.util.StringTokenizer;
import org.opensourcephysics.ejs.control.GroupControl;
import org.opensourcephysics.ejs.control.value.ParserSuryono;
import org.opensourcephysics.ejs.control.value.Value;

public class ExpressionValue
extends Value {
    private String expression;
    private GroupControl group;
    private ParserSuryono parser;
    private String[] vars;
    private boolean isArray;
    private ParserSuryono[] arrayParser;
    private String[][] arrayVars;
    private double[] arrayValues;

    public ExpressionValue(String string, GroupControl groupControl) {
        this.group = groupControl;
        this.expression = new String(string.trim());
        this.processExpression();
    }

    public boolean getBoolean() {
        return this.getDouble() != 0.0;
    }

    public int getInteger() {
        return (int)this.getDouble();
    }

    public double getDouble() {
        int n = 0;
        int n2 = this.vars.length;
        while (n < n2) {
            this.parser.setVariable(n, this.group.getDouble(this.vars[n]));
            ++n;
        }
        return this.parser.evaluate();
    }

    public String getString() {
        return String.valueOf(this.getDouble());
    }

    public Object getObject() {
        if (this.isArray) {
            int n = 0;
            int n2 = this.arrayVars.length;
            while (n < n2) {
                int n3 = 0;
                int n4 = this.arrayVars[n].length;
                while (n3 < n4) {
                    this.arrayParser[n].setVariable(n3, this.group.getDouble(this.arrayVars[n][n3]));
                    ++n3;
                }
                this.arrayValues[n] = this.arrayParser[n].evaluate();
                ++n;
            }
            return this.arrayValues;
        }
        return null;
    }

    public void setExpression(String string) {
        this.expression = new String(string.trim());
        this.processExpression();
    }

    public void copyValue(Value value) {
        this.expression = value instanceof ExpressionValue ? new String(((ExpressionValue)value).expression) : new String(value.getString());
        this.processExpression();
    }

    public Value cloneValue() {
        return new ExpressionValue(this.expression, this.group);
    }

    private void processExpression() {
        if (this.expression.startsWith("{") && this.expression.endsWith("}")) {
            String string = this.expression.substring(1, this.expression.length() - 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = stringTokenizer.countTokens();
            this.arrayParser = new ParserSuryono[n];
            this.arrayVars = new String[n][];
            this.arrayValues = new double[n];
            this.isArray = true;
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.arrayVars[n2] = ParserSuryono.getVariableList(string2);
                this.arrayParser[n2] = new ParserSuryono(this.arrayVars[n2].length);
                int n3 = 0;
                int n4 = this.arrayVars[n2].length;
                while (n3 < n4) {
                    this.arrayParser[n2].defineVariable(n3, this.arrayVars[n2][n3]);
                    ++n3;
                }
                this.arrayParser[n2].define(string2);
                this.arrayParser[n2].parse();
                ++n2;
            }
        } else {
            this.vars = ParserSuryono.getVariableList(this.expression);
            this.parser = new ParserSuryono(this.vars.length);
            int n = 0;
            int n5 = this.vars.length;
            while (n < n5) {
                this.parser.defineVariable(n, this.vars[n]);
                ++n;
            }
            this.parser.define(this.expression);
            this.parser.parse();
            this.isArray = false;
        }
    }
}

