/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.value;

import java.util.StringTokenizer;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.ObjectValue;
import org.opensourcephysics.ejs.control.value.StringValue;

public abstract class Value {
    public abstract boolean getBoolean();

    public abstract int getInteger();

    public abstract double getDouble();

    public abstract String getString();

    public abstract Object getObject();

    public void copyValue(Value value) {
        if (this instanceof DoubleValue) {
            ((DoubleValue)this).value = value.getDouble();
        } else if (this instanceof IntegerValue) {
            ((IntegerValue)this).value = value.getInteger();
        } else if (this instanceof BooleanValue) {
            ((BooleanValue)this).value = value.getBoolean();
        } else if (this instanceof StringValue) {
            ((StringValue)this).value = value.getString();
        } else if (this instanceof ObjectValue) {
            ((ObjectValue)this).value = value.getObject();
        }
    }

    public Value cloneValue() {
        if (this instanceof DoubleValue) {
            return new DoubleValue(this.getDouble());
        }
        if (this instanceof IntegerValue) {
            return new IntegerValue(this.getInteger());
        }
        if (this instanceof BooleanValue) {
            return new BooleanValue(this.getBoolean());
        }
        if (this instanceof StringValue) {
            return new StringValue(this.getString());
        }
        if (this instanceof ObjectValue) {
            return new ObjectValue(this.getObject());
        }
        return null;
    }

    public String toString() {
        return this.getString();
    }

    public static Value parseConstantOrArray(String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        if (n <= 1) {
            return Value.parseConstant(string, bl);
        }
        Value[] valueArray = new Value[n];
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        while (n2 < n) {
            valueArray[n2] = Value.parseConstant(stringTokenizer.nextToken(), bl);
            if (valueArray[n2] == null) {
                return Value.parseConstant(string, bl);
            }
            if (valueArray[n2] instanceof DoubleValue) {
                bl2 = true;
            } else if (valueArray[n2] instanceof IntegerValue) {
                bl3 = true;
            } else if (valueArray[n2] instanceof BooleanValue) {
                bl4 = true;
            }
            ++n2;
        }
        if (bl2) {
            double[] dArray = new double[n];
            int n3 = 0;
            while (n3 < n) {
                dArray[n3] = valueArray[n3].getDouble();
                ++n3;
            }
            return new ObjectValue(dArray);
        }
        if (bl3) {
            int[] nArray = new int[n];
            int n4 = 0;
            while (n4 < n) {
                nArray[n4] = valueArray[n4].getInteger();
                ++n4;
            }
            return new ObjectValue(nArray);
        }
        if (bl4) {
            boolean[] blArray = new boolean[n];
            int n5 = 0;
            while (n5 < n) {
                blArray[n5] = valueArray[n5].getBoolean();
                ++n5;
            }
            return new ObjectValue(blArray);
        }
        return Value.parseConstant(string, bl);
    }

    public static String removeScapes(String string) {
        String string2 = "";
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\\') {
                if (n2 == n - 1) {
                    return String.valueOf(string2) + c;
                }
                c = string.charAt(++n2);
            }
            string2 = String.valueOf(string2) + c;
            ++n2;
        }
        return string2;
    }

    public static Value parseConstant(String string, boolean bl) {
        if ((string = string.trim()).length() <= 0) {
            return null;
        }
        if (string.startsWith("\"")) {
            if (string.length() <= 1) {
                return null;
            }
            if (!string.endsWith("\"")) {
                return null;
            }
            return new StringValue(Value.removeScapes(string.substring(1, string.length() - 1)));
        }
        if (string.startsWith("'")) {
            if (!string.endsWith("'")) {
                return null;
            }
            return new StringValue(Value.removeScapes(string.substring(1, string.length() - 1)));
        }
        if (string.equals("true")) {
            return new BooleanValue(true);
        }
        if (string.equals("false")) {
            return new BooleanValue(false);
        }
        if (string.indexOf(46) >= 0) {
            try {
                double d = Double.parseDouble(string);
                return new DoubleValue(d);
            }
            catch (Exception exception) {
                if (!bl) {
                    System.err.println("Value : Error 2! Incorrect input to parse " + string);
                }
                return null;
            }
        }
        try {
            int n = Integer.parseInt(string);
            return new IntegerValue(n);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

