/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.Histogram;
import org.opensourcephysics.display.HistogramDataset;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.Tool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistogramFrame
extends DrawingFrame {
    protected Histogram histogram = new Histogram();
    protected DataTable dataTable = new DataTable();
    protected DataTableFrame tableFrame;
    DataTool tool;
    HistogramDataset dataset;
    JCheckBoxMenuItem logItem;

    public HistogramFrame(String string, String string2, String string3) {
        super(new PlottingPanel(string, string2, null));
        this.drawingPanel.addDrawable(this.histogram);
        this.setTitle(string3);
        this.dataTable.add(this.histogram);
        this.setAnimated(true);
        this.setAutoclear(true);
        this.addMenuItems();
    }

    public void setXYColumnNames(String string, String string2, String string3) {
        this.histogram.setXYColumnNames(string, string2, string3);
    }

    @Override
    protected void addMenuItems() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        JMenu jMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu jMenu2 = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (jMenu2 == null) {
            jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            jMenuBar.add(jMenu2);
            jMenuBar.validate();
        } else {
            jMenu2.addSeparator();
        }
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, MENU_SHORTCUT_KEY_MASK));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HistogramFrame.this.showDataTable(true);
            }
        };
        jMenuItem.addActionListener(actionListener);
        jMenu2.add(jMenuItem);
        jMenu2.addSeparator();
        this.logItem = new JCheckBoxMenuItem(DisplayRes.getString("HistogramFrame.MenuItem.LogScale"), false);
        this.logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HistogramFrame.this.histogram.logScale = HistogramFrame.this.logItem.isSelected();
                HistogramFrame.this.drawingPanel.repaint();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        jMenuItem2.addActionListener(actionListener);
        if (this.drawingPanel != null && this.drawingPanel.getPopupMenu() != null) {
            this.drawingPanel.getPopupMenu().add(jMenuItem2);
        }
    }

    @Override
    protected JMenu loadToolsMenu() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        JMenu jMenu = new JMenu(DisplayRes.getString("DrawingFrame.Tools_menu_title"));
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DatasetTool_menu_item"));
        jMenu.add(jMenuItem);
        Class<?> clazz = null;
        if (OSPRuntime.loadDataTool) {
            try {
                clazz = Class.forName("org.opensourcephysics.tools.DataTool");
            }
            catch (Exception exception) {
                OSPRuntime.loadDataTool = false;
                jMenuItem.setEnabled(false);
                OSPLog.finest("Cannot instantiate data analysis tool class:\n" + exception.toString());
            }
        }
        final Class<?> clazz2 = clazz;
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Method method = clazz2.getMethod("getTool", null);
                    Tool tool = (Tool)method.invoke(null, null);
                    tool.send(new LocalJob(HistogramFrame.this.drawingPanel), HistogramFrame.this.reply);
                    if (tool instanceof OSPFrame) {
                        ((OSPFrame)((Object)tool)).setKeepHidden(false);
                    }
                    ((JFrame)((Object)tool)).setVisible(true);
                }
                catch (Exception exception) {}
            }
        });
        return jMenu;
    }

    public double[] getXPoints() {
        return this.histogram.getXPoints();
    }

    public double[] getYPoints() {
        return this.histogram.getYPoints();
    }

    public double[][] getLogPoints() {
        return this.histogram.getLogPoints();
    }

    public double[][] getPoints() {
        return this.histogram.getPoints();
    }

    @Override
    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.histogram);
        this.showDataTable(false);
    }

    @Override
    public synchronized ArrayList<Drawable> getDrawables() {
        ArrayList<Drawable> arrayList = super.getDrawables();
        arrayList.remove(this.histogram);
        return arrayList;
    }

    @Override
    public synchronized <T extends Drawable> ArrayList<T> getDrawables(Class<T> clazz) {
        ArrayList<T> arrayList = super.getDrawables(clazz);
        arrayList.remove(this.histogram);
        return arrayList;
    }

    @Override
    public void clearData() {
        this.histogram.clear();
        this.dataTable.refreshTable();
        if (this.drawingPanel != null) {
            this.drawingPanel.invalidateImage();
        }
    }

    public void append(double d) {
        this.histogram.append(d);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(double d, double d2) {
        this.histogram.append(d, d2);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(double[] dArray) {
        this.histogram.append(dArray);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void setDiscrete(boolean bl) {
        this.histogram.setDiscrete(bl);
    }

    public void setLogScale(boolean bl) {
        this.histogram.logScale = bl;
        this.logItem.setSelected(bl);
    }

    public boolean isLogScale() {
        return this.histogram.logScale;
    }

    public void setBinWidth(double d) {
        this.histogram.setBinWidth(d);
    }

    public double getBinWidth() {
        return this.histogram.getBinWidth();
    }

    public void setBinColor(Color color, Color color2) {
        this.histogram.setBinColor(color, color2);
    }

    public void setBinStyle(short s) {
        this.histogram.setBinStyle(s);
    }

    public void setBinOffset(double d) {
        this.histogram.setBinOffset(d);
    }

    public void setNormalizedToOne(boolean bl) {
        this.histogram.setNormalizedToOne(bl);
        this.histogram.adjustForWidth = bl;
    }

    public void positiveX() {
        boolean bl = this.drawingPanel.isAutoscaleX();
        this.drawingPanel.setPreferredMinMaxX(0.0, this.drawingPanel.getPreferredXMax());
        this.drawingPanel.setAutoscaleX(bl);
    }

    public synchronized void showDataTable(boolean bl) {
        if (bl) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                this.tableFrame = new DataTableFrame(String.valueOf(this.getTitle()) + " " + DisplayRes.getString("TableFrame.TitleAddOn.Data"), this.dataTable);
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.dataTable.refreshTable();
            this.dataTable.sort(0);
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new HistogramFrameLoader();
    }

    protected static class HistogramFrameLoader
    extends DrawingFrame.DrawingFrameLoader {
        protected HistogramFrameLoader() {
        }

        public Object createObject(XMLControl xMLControl) {
            HistogramFrame histogramFrame = new HistogramFrame("x", "y", DisplayRes.getString("HistogramFrame.Title"));
            return histogramFrame;
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            super.loadObject(xMLControl, object);
            HistogramFrame histogramFrame = (HistogramFrame)object;
            ArrayList<Histogram> arrayList = histogramFrame.getObjectOfClass(Histogram.class);
            if (arrayList.size() > 0) {
                histogramFrame.histogram = arrayList.get(0);
                histogramFrame.histogram.clear();
                histogramFrame.dataTable.add(histogramFrame.histogram);
            }
            return object;
        }
    }
}

