/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.ByteLattice;
import org.opensourcephysics.display2d.CellLattice;
import org.opensourcephysics.display2d.SiteLattice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatticeFrame
extends DrawingFrame {
    JMenuItem cellItem;
    JMenuItem siteItem;
    protected ByteLattice lattice = new CellLattice(4, 4);
    MouseInputAdapter mouseAdapter;
    int[] editValues = new int[2];
    int dragV;

    public LatticeFrame(String string, String string2, String string3) {
        super(new PlottingPanel(string, string2, null));
        this.setTitle(string3);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorXGrid(false);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorYGrid(false);
        this.addMenuItems();
        this.drawingPanel.addDrawable(this.lattice);
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    public void setShowGridLines(boolean bl) {
        this.lattice.setShowGridLines(bl);
    }

    public LatticeFrame(String string) {
        super(new InteractivePanel());
        this.setTitle(string);
        this.addMenuItems();
        this.drawingPanel.addDrawable(this.lattice);
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    public void showLegend() {
        this.lattice.showLegend();
    }

    @Override
    protected void addMenuItems() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        JMenu jMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu jMenu2 = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (jMenu2 == null) {
            jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            jMenuBar.add(jMenu2);
            jMenuBar.validate();
        } else {
            jMenu2.addSeparator();
        }
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        this.cellItem = new JRadioButtonMenuItem(DisplayRes.getString("LatticeFrame.MenuItem.CellLattice"));
        buttonGroup.add(this.cellItem);
        this.cellItem.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LatticeFrame.this.convertToCellLattice();
            }
        };
        this.cellItem.addActionListener(actionListener);
        jMenu2.add(this.cellItem);
        this.siteItem = new JRadioButtonMenuItem(DisplayRes.getString("LatticeFrame.MenuItem.SiteLattice"));
        buttonGroup.add(this.siteItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LatticeFrame.this.convertToSiteLattice();
            }
        };
        this.siteItem.addActionListener(actionListener);
        jMenu2.add(this.siteItem);
    }

    public void convertToSiteLattice() {
        if (this.lattice instanceof CellLattice) {
            this.drawingPanel.removeDrawable(this.lattice);
            this.lattice = ((CellLattice)this.lattice).createSiteLattice();
            this.drawingPanel.addDrawable(this.lattice);
            this.siteItem.setSelected(true);
            this.drawingPanel.repaint();
        }
    }

    public void convertToCellLattice() {
        if (this.lattice instanceof SiteLattice) {
            this.drawingPanel.removeDrawable(this.lattice);
            this.lattice = ((SiteLattice)this.lattice).createCellLattice();
            this.drawingPanel.addDrawable(this.lattice);
            this.cellItem.setSelected(true);
            this.drawingPanel.repaint();
        }
    }

    @Override
    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.lattice);
    }

    @Override
    public synchronized ArrayList<Drawable> getDrawables() {
        ArrayList<Drawable> arrayList = super.getDrawables();
        arrayList.remove(this.lattice);
        return arrayList;
    }

    @Override
    public synchronized <T extends Drawable> ArrayList<T> getDrawables(Class<T> clazz) {
        ArrayList<T> arrayList = super.getDrawables(clazz);
        arrayList.remove(this.lattice);
        return arrayList;
    }

    @Override
    public void clearData() {
        this.lattice.setBlock(0, 0, new byte[this.lattice.getNx()][this.lattice.getNy()]);
        if (this.drawingPanel != null) {
            this.drawingPanel.invalidateImage();
        }
    }

    public void setAll(byte[][] byArray) {
        if (this.lattice.getNx() != byArray.length || this.lattice.getNy() != byArray[0].length) {
            this.lattice.resizeLattice(byArray.length, byArray[0].length);
        }
        this.lattice.setBlock(0, 0, byArray);
        this.drawingPanel.invalidateImage();
    }

    public void setAll(byte[][] byArray, double d, double d2, double d3, double d4) {
        this.setAll(byArray);
        this.lattice.setMinMax(d, d2, d3, d4);
    }

    public void randomize() {
        this.lattice.randomize();
    }

    public void resizeLattice(int n, int n2) {
        this.lattice.resizeLattice(n, n2);
    }

    public void setIndexedColor(int n, Color color) {
        this.lattice.setIndexedColor(n, color);
    }

    public void setColorPalette(Color[] colorArray) {
        this.lattice.setColorPalette(colorArray);
    }

    public void setAtIndex(int n, int n2) {
        int n3 = this.lattice.getNx();
        this.setValue(n % n3, n / n3, n2);
    }

    public void setValue(int n, int n2, int n3) {
        this.lattice.setValue(n, n2, (byte)n3);
    }

    public void setAll(int[] nArray, int n, double d, double d2, double d3, double d4) {
        if (nArray.length % n != 0) {
            throw new IllegalArgumentException("Number of values in lattice (nx*ny) must match number of values.");
        }
        this.resizeLattice(n, nArray.length / n);
        this.setAll(nArray);
        this.lattice.setMinMax(d, d2, d3, d4);
    }

    public void setAll(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.setAtIndex(n, nArray[n]);
            ++n;
        }
    }

    public int getAtIndex(int n) {
        int n2 = this.lattice.getNx();
        return this.getValue(n % n2, n / n2);
    }

    public int getValue(int n, int n2) {
        return this.lattice.getValue(n, n2);
    }

    public int[] getAll() {
        int n = this.lattice.getNx() * this.lattice.getNy();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.getAtIndex(n2);
            ++n2;
        }
        return nArray;
    }

    public void setToggleOnClick(boolean bl, int n, int n2) {
        this.editValues = new int[]{n, n2};
        if (bl) {
            this.drawingPanel.addMouseListener(this.getMouseAdapter());
            this.drawingPanel.addMouseMotionListener(this.getMouseAdapter());
        } else {
            this.drawingPanel.removeMouseListener(this.getMouseAdapter());
            this.drawingPanel.removeMouseMotionListener(this.getMouseAdapter());
        }
    }

    void mouse(MouseEvent mouseEvent, boolean bl) {
        double d;
        if (mouseEvent.getButton() == 3) {
            return;
        }
        double d2 = this.drawingPanel.pixToX(mouseEvent.getX());
        int n = this.indexFromPoint(d2, d = this.drawingPanel.pixToY(mouseEvent.getY()));
        if (n == -1) {
            return;
        }
        if (bl) {
            this.dragV = this.editValues[0];
            int n2 = this.editValues.length;
            int n3 = 0;
            while (n3 < n2) {
                if (this.getAtIndex(n) == this.editValues[n3]) {
                    this.dragV = this.editValues[(n3 + 1) % n2];
                }
                ++n3;
            }
        }
        if (this.getAtIndex(n) != this.dragV) {
            this.setAtIndex(n, this.dragV);
            this.drawingPanel.render();
        }
    }

    public int indexFromPoint(double d, double d2) {
        return this.lattice.indexFromPoint(d, d2);
    }

    synchronized MouseInputAdapter getMouseAdapter() {
        if (this.mouseAdapter == null) {
            return new MouseInputAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    LatticeFrame.this.mouse(mouseEvent, true);
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    LatticeFrame.this.mouse(mouseEvent, false);
                }
            };
        }
        return this.mouseAdapter;
    }
}

