/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Color;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.dialogs.LogAxesInspector;
import org.opensourcephysics.display.dialogs.ScaleInspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotFrame
extends DrawingFrame {
    protected DatasetManager datasetManager = new DatasetManager();
    protected DataTable dataTable = new DataTable();
    protected DataTableFrame tableFrame;

    public PlotFrame(String string, String string2, String string3) {
        super(new PlottingPanel(string, string2, null));
        this.setTitle(string3);
        this.drawingPanel.addDrawable(this.datasetManager);
        this.datasetManager.setXPointsLinked(true);
        this.dataTable.add(this.datasetManager);
        this.setAnimated(true);
        this.setAutoclear(true);
        this.addMenuItems();
    }

    @Override
    public void setName(String string) {
        string = TeXParser.parseTeX(string);
        super.setName(string);
        this.datasetManager.setName(string);
    }

    @Override
    protected void addMenuItems() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        JMenu jMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu jMenu2 = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (jMenu2 == null) {
            jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            jMenuBar.add(jMenu2);
            jMenuBar.validate();
        } else {
            jMenu2.addSeparator();
        }
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Scale_menu_item"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.scale();
            }
        };
        jMenuItem.addActionListener(actionListener);
        jMenu2.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(DisplayRes.getString("DrawingFrame.LogAxes_menu_item"));
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.logAxes();
            }
        };
        jMenuItem2.addActionListener(actionListener);
        jMenu2.add(jMenuItem2);
        jMenu2.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(84, MENU_SHORTCUT_KEY_MASK));
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.showDataTable(true);
            }
        };
        jMenuItem3.addActionListener(actionListener);
        jMenu2.add(jMenuItem3);
        if (this.drawingPanel != null && this.drawingPanel.getPopupMenu() != null) {
            JMenuItem jMenuItem4 = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
            jMenuItem4.addActionListener(actionListener);
            this.drawingPanel.getPopupMenu().addSeparator();
            this.drawingPanel.getPopupMenu().add(jMenuItem4);
        }
    }

    public void setLogScaleX(boolean bl) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setLogScaleX(bl);
        }
    }

    public void setLogScaleY(boolean bl) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setLogScaleY(bl);
        }
    }

    protected void scale() {
        ScaleInspector scaleInspector = new ScaleInspector(this.drawingPanel);
        scaleInspector.setLocationRelativeTo(this.drawingPanel);
        scaleInspector.updateDisplay();
        scaleInspector.setVisible(true);
    }

    protected void logAxes() {
        if (!(this.drawingPanel instanceof PlottingPanel)) {
            return;
        }
        LogAxesInspector logAxesInspector = new LogAxesInspector((PlottingPanel)this.drawingPanel);
        logAxesInspector.setLocationRelativeTo(this.drawingPanel);
        logAxesInspector.updateDisplay();
        logAxesInspector.setVisible(true);
    }

    public void append(int n, double d, double d2) {
        this.datasetManager.append(n, d, d2);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(int n, double d, double d2, double d3, double d4) {
        this.datasetManager.append(n, d, d2, d3, d4);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(int n, double[] dArray, double[] dArray2) {
        this.datasetManager.append(n, dArray, dArray2);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.datasetManager.append(n, dArray, dArray2, dArray3, dArray4);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void setConnected(boolean bl) {
        this.datasetManager.setConnected(bl);
    }

    public void setMaximumPoints(int n, int n2) {
        this.datasetManager.getDataset(n).setMaximumPoints(n2);
    }

    public void setCustomMarker(int n, Shape shape) {
        this.datasetManager.setCustomMarker(n, shape);
    }

    public void setMarkerShape(int n, int n2) {
        this.datasetManager.setMarkerShape(n, n2);
    }

    public void setMarkerSize(int n, int n2) {
        this.datasetManager.setMarkerSize(n, n2);
    }

    public void setMarkerColor(int n, Color color) {
        this.datasetManager.setMarkerColor(n, color);
    }

    public void setLineColor(int n, Color color) {
        this.datasetManager.setLineColor(n, color);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.drawingPanel != null) {
            this.drawingPanel.setBackground(color);
        }
    }

    public void setMarkerColor(int n, Color color, Color color2) {
        this.datasetManager.setMarkerColor(n, color, color2);
    }

    public void setConnected(int n, boolean bl) {
        this.datasetManager.setConnected(n, bl);
    }

    public void setXPointsLinked(boolean bl) {
        this.datasetManager.setXPointsLinked(bl);
    }

    public void setXYColumnNames(int n, String string, String string2, String string3) {
        this.datasetManager.setXYColumnNames(n, string, string2, string3);
    }

    public void setXYColumnNames(int n, String string, String string2) {
        this.datasetManager.setXYColumnNames(n, string, string2);
    }

    public void setMaximumFractionDigits(int n) {
        this.dataTable.setMaximumFractionDigits(n);
    }

    public void setMaximumFractionDigits(String string, int n) {
        this.dataTable.setMaximumFractionDigits(string, n);
    }

    public void setRowNumberVisible(boolean bl) {
        this.dataTable.setRowNumberVisible(bl);
    }

    @Override
    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.datasetManager);
    }

    public Dataset getDataset(int n) {
        return this.datasetManager.getDataset(n);
    }

    public DatasetManager getDatasetManager() {
        return this.datasetManager;
    }

    @Override
    public synchronized ArrayList<Drawable> getDrawables() {
        ArrayList<Drawable> arrayList = super.getDrawables();
        arrayList.remove(this.datasetManager);
        return arrayList;
    }

    @Override
    public synchronized <T extends Drawable> ArrayList<T> getDrawables(Class<T> clazz) {
        ArrayList<T> arrayList = super.getDrawables(clazz);
        arrayList.remove(this.datasetManager);
        return arrayList;
    }

    @Override
    public void clearData() {
        this.datasetManager.clear();
        this.dataTable.refreshTable();
        if (this.drawingPanel != null) {
            this.drawingPanel.invalidateImage();
        }
    }

    public void removeDatasets() {
        this.datasetManager.removeDatasets();
        this.dataTable.refreshTable();
        if (this.drawingPanel != null) {
            this.drawingPanel.invalidateImage();
        }
    }

    public synchronized void showDataTable(boolean bl) {
        if (bl) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                this.tableFrame = new DataTableFrame(String.valueOf(this.getTitle()) + " " + DisplayRes.getString("TableFrame.TitleAddOn.Data"), this.dataTable);
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.dataTable.refreshTable();
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new PlotFrameLoader();
    }

    protected static class PlotFrameLoader
    extends DrawingFrame.DrawingFrameLoader {
        protected PlotFrameLoader() {
        }

        public Object createObject(XMLControl xMLControl) {
            PlotFrame plotFrame = new PlotFrame("x", "y", DisplayRes.getString("PlotFrame.Title"));
            return plotFrame;
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            super.loadObject(xMLControl, object);
            PlotFrame plotFrame = (PlotFrame)object;
            ArrayList<DatasetManager> arrayList = plotFrame.getObjectOfClass(DatasetManager.class);
            if (arrayList.size() > 0) {
                plotFrame.datasetManager = arrayList.get(0);
                plotFrame.dataTable.clear();
                plotFrame.dataTable.add(plotFrame.datasetManager);
            }
            return object;
        }
    }
}

