/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ContourPlot;
import org.opensourcephysics.display2d.GrayscalePlot;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPlot;
import org.opensourcephysics.display2d.GridTableFrame;
import org.opensourcephysics.display2d.InterpolatedPlot;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.SurfacePlot;
import org.opensourcephysics.display2d.SurfacePlotMouseController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scalar2DFrame
extends DrawingFrame {
    String plotType = "";
    int paletteType = 0;
    boolean expanded = false;
    double expansionFactor = 1.0;
    boolean showGrid = true;
    GridData gridData;
    Plot2D plot = new GridPlot(null);
    SurfacePlotMouseController surfacePlotMC;
    JMenuItem surfaceItem;
    JMenuItem contourItem;
    JMenuItem gridItem;
    JMenuItem interpolatedItem;
    JMenuItem grayscaleItem;
    GridTableFrame tableFrame;

    public Scalar2DFrame(String string, String string2, String string3) {
        super(new PlottingPanel(string, string2, null));
        this.drawingPanel.setPreferredSize(new Dimension(350, 350));
        this.setTitle(string3);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorXGrid(false);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorYGrid(false);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    public Scalar2DFrame(String string) {
        super(new InteractivePanel());
        this.setTitle(string);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    public double indexToX(int n) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.indexToX(n);
    }

    public int xToIndex(double d) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.xToIndex(d);
    }

    public int yToIndex(double d) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.yToIndex(d);
    }

    public double indexToY(int n) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.indexToY(n);
    }

    public int getNx() {
        if (this.gridData == null) {
            return 0;
        }
        return this.gridData.getNx();
    }

    public int getNy() {
        if (this.gridData == null) {
            return 0;
        }
        return this.gridData.getNy();
    }

    public void setZRange(boolean bl, double d, double d2) {
        this.plot.setAutoscaleZ(bl, d, d2);
    }

    public double getCeiling() {
        return this.plot.getCeiling();
    }

    public double getFloor() {
        return this.plot.getFloor();
    }

    public boolean isAutoscaleZ() {
        return this.plot.isAutoscaleZ();
    }

    public void setExpandedZ(boolean bl, double d) {
        this.expansionFactor = d;
        this.expanded = bl;
        this.plot.setExpandedZ(bl, d);
    }

    public void setPaletteType(int n) {
        this.paletteType = n;
        this.plot.setPaletteType(n);
    }

    public void setBuffered(boolean bl) {
        this.drawingPanel.setBuffered(bl);
    }

    public void setShowGrid(boolean bl) {
        this.showGrid = bl;
        this.plot.setShowGridLines(bl);
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    @Override
    protected void addMenuItems() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        JMenu jMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu jMenu2 = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (jMenu2 == null) {
            jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            jMenuBar.add(jMenu2);
            jMenuBar.validate();
        } else {
            jMenu2.addSeparator();
        }
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        this.gridItem = new JRadioButtonMenuItem(DisplayRes.getString("2DFrame.MenuItem.GridPlot"));
        buttonGroup.add(this.gridItem);
        this.gridItem.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Scalar2DFrame.this.convertToGridPlot();
            }
        };
        this.gridItem.addActionListener(actionListener);
        jMenu2.add(this.gridItem);
        this.contourItem = new JRadioButtonMenuItem(DisplayRes.getString("2DFrame.MenuItem.ContourPlot"));
        buttonGroup.add(this.contourItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Scalar2DFrame.this.convertToContourPlot();
            }
        };
        this.contourItem.addActionListener(actionListener);
        jMenu2.add(this.contourItem);
        this.surfaceItem = new JRadioButtonMenuItem(DisplayRes.getString("2DFrame.MenuItem.SurfacePlot"));
        buttonGroup.add(this.surfaceItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Scalar2DFrame.this.convertToSurfacePlot();
            }
        };
        this.surfaceItem.addActionListener(actionListener);
        jMenu2.add(this.surfaceItem);
        this.interpolatedItem = new JRadioButtonMenuItem(DisplayRes.getString("2DFrame.MenuItem.InterpolatedPlot"));
        buttonGroup.add(this.interpolatedItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Scalar2DFrame.this.convertToInterpolatedPlot();
            }
        };
        this.interpolatedItem.addActionListener(actionListener);
        jMenu2.add(this.interpolatedItem);
        this.grayscaleItem = new JRadioButtonMenuItem(DisplayRes.getString("2DFrame.MenuItem.GrayscalePlot"));
        buttonGroup.add(this.grayscaleItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Scalar2DFrame.this.convertToGrayscalePlot();
            }
        };
        this.grayscaleItem.addActionListener(actionListener);
        jMenu2.add(this.grayscaleItem);
        jMenu2.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, MENU_SHORTCUT_KEY_MASK));
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Scalar2DFrame.this.showDataTable(true);
            }
        };
        jMenuItem.addActionListener(actionListener2);
        jMenu2.add(jMenuItem);
        if (this.drawingPanel != null && this.drawingPanel.getPopupMenu() != null) {
            JMenuItem jMenuItem2 = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
            jMenuItem2.addActionListener(actionListener2);
            this.drawingPanel.getPopupMenu().add(jMenuItem2);
        }
    }

    @Override
    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.plot);
    }

    @Override
    public synchronized ArrayList<Drawable> getDrawables() {
        ArrayList<Drawable> arrayList = super.getDrawables();
        arrayList.remove(this.plot);
        return arrayList;
    }

    @Override
    public synchronized <T extends Drawable> ArrayList<T> getDrawables(Class<T> clazz) {
        ArrayList<T> arrayList = super.getDrawables(clazz);
        arrayList.remove(this.plot);
        return arrayList;
    }

    @Override
    public void clearData() {
        if (this.gridData != null) {
            this.setAll(new double[this.gridData.getNx()][this.gridData.getNy()]);
        }
        this.drawingPanel.invalidateImage();
    }

    public void setPlotType(String string) {
        this.plotType = string;
        if (string.toLowerCase().equals("contour")) {
            this.convertToContourPlot();
            this.surfaceItem.setEnabled(false);
            this.contourItem.setEnabled(true);
            this.gridItem.setEnabled(false);
            this.interpolatedItem.setEnabled(false);
            this.grayscaleItem.setEnabled(false);
        } else if (string.toLowerCase().equals("grayscale")) {
            this.convertToGrayscalePlot();
            this.surfaceItem.setEnabled(false);
            this.contourItem.setEnabled(false);
            this.gridItem.setEnabled(false);
            this.interpolatedItem.setEnabled(false);
            this.grayscaleItem.setEnabled(true);
        } else if (string.toLowerCase().equals("grid")) {
            this.convertToGridPlot();
            this.surfaceItem.setEnabled(false);
            this.contourItem.setEnabled(false);
            this.gridItem.setEnabled(true);
            this.interpolatedItem.setEnabled(false);
            this.grayscaleItem.setEnabled(false);
        } else if (string.toLowerCase().equals("interpolated")) {
            this.convertToInterpolatedPlot();
            this.surfaceItem.setEnabled(false);
            this.contourItem.setEnabled(false);
            this.gridItem.setEnabled(false);
            this.interpolatedItem.setEnabled(true);
            this.grayscaleItem.setEnabled(false);
        } else if (string.toLowerCase().equals("surface")) {
            this.convertToSurfacePlot();
            this.surfaceItem.setEnabled(true);
            this.contourItem.setEnabled(false);
            this.gridItem.setEnabled(false);
            this.interpolatedItem.setEnabled(false);
            this.grayscaleItem.setEnabled(false);
        } else {
            this.plotType = "";
            this.surfaceItem.setEnabled(true);
            this.contourItem.setEnabled(true);
            this.gridItem.setEnabled(true);
            this.interpolatedItem.setEnabled(true);
            this.grayscaleItem.setEnabled(true);
        }
    }

    public void convertToContourPlot() {
        if (!(this.plot instanceof ContourPlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
                this.drawingPanel.resetGutters();
                this.drawingPanel.setClipAtGutter(true);
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).getAxes().setVisible(true);
                }
                this.drawingPanel.setShowCoordinates(true);
            }
            boolean bl = this.plot.isAutoscaleZ();
            double d = this.plot.getFloor();
            double d2 = this.plot.getCeiling();
            Plot2D plot2D = this.plot;
            this.plot = new ContourPlot(this.gridData);
            this.plot.setPaletteType(this.paletteType);
            if (this.expanded) {
                this.plot.setExpandedZ(this.expanded, this.expansionFactor);
            }
            this.plot.setAutoscaleZ(bl, d, d2);
            this.drawingPanel.replaceDrawable(plot2D, this.plot);
            this.plot.update();
            if (this.tableFrame != null && this.tableFrame.isShowing()) {
                this.tableFrame.refreshTable();
            }
            this.drawingPanel.repaint();
            this.contourItem.setSelected(true);
        }
    }

    public void convertToInterpolatedPlot() {
        if (!(this.plot instanceof InterpolatedPlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
                this.drawingPanel.resetGutters();
                this.drawingPanel.setClipAtGutter(true);
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).getAxes().setVisible(true);
                }
                this.drawingPanel.setShowCoordinates(true);
            }
            boolean bl = this.plot.isAutoscaleZ();
            double d = this.plot.getFloor();
            double d2 = this.plot.getCeiling();
            Plot2D plot2D = this.plot;
            this.plot = new InterpolatedPlot(this.gridData);
            this.plot.setPaletteType(this.paletteType);
            if (this.expanded) {
                this.plot.setExpandedZ(this.expanded, this.expansionFactor);
            }
            this.plot.setAutoscaleZ(bl, d, d2);
            this.drawingPanel.replaceDrawable(plot2D, this.plot);
            this.plot.update();
            if (this.tableFrame != null && this.tableFrame.isShowing()) {
                this.tableFrame.refreshTable();
            }
            this.drawingPanel.repaint();
            this.interpolatedItem.setSelected(true);
        }
    }

    public void convertToGridPlot() {
        if (!(this.plot instanceof GridPlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
                this.drawingPanel.resetGutters();
                this.drawingPanel.setClipAtGutter(true);
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).getAxes().setVisible(true);
                }
                this.drawingPanel.setShowCoordinates(true);
            }
            boolean bl = this.plot.isAutoscaleZ();
            double d = this.plot.getFloor();
            double d2 = this.plot.getCeiling();
            Plot2D plot2D = this.plot;
            this.plot = new GridPlot(this.gridData);
            if (this.expanded) {
                this.plot.setExpandedZ(this.expanded, this.expansionFactor);
            }
            this.plot.setShowGridLines(this.showGrid);
            this.plot.setPaletteType(this.paletteType);
            this.plot.setAutoscaleZ(bl, d, d2);
            this.drawingPanel.replaceDrawable(plot2D, this.plot);
            this.plot.update();
            if (this.tableFrame != null && this.tableFrame.isShowing()) {
                this.tableFrame.refreshTable();
            }
            this.drawingPanel.repaint();
            this.gridItem.setSelected(true);
        }
    }

    public void convertToGrayscalePlot() {
        if (!(this.plot instanceof GrayscalePlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
                this.drawingPanel.resetGutters();
                this.drawingPanel.setClipAtGutter(true);
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).getAxes().setVisible(true);
                }
                this.drawingPanel.setShowCoordinates(true);
            }
            boolean bl = this.plot.isAutoscaleZ();
            double d = this.plot.getFloor();
            double d2 = this.plot.getCeiling();
            Plot2D plot2D = this.plot;
            this.plot = new GrayscalePlot(this.gridData);
            if (this.expanded) {
                this.plot.setExpandedZ(this.expanded, this.expansionFactor);
            }
            this.plot.setPaletteType(this.paletteType);
            this.plot.setAutoscaleZ(bl, d, d2);
            this.drawingPanel.replaceDrawable(plot2D, this.plot);
            this.plot.update();
            if (this.tableFrame != null && this.tableFrame.isShowing()) {
                this.tableFrame.refreshTable();
            }
            this.drawingPanel.repaint();
            this.grayscaleItem.setSelected(true);
        }
    }

    public void convertToSurfacePlot() {
        if (!(this.plot instanceof SurfacePlot)) {
            Plot2D plot2D = this.plot;
            try {
                SurfacePlot surfacePlot = new SurfacePlot(this.gridData);
                if (this.drawingPanel instanceof PlottingPanel) {
                    String string = ((PlottingPanel)this.drawingPanel).getAxes().getXLabel();
                    String string2 = ((PlottingPanel)this.drawingPanel).getAxes().getYLabel();
                    surfacePlot.setAxisLabels(string, string2, null);
                }
                this.plot = surfacePlot;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.surfaceItem.setEnabled(false);
                this.gridItem.setSelected(true);
                this.convertToGridPlot();
                return;
            }
            if (this.drawingPanel instanceof PlottingPanel) {
                ((PlottingPanel)this.drawingPanel).getAxes().setVisible(false);
            }
            this.drawingPanel.setShowCoordinates(false);
            this.drawingPanel.setGutters(0, 0, 0, 0);
            this.drawingPanel.setClipAtGutter(false);
            boolean bl = plot2D.isAutoscaleZ();
            double d = plot2D.getFloor();
            double d2 = plot2D.getCeiling();
            this.plot.setPaletteType(this.paletteType);
            if (this.expanded) {
                this.plot.setExpandedZ(this.expanded, this.expansionFactor);
            }
            this.plot.setAutoscaleZ(bl, d, d2);
            this.drawingPanel.replaceDrawable(plot2D, this.plot);
            this.plot.update();
            if (this.tableFrame != null && this.tableFrame.isShowing()) {
                this.tableFrame.refreshTable();
            }
            this.drawingPanel.repaint();
            if (this.surfacePlotMC == null) {
                this.surfacePlotMC = new SurfacePlotMouseController(this.drawingPanel, this.plot);
            }
            this.drawingPanel.addMouseListener(this.surfacePlotMC);
            this.drawingPanel.addMouseMotionListener(this.surfacePlotMC);
            this.surfaceItem.setSelected(true);
        }
    }

    public void resizeGrid(int n, int n2) {
        double d;
        double d2;
        double d3;
        double d4;
        boolean bl = false;
        if (this.gridData == null) {
            d4 = this.drawingPanel.getPreferredXMin();
            d3 = this.drawingPanel.getPreferredXMax();
            d2 = this.drawingPanel.getPreferredYMin();
            d = this.drawingPanel.getPreferredYMax();
        } else {
            d4 = this.gridData.getLeft();
            d3 = this.gridData.getRight();
            d2 = this.gridData.getBottom();
            d = this.gridData.getTop();
            bl = this.gridData.isCellData();
        }
        this.gridData = new ArrayData(n, n2, 1);
        this.gridData.setComponentName(0, "Amp");
        if (n != n2) {
            this.surfaceItem.setEnabled(false);
            if (this.plot instanceof SurfacePlot) {
                this.convertToGridPlot();
            }
        } else if (this.plotType.equals("")) {
            this.surfaceItem.setEnabled(true);
        }
        if (bl) {
            this.gridData.setCellScale(d4, d3, d2, d);
        } else {
            this.gridData.setScale(d4, d3, d2, d);
        }
        this.plot.setGridData(this.gridData);
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void setRow(int n, double[] dArray) throws IllegalArgumentException {
        if (this.gridData.getNx() != dArray.length) {
            throw new IllegalArgumentException("Row data length does not match grid size.");
        }
        double[] dArray2 = this.gridData.getData()[0][n];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
    }

    public void setAll(double[][] dArray, double d, double d2, double d3, double d4) {
        this.setAll(dArray);
        if (this.gridData.isCellData()) {
            this.gridData.setCellScale(d, d2, d3, d4);
        } else {
            this.gridData.setScale(d, d2, d3, d4);
        }
    }

    public void setAll(double[][] dArray) {
        if (this.gridData == null || this.gridData.getNx() != dArray.length || this.gridData.getNy() != dArray[0].length) {
            this.resizeGrid(dArray.length, dArray[0].length);
        }
        double[][] dArray2 = this.gridData.getData()[0];
        int n = dArray[0].length;
        int n2 = 0;
        int n3 = dArray2.length;
        while (n2 < n3) {
            System.arraycopy(dArray[n2], 0, dArray2[n2], 0, n);
            ++n2;
        }
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
    }

    public void setAll(double[] dArray) {
        int n;
        if (this.gridData == null) {
            throw new IllegalArgumentException("Grid size must be set before using row-major format.");
        }
        int n2 = this.gridData.getNx();
        if (dArray.length != n2 * (n = this.gridData.getNy())) {
            throw new IllegalArgumentException("Grid does not have the correct size.");
        }
        double[][] dArray2 = this.gridData.getData()[0];
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3 * n2;
            int n5 = 0;
            while (n5 < n2) {
                dArray2[n5][n3] = dArray[n4 + n5];
                ++n5;
            }
            ++n3;
        }
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
    }

    public synchronized void showDataTable(boolean bl) {
        if (bl) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                if (this.gridData == null) {
                    return;
                }
                this.tableFrame = new GridTableFrame(this.gridData);
                this.tableFrame.setTitle(DisplayRes.getString("Scalar2DFrame.Table.Title"));
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.tableFrame.refreshTable();
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }
}

