/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.NumberField;

public class GhostFilter
extends Filter {
    protected int[] pixels;
    protected int[] values;
    private double fade;
    private double defaultFade = 0.05;
    private int w;
    private int h;
    private BufferedImage input;
    private BufferedImage output;
    private BufferedImage source;
    private Graphics2D gIn;
    private Inspector inspector;
    private JLabel fadeLabel;
    private NumberField fadeField;
    private JSlider fadeSlider;

    public GhostFilter() {
        this.setFade(this.defaultFade);
        this.hasInspector = true;
    }

    public void setFade(double d) {
        Double d2 = new Double(this.fade);
        this.fade = Math.min(Math.abs(d), 1.0);
        this.support.firePropertyChange("fade", d2, new Double(d));
    }

    public double getFade() {
        return this.fade;
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        this.source = null;
        super.setEnabled(bl);
    }

    public BufferedImage getFilteredImage(BufferedImage bufferedImage) {
        if (!this.isEnabled()) {
            return bufferedImage;
        }
        if (bufferedImage != this.source) {
            this.initialize(bufferedImage);
        }
        if (bufferedImage != this.input) {
            this.gIn.drawImage((Image)this.source, 0, 0, null);
        }
        this.setOutputToGhost();
        return this.output;
    }

    public JDialog getInspector() {
        Frame frame;
        if (this.inspector == null) {
            this.inspector = new Inspector();
        }
        if (this.inspector.isModal() && this.vidPanel != null && this.frame != (frame = JOptionPane.getFrameForComponent(this.vidPanel))) {
            this.frame = frame;
            if (this.inspector != null) {
                this.inspector.setVisible(false);
            }
            this.inspector = new Inspector();
        }
        this.inspector.initialize();
        return this.inspector;
    }

    public void clear() {
        this.source = null;
        this.support.firePropertyChange("image", null, null);
    }

    public void refresh() {
        super.refresh();
        if (this.inspector != null) {
            this.inspector.setTitle(MediaRes.getString("Filter.Ghost.Title"));
            this.fadeLabel.setText(MediaRes.getString("Filter.Ghost.Label.Fade"));
            this.fadeSlider.setToolTipText(MediaRes.getString("Filter.Ghost.ToolTip.Fade"));
            this.inspector.pack();
            boolean bl = this.isEnabled();
            this.fadeLabel.setEnabled(bl);
            this.fadeSlider.setEnabled(bl);
            this.fadeField.setEnabled(bl);
        }
    }

    private void initialize(BufferedImage bufferedImage) {
        this.source = bufferedImage;
        this.w = this.source.getWidth();
        this.h = this.source.getHeight();
        this.pixels = new int[this.w * this.h];
        this.values = new int[this.w * this.h];
        if (this.source.getType() == 1) {
            this.input = this.source;
        } else {
            this.input = new BufferedImage(this.w, this.h, 1);
            this.gIn = this.input.createGraphics();
        }
        this.output = new BufferedImage(this.w, this.h, 1);
        this.output.createGraphics().drawImage((Image)this.source, 0, 0, null);
        this.output.getRaster().getDataElements(0, 0, this.w, this.h, this.pixels);
        int n = 0;
        while (n < this.values.length) {
            int n2 = this.pixels[n];
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            this.values[n] = (n3 + n4 + n5) / 3;
            ++n;
        }
    }

    private void setOutputToGhost() {
        this.input.getRaster().getDataElements(0, 0, this.w, this.h, this.pixels);
        int n = 0;
        while (n < this.pixels.length) {
            int n2 = (int)((1.0 - this.fade) * (double)this.values[n]);
            int n3 = this.pixels[n];
            int n4 = n3 >> 16 & 0xFF;
            int n5 = n3 >> 8 & 0xFF;
            int n6 = n3 & 0xFF;
            int n7 = (n4 + n5 + n6) / 3;
            if (n2 > n7) {
                this.pixels[n] = n2 << 16 | n2 << 8 | n2;
                this.values[n] = n2;
            } else {
                this.values[n] = n7;
            }
            ++n;
        }
        this.output.getRaster().setDataElements(0, 0, this.w, this.h, this.pixels);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Inspector
    extends JDialog {
        public Inspector() {
            super(GhostFilter.this.frame, !(GhostFilter.this.frame instanceof OSPFrame));
            this.setTitle(MediaRes.getString("Filter.Ghost.Title"));
            this.setResizable(false);
            this.createGUI();
            GhostFilter.this.refresh();
            this.pack();
            Rectangle rectangle = this.getBounds();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - rectangle.width) / 2;
            int n2 = (dimension.height - rectangle.height) / 2;
            this.setLocation(n, n2);
        }

        void createGUI() {
            GhostFilter.this.fadeLabel = new JLabel();
            GhostFilter.this.fadeField = new DecimalField(4, 2);
            GhostFilter.this.fadeField.setMaxValue(0.5);
            GhostFilter.this.fadeField.setMinValue(0.0);
            GhostFilter.this.fadeField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GhostFilter.this.setFade(GhostFilter.this.fadeField.getValue());
                    Inspector.this.updateDisplay();
                    GhostFilter.this.fadeField.selectAll();
                }
            });
            GhostFilter.this.fadeField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    GhostFilter.this.fadeField.selectAll();
                }

                public void focusLost(FocusEvent focusEvent) {
                    GhostFilter.this.setFade(GhostFilter.this.fadeField.getValue());
                    Inspector.this.updateDisplay();
                }
            });
            GhostFilter.this.fadeSlider = new JSlider(0, 0, 0);
            GhostFilter.this.fadeSlider.setMaximum(50);
            GhostFilter.this.fadeSlider.setMinimum(0);
            GhostFilter.this.fadeSlider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            GhostFilter.this.fadeSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = GhostFilter.this.fadeSlider.getValue();
                    if (n != (int)(GhostFilter.this.getFade() * 100.0)) {
                        GhostFilter.this.setFade((double)n / 100.0);
                        Inspector.this.updateDisplay();
                    }
                }
            });
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel jPanel = new JPanel(gridBagLayout);
            this.setContentPane(jPanel);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagLayout.setConstraints(GhostFilter.this.fadeLabel, gridBagConstraints);
            jPanel.add(GhostFilter.this.fadeLabel);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagLayout.setConstraints(GhostFilter.this.fadeField, gridBagConstraints);
            jPanel.add(GhostFilter.this.fadeField);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(GhostFilter.this.fadeSlider, gridBagConstraints);
            jPanel.add(GhostFilter.this.fadeSlider);
            JPanel jPanel2 = new JPanel(new FlowLayout());
            jPanel2.add(GhostFilter.this.ableButton);
            jPanel2.add(GhostFilter.this.clearButton);
            jPanel2.add(GhostFilter.this.closeButton);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
        }

        void initialize() {
            this.updateDisplay();
        }

        void updateDisplay() {
            GhostFilter.this.fadeField.setValue(GhostFilter.this.getFade());
            GhostFilter.this.fadeSlider.setValue((int)(100.0 * GhostFilter.this.getFade()));
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            GhostFilter ghostFilter = (GhostFilter)object;
            xMLControl.setValue("fade", ghostFilter.getFade());
            if (ghostFilter.frame != null && ghostFilter.inspector != null && ghostFilter.inspector.isVisible()) {
                int n = ((GhostFilter)ghostFilter).inspector.getLocation().x - ghostFilter.frame.getLocation().x;
                int n2 = ((GhostFilter)ghostFilter).inspector.getLocation().y - ghostFilter.frame.getLocation().y;
                xMLControl.setValue("inspector_x", n);
                xMLControl.setValue("inspector_y", n2);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return new GhostFilter();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            GhostFilter ghostFilter = (GhostFilter)object;
            if (xMLControl.getPropertyNames().contains("fade")) {
                ghostFilter.setFade(xMLControl.getDouble("fade"));
            }
            ghostFilter.inspectorX = xMLControl.getInt("inspector_x");
            ghostFilter.inspectorY = xMLControl.getInt("inspector_y");
            return object;
        }
    }
}

