/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.NumberField;

public class GrayScaleFilter
extends Filter {
    private static final double WT_R_VID = 0.3;
    private static final double WT_G_VID = 0.59;
    private static final double WT_B_VID = 0.11;
    private static final double WT_FLAT = 0.3333333333333333;
    private BufferedImage source;
    private BufferedImage input;
    private BufferedImage output;
    private int[] pixels;
    private int w;
    private int h;
    private Graphics2D gIn;
    private double redWt;
    private double greenWt;
    private double blueWt;
    private Inspector inspector;
    private JRadioButton vidButton;
    private JRadioButton flatButton;
    private JRadioButton customButton;
    private ButtonGroup buttons;
    private JLabel[] colorLabels = new JLabel[3];
    private NumberField[] colorFields = new NumberField[3];
    private JComponent typePanel;
    private JComponent rgbPanel;

    public GrayScaleFilter() {
        this.setWeights(0.3, 0.59, 0.11);
        this.hasInspector = true;
    }

    public BufferedImage getFilteredImage(BufferedImage bufferedImage) {
        if (!this.isEnabled()) {
            return bufferedImage;
        }
        if (bufferedImage != this.source) {
            this.initialize(bufferedImage);
        }
        if (bufferedImage != this.input) {
            this.gIn.drawImage((Image)this.source, 0, 0, null);
        }
        this.setOutputToGray();
        return this.output;
    }

    public JDialog getInspector() {
        Frame frame;
        if (this.inspector == null) {
            this.inspector = new Inspector();
        }
        if (this.inspector.isModal() && this.vidPanel != null && this.frame != (frame = JOptionPane.getFrameForComponent(this.vidPanel))) {
            this.frame = frame;
            if (this.inspector != null) {
                this.inspector.setVisible(false);
            }
            this.inspector = new Inspector();
        }
        this.inspector.initialize();
        return this.inspector;
    }

    public void setWeights(double d, double d2, double d3) {
        this.redWt = d;
        this.greenWt = d2;
        this.blueWt = d3;
    }

    public void refresh() {
        super.refresh();
        if (this.inspector != null) {
            this.inspector.setTitle(MediaRes.getString("Filter.GrayScale.Title"));
        }
        this.typePanel.setBorder(BorderFactory.createTitledBorder(MediaRes.getString("Filter.GrayScale.Label.Type")));
        this.rgbPanel.setBorder(BorderFactory.createTitledBorder(MediaRes.getString("Filter.GrayScale.Label.Weight")));
        this.vidButton.setText(MediaRes.getString("Filter.GrayScale.Button.Video"));
        this.flatButton.setText(MediaRes.getString("Filter.GrayScale.Button.Flat"));
        this.customButton.setText(MediaRes.getString("Filter.GrayScale.Button.Custom"));
        this.colorLabels[0].setText(MediaRes.getString("Filter.GrayScale.Label.Red"));
        this.colorLabels[1].setText(MediaRes.getString("Filter.GrayScale.Label.Green"));
        this.colorLabels[2].setText(MediaRes.getString("Filter.GrayScale.Label.Blue"));
        this.vidButton.setEnabled(this.isEnabled());
        this.flatButton.setEnabled(this.isEnabled());
        this.customButton.setEnabled(this.isEnabled());
        int n = 0;
        while (n < 3) {
            this.colorFields[n].setEditable(this.buttons.isSelected(this.customButton.getModel()));
            this.colorFields[n].setEnabled(this.isEnabled());
            this.colorLabels[n].setEnabled(this.isEnabled());
            ++n;
        }
    }

    private void initialize(BufferedImage bufferedImage) {
        this.source = bufferedImage;
        this.w = this.source.getWidth();
        this.h = this.source.getHeight();
        this.pixels = new int[this.w * this.h];
        this.output = new BufferedImage(this.w, this.h, 1);
        if (this.source.getType() == 1) {
            this.input = this.source;
        } else {
            this.input = new BufferedImage(this.w, this.h, 1);
            this.gIn = this.input.createGraphics();
        }
    }

    private void setOutputToGray() {
        this.input.getRaster().getDataElements(0, 0, this.w, this.h, this.pixels);
        int n = 0;
        while (n < this.pixels.length) {
            int n2 = this.pixels[n];
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            int n6 = this.getGray(n3, n4, n5);
            this.pixels[n] = n6 << 16 | n6 << 8 | n6;
            ++n;
        }
        this.output.getRaster().setDataElements(0, 0, this.w, this.h, this.pixels);
    }

    private int getGray(int n, int n2, int n3) {
        double d = (this.redWt * (double)n + this.greenWt * (double)n2 + this.blueWt * (double)n3) / (this.redWt + this.greenWt + this.blueWt);
        return (int)d;
    }

    private void setWeights(double[] dArray) {
        this.redWt = dArray[0];
        this.greenWt = dArray[1];
        this.blueWt = dArray[2];
    }

    private double[] getWeights() {
        return new double[]{this.redWt, this.greenWt, this.blueWt};
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Inspector
    extends JDialog {
        public Inspector() {
            super(GrayScaleFilter.this.frame, !(GrayScaleFilter.this.frame instanceof OSPFrame));
            this.setResizable(false);
            this.createGUI();
            this.setTitle(MediaRes.getString("Filter.GrayScale.Title"));
            GrayScaleFilter.this.refresh();
            this.pack();
            Rectangle rectangle = this.getBounds();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - rectangle.width) / 2;
            int n2 = (dimension.height - rectangle.height) / 2;
            this.setLocation(n, n2);
        }

        void createGUI() {
            int n = 0;
            while (n < 3) {
                ((GrayScaleFilter)GrayScaleFilter.this).colorLabels[n] = new JLabel();
                ((GrayScaleFilter)GrayScaleFilter.this).colorFields[n] = new DecimalField(3, 2);
                GrayScaleFilter.this.colorFields[n].setMaxValue(1.0);
                GrayScaleFilter.this.colorFields[n].setMinValue(0.0);
                GrayScaleFilter.this.colorFields[n].addActionListener(new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Inspector.this.readFields((NumberField)actionEvent.getSource());
                    }
                });
                GrayScaleFilter.this.colorFields[n].addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent focusEvent) {
                        ((NumberField)focusEvent.getSource()).selectAll();
                    }

                    public void focusLost(FocusEvent focusEvent) {
                        Inspector.this.readFields((NumberField)focusEvent.getSource());
                    }
                });
                ++n;
            }
            GridBagLayout gridBagLayout = new GridBagLayout();
            GrayScaleFilter.this.rgbPanel = new JPanel(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            int n2 = 0;
            while (n2 < 3) {
                gridBagConstraints.gridy = n2;
                gridBagConstraints.fill = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.insets = new Insets(3, 20, 0, 3);
                gridBagLayout.setConstraints(GrayScaleFilter.this.colorLabels[n2], gridBagConstraints);
                GrayScaleFilter.this.rgbPanel.add(GrayScaleFilter.this.colorLabels[n2]);
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.insets = new Insets(3, 0, 0, 5);
                gridBagLayout.setConstraints(GrayScaleFilter.this.colorFields[n2], gridBagConstraints);
                GrayScaleFilter.this.rgbPanel.add(GrayScaleFilter.this.colorFields[n2]);
                ++n2;
            }
            GrayScaleFilter.this.vidButton = new JRadioButton();
            GrayScaleFilter.this.flatButton = new JRadioButton();
            GrayScaleFilter.this.customButton = new JRadioButton();
            GrayScaleFilter.this.buttons = new ButtonGroup();
            GrayScaleFilter.this.buttons.add(GrayScaleFilter.this.vidButton);
            GrayScaleFilter.this.buttons.add(GrayScaleFilter.this.flatButton);
            GrayScaleFilter.this.buttons.add(GrayScaleFilter.this.customButton);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (GrayScaleFilter.this.buttons.isSelected(GrayScaleFilter.this.vidButton.getModel())) {
                        GrayScaleFilter.this.setWeights(0.3, 0.59, 0.11);
                    } else if (GrayScaleFilter.this.buttons.isSelected(GrayScaleFilter.this.flatButton.getModel())) {
                        GrayScaleFilter.this.setWeights(0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
                    }
                    GrayScaleFilter.this.refresh();
                    Inspector.this.updateDisplay();
                    ((Inspector)Inspector.this).GrayScaleFilter.this.support.firePropertyChange("weight", null, null);
                }
            };
            GrayScaleFilter.this.vidButton.addActionListener(actionListener);
            GrayScaleFilter.this.flatButton.addActionListener(actionListener);
            GrayScaleFilter.this.customButton.addActionListener(actionListener);
            GrayScaleFilter.this.typePanel = Box.createVerticalBox();
            GrayScaleFilter.this.typePanel.add(GrayScaleFilter.this.vidButton);
            GrayScaleFilter.this.typePanel.add(GrayScaleFilter.this.flatButton);
            GrayScaleFilter.this.typePanel.add(GrayScaleFilter.this.customButton);
            JPanel jPanel = new JPanel(new BorderLayout());
            this.setContentPane(jPanel);
            jPanel.add((Component)GrayScaleFilter.this.typePanel, "West");
            jPanel.add((Component)GrayScaleFilter.this.rgbPanel, "East");
            JPanel jPanel2 = new JPanel(new FlowLayout());
            jPanel2.add(GrayScaleFilter.this.ableButton);
            jPanel2.add(GrayScaleFilter.this.closeButton);
            jPanel.add((Component)jPanel2, "South");
        }

        void readFields(NumberField numberField) {
            double[] dArray = new double[3];
            int n = 0;
            while (n < 3) {
                dArray[n] = GrayScaleFilter.this.colorFields[n].getValue();
                ++n;
            }
            GrayScaleFilter.this.setWeights(dArray);
            this.updateDisplay();
            GrayScaleFilter.this.support.firePropertyChange("weight", null, null);
            numberField.selectAll();
        }

        void initialize() {
            if (GrayScaleFilter.this.redWt == 0.3 && GrayScaleFilter.this.greenWt == 0.59 && GrayScaleFilter.this.blueWt == 0.11) {
                GrayScaleFilter.this.vidButton.setSelected(true);
            } else if (GrayScaleFilter.this.redWt == 0.3333333333333333 && GrayScaleFilter.this.greenWt == 0.3333333333333333 && GrayScaleFilter.this.blueWt == 0.3333333333333333) {
                GrayScaleFilter.this.flatButton.setSelected(true);
            } else {
                GrayScaleFilter.this.customButton.setSelected(true);
            }
            GrayScaleFilter.this.refresh();
            this.updateDisplay();
        }

        void updateDisplay() {
            GrayScaleFilter.this.colorFields[0].setValue(GrayScaleFilter.this.redWt);
            GrayScaleFilter.this.colorFields[1].setValue(GrayScaleFilter.this.greenWt);
            GrayScaleFilter.this.colorFields[2].setValue(GrayScaleFilter.this.blueWt);
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            GrayScaleFilter grayScaleFilter = (GrayScaleFilter)object;
            xMLControl.setValue("weights", grayScaleFilter.getWeights());
            if (grayScaleFilter.frame != null && grayScaleFilter.inspector != null && grayScaleFilter.inspector.isVisible()) {
                int n = ((GrayScaleFilter)grayScaleFilter).inspector.getLocation().x - grayScaleFilter.frame.getLocation().x;
                int n2 = ((GrayScaleFilter)grayScaleFilter).inspector.getLocation().y - grayScaleFilter.frame.getLocation().y;
                xMLControl.setValue("inspector_x", n);
                xMLControl.setValue("inspector_y", n2);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return new GrayScaleFilter();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            GrayScaleFilter grayScaleFilter = (GrayScaleFilter)object;
            if (xMLControl.getPropertyNames().contains("weights")) {
                grayScaleFilter.setWeights((double[])xMLControl.getObject("weights"));
            }
            grayScaleFilter.inspectorX = xMLControl.getInt("inspector_x");
            grayScaleFilter.inspectorY = xMLControl.getInt("inspector_y");
            return object;
        }
    }
}

