/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.FilterStack;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoAdapter
implements Video {
    protected Image rawImage;
    protected Dimension size;
    protected BufferedImage bufferedImage;
    protected BufferedImage filteredImage;
    protected int frameCount;
    protected int frameNumber;
    protected int startFrameNumber;
    protected int endFrameNumber;
    protected double rate = 1.0;
    protected boolean playing = false;
    protected boolean looping = false;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    protected boolean mouseEnabled = false;
    protected boolean visible = true;
    protected boolean isMeasured = false;
    protected boolean isValidMeasure = false;
    protected boolean widthDominates = true;
    protected boolean isValidImage = false;
    protected boolean isValidFilteredImage = false;
    protected ImageCoordSystem coords;
    protected DoubleArray aspects;
    protected PropertyChangeSupport support;
    protected HashMap<String, Object> properties = new HashMap();
    protected FilterStack filterStack = new FilterStack();
    protected Raster clearRaster;

    protected VideoAdapter() {
        this.initialize();
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (drawingPanel instanceof VideoPanel && ((VideoPanel)drawingPanel).isDrawingInImageSpace() || this.isMeasured) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.transform(drawingPanel.getPixelTransform());
            if (drawingPanel instanceof VideoPanel) {
                VideoPanel videoPanel = (VideoPanel)drawingPanel;
                if (!videoPanel.isDrawingInImageSpace()) {
                    ImageCoordSystem imageCoordSystem = videoPanel.getCoords();
                    graphics2D.transform(imageCoordSystem.getToWorldTransform(this.frameNumber));
                }
            } else {
                graphics2D.transform(this.coords.getToWorldTransform(this.frameNumber));
            }
            if (this.filterStack.isEmpty() || !this.filterStack.isEnabled()) {
                graphics2D.drawImage(this.rawImage, 0, 0, drawingPanel);
            } else {
                graphics2D.drawImage((Image)this.getImage(), 0, 0, drawingPanel);
            }
            graphics2D.setTransform(affineTransform);
        } else {
            double d = (drawingPanel.getXMax() + drawingPanel.getXMin()) / 2.0;
            double d2 = (drawingPanel.getYMax() + drawingPanel.getYMin()) / 2.0;
            int n = drawingPanel.xToPix(d) - this.size.width / 2;
            int n2 = drawingPanel.yToPix(d2) - this.size.height / 2;
            if (this.filterStack.isEmpty() || !this.filterStack.isEnabled()) {
                graphics2D.drawImage(this.rawImage, n, n2, drawingPanel);
            } else {
                graphics2D.drawImage((Image)this.getImage(), n, n2, drawingPanel);
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
        this.firePropertyChange("videoVisible", null, new Boolean(bl));
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public double getXMin() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.minX;
    }

    @Override
    public double getXMax() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.maxX;
    }

    @Override
    public double getYMin() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.minY;
    }

    @Override
    public double getYMax() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.maxY;
    }

    @Override
    public boolean isMeasured() {
        return this.isMeasured;
    }

    @Override
    public BufferedImage getImage() {
        if (!this.isValidImage) {
            this.isValidImage = true;
            Graphics2D graphics2D = this.bufferedImage.createGraphics();
            this.bufferedImage.setData(this.clearRaster);
            graphics2D.drawImage(this.rawImage, 0, 0, null);
        }
        if (this.filterStack.isEmpty() || !this.filterStack.isEnabled()) {
            return this.bufferedImage;
        }
        if (!this.isValidFilteredImage) {
            this.isValidFilteredImage = true;
            this.filteredImage = this.filterStack.getFilteredImage(this.bufferedImage);
        }
        return this.filteredImage;
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.mouseEnabled) {
            return null;
        }
        return this;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.mouseEnabled = bl;
    }

    @Override
    public boolean isEnabled() {
        return this.mouseEnabled;
    }

    @Override
    public void setFrameX(int n, double d) {
        this.setFrameXY(n, d, this.coords.imageToWorldY(n, 0.0, 0.0));
    }

    @Override
    public void setX(double d) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameX(n, d);
            ++n;
        }
    }

    @Override
    public void setFrameY(int n, double d) {
        this.setFrameXY(n, this.coords.imageToWorldX(n, 0.0, 0.0), d);
    }

    @Override
    public void setY(double d) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameY(n, d);
            ++n;
        }
    }

    @Override
    public double getX() {
        return this.coords.imageToWorldX(this.frameNumber, 0.0, 0.0);
    }

    @Override
    public double getY() {
        return this.coords.imageToWorldY(this.frameNumber, 0.0, 0.0);
    }

    @Override
    public void setFrameXY(int n, double d, double d2) {
        double d3 = this.coords.getSine(n);
        double d4 = this.coords.getCosine(n);
        double d5 = this.coords.getScaleX(n) * (d2 * d3 - d * d4);
        double d6 = this.coords.getScaleY(n) * (d2 * d4 + d * d3);
        this.coords.setOriginXY(n, d5, d6);
    }

    @Override
    public void setXY(double d, double d2) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameXY(n, d, d2);
            ++n;
        }
    }

    @Override
    public void setFrameRelativeAspect(int n, double d) {
        if (d < 0.001 || d > 1000.0) {
            return;
        }
        this.aspects.set(n, Math.abs(d));
        if (this.isMeasured) {
            if (this.widthDominates) {
                this.setFrameWidth(n, (double)this.size.width / this.coords.getScaleX(n));
            } else {
                this.setFrameHeight(n, (double)this.size.height / this.coords.getScaleY(n));
            }
        }
    }

    @Override
    public void setRelativeAspect(double d) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameRelativeAspect(n, d);
            ++n;
        }
    }

    @Override
    public double getRelativeAspect() {
        return this.aspects.get(this.frameNumber);
    }

    @Override
    public void setFrameWidth(int n, double d) {
        if (d == 0.0) {
            return;
        }
        d = Math.abs(d);
        double d2 = this.coords.imageToWorldX(n, 0.0, 0.0);
        double d3 = this.coords.imageToWorldY(n, 0.0, 0.0);
        double d4 = (double)this.size.width / d;
        this.coords.setScaleX(n, d4);
        this.coords.setScaleY(n, d4 * this.aspects.get(n));
        this.widthDominates = true;
        this.setFrameXY(n, d2, d3);
    }

    @Override
    public void setWidth(double d) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameWidth(n, d);
            ++n;
        }
    }

    @Override
    public double getWidth() {
        return (double)this.size.width / this.coords.getScaleX(this.frameNumber);
    }

    @Override
    public void setFrameHeight(int n, double d) {
        if (d == 0.0) {
            return;
        }
        d = Math.abs(d);
        double d2 = this.coords.imageToWorldX(n, 0.0, 0.0);
        double d3 = this.coords.imageToWorldY(n, 0.0, 0.0);
        double d4 = (double)this.size.height / d;
        this.coords.setScaleY(n, d4);
        this.coords.setScaleX(n, d4 / this.aspects.get(n));
        this.widthDominates = false;
        this.setFrameXY(n, d2, d3);
    }

    @Override
    public void setHeight(double d) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameHeight(n, d);
            ++n;
        }
    }

    @Override
    public double getHeight() {
        return (double)this.size.height / this.coords.getScaleY(this.frameNumber);
    }

    @Override
    public void setFrameAngle(int n, double d) {
        double d2 = this.coords.imageToWorldX(n, 0.0, 0.0);
        double d3 = this.coords.imageToWorldY(n, 0.0, 0.0);
        double d4 = Math.cos(d);
        double d5 = Math.sin(d);
        this.coords.setCosineSine(n, d4, -d5);
        this.setFrameXY(n, d2, d3);
    }

    @Override
    public void setAngle(double d) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameAngle(n, d);
            ++n;
        }
    }

    @Override
    public double getAngle() {
        return -this.coords.getAngle(this.frameNumber);
    }

    @Override
    public void step() {
        this.stop();
        this.setFrameNumber(this.frameNumber + 1);
    }

    @Override
    public void back() {
        this.stop();
        this.setFrameNumber(this.frameNumber - 1);
    }

    @Override
    public int getFrameCount() {
        return this.frameCount;
    }

    @Override
    public int getFrameNumber() {
        return this.frameNumber;
    }

    @Override
    public void setFrameNumber(int n) {
        if (n == this.frameNumber) {
            return;
        }
        n = Math.min(n, this.endFrameNumber);
        n = Math.max(n, this.startFrameNumber);
        this.firePropertyChange("nextframe", null, n);
        this.frameNumber = n;
    }

    @Override
    public int getStartFrameNumber() {
        return this.startFrameNumber;
    }

    @Override
    public void setStartFrameNumber(int n) {
        if (n == this.startFrameNumber) {
            return;
        }
        n = Math.max(0, n);
        this.startFrameNumber = Math.min(this.endFrameNumber, n);
        this.firePropertyChange("startframe", null, new Integer(this.startFrameNumber));
    }

    @Override
    public int getEndFrameNumber() {
        return this.endFrameNumber;
    }

    @Override
    public void setEndFrameNumber(int n) {
        if (n == this.endFrameNumber) {
            return;
        }
        if (this.frameCount > 1) {
            n = Math.min(this.frameCount - 1, n);
        }
        this.endFrameNumber = Math.max(this.startFrameNumber, n);
        this.firePropertyChange("endframe", null, new Integer(this.endFrameNumber));
    }

    @Override
    public double getFrameTime(int n) {
        return -1.0;
    }

    @Override
    public double getFrameDuration(int n) {
        if (this.frameCount == 1) {
            return this.getDuration();
        }
        if (n == this.frameCount - 1) {
            return this.getDuration() - this.getFrameTime(n);
        }
        return this.getFrameTime(n + 1) - this.getFrameTime(n);
    }

    @Override
    public void play() {
        this.playing = true;
    }

    @Override
    public void stop() {
        this.playing = false;
    }

    @Override
    public void reset() {
        this.stop();
        this.setFrameNumber(this.startFrameNumber);
    }

    @Override
    public double getTime() {
        return -1.0;
    }

    @Override
    public void setTime(double d) {
    }

    @Override
    public double getStartTime() {
        return -1.0;
    }

    @Override
    public void setStartTime(double d) {
    }

    @Override
    public double getEndTime() {
        return -1.0;
    }

    @Override
    public void setEndTime(double d) {
    }

    @Override
    public double getDuration() {
        return -1.0;
    }

    @Override
    public void goToStart() {
        this.setFrameNumber(this.startFrameNumber);
    }

    @Override
    public void goToEnd() {
        this.setFrameNumber(this.endFrameNumber);
    }

    @Override
    public void setPlaying(boolean bl) {
        if (bl) {
            this.play();
        } else {
            this.stop();
        }
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public void setLooping(boolean bl) {
        if (this.looping == bl) {
            return;
        }
        this.looping = bl;
        this.firePropertyChange("looping", null, new Boolean(this.looping));
    }

    @Override
    public boolean isLooping() {
        return this.looping;
    }

    @Override
    public void setRate(double d) {
        if ((d = Math.abs(d)) == this.rate || d == 0.0) {
            return;
        }
        this.rate = d;
    }

    @Override
    public double getRate() {
        return this.rate;
    }

    @Override
    public void setCoords(ImageCoordSystem imageCoordSystem) {
        if (imageCoordSystem == this.coords) {
            return;
        }
        this.coords.removePropertyChangeListener(this);
        imageCoordSystem.addPropertyChangeListener(this);
        this.coords = imageCoordSystem;
        this.isMeasured = true;
        this.isValidMeasure = false;
        this.firePropertyChange("coords", null, imageCoordSystem);
    }

    @Override
    public ImageCoordSystem getCoords() {
        return this.coords;
    }

    @Override
    public void setFilterStack(FilterStack filterStack) {
        this.filterStack.removePropertyChangeListener(this);
        this.filterStack = filterStack;
        this.filterStack.addPropertyChangeListener(this);
    }

    @Override
    public FilterStack getFilterStack() {
        return this.filterStack;
    }

    @Override
    public void setProperty(String string, Object object) {
        if (string.equals("measure")) {
            this.isValidMeasure = false;
        } else {
            this.properties.put(string, object);
        }
    }

    @Override
    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void dispose() {
        if (this.coords != null) {
            this.coords.removePropertyChangeListener(this);
        }
        this.getFilterStack().setInspectorsVisible(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.coords) {
            this.isMeasured = true;
            this.isValidMeasure = false;
        } else if (propertyChangeEvent.getSource() == this.filterStack) {
            this.isValidFilteredImage = false;
            this.support.firePropertyChange(propertyChangeEvent);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.support.firePropertyChange(string, object, object2);
    }

    protected void finalize() {
        this.dispose();
    }

    protected void initialize() {
        this.support = new SwingPropertyChangeSupport(this);
        this.filterStack.addPropertyChangeListener(this);
    }

    protected void refreshBufferedImage() {
        if (this.bufferedImage == null || this.bufferedImage.getWidth() != this.size.width || this.bufferedImage.getHeight() != this.size.height) {
            this.bufferedImage = new BufferedImage(this.size.width, this.size.height, 1);
            int n = new Color(0, 0, 0, 0).getRGB();
            int[] nArray = new int[this.size.width * this.size.height];
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = n;
                ++n2;
            }
            this.bufferedImage.setRGB(0, 0, this.size.width, this.size.height, nArray, 0, this.size.width);
            this.clearRaster = this.bufferedImage.getData();
            this.isValidImage = false;
        }
    }

    protected void findMinMaxValues() {
        VideoClip videoClip = (VideoClip)this.getProperty("videoclip");
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        int n = 0;
        if (videoClip != null) {
            n = videoClip.getStartFrameNumber();
        }
        AffineTransform affineTransform = this.coords.getToWorldTransform(n);
        affineTransform.transform(double_, double_);
        this.maxX = this.minX = ((Point2D)double_).getX();
        this.maxY = this.minY = ((Point2D)double_).getY();
        int n2 = this.frameCount;
        if (videoClip != null) {
            n2 = videoClip.getStepCount();
        }
        int n3 = 0;
        while (n3 < n2) {
            affineTransform = videoClip == null ? this.coords.getToWorldTransform(n3) : this.coords.getToWorldTransform(videoClip.stepToFrame(n3));
            int n4 = 0;
            while (n4 < 4) {
                switch (n4) {
                    case 0: {
                        ((Point2D)double_).setLocation(0.0, 0.0);
                        break;
                    }
                    case 1: {
                        ((Point2D)double_).setLocation(this.size.width, 0.0);
                        break;
                    }
                    case 2: {
                        ((Point2D)double_).setLocation(0.0, this.size.height);
                        break;
                    }
                    case 3: {
                        ((Point2D)double_).setLocation(this.size.width, this.size.height);
                    }
                }
                affineTransform.transform(double_, double_);
                this.minX = Math.min(((Point2D)double_).getX(), this.minX);
                this.maxX = Math.max(((Point2D)double_).getX(), this.maxX);
                this.minY = Math.min(((Point2D)double_).getY(), this.minY);
                this.maxY = Math.max(((Point2D)double_).getY(), this.maxY);
                ++n4;
            }
            ++n3;
        }
        this.isValidMeasure = true;
    }
}

