/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;

public class VideoMouseHandler
implements InteractiveMouseHandler {
    Interactive iad = null;
    TPoint p = null;
    Rectangle bounds;

    public void handleMouseAction(InteractivePanel interactivePanel, MouseEvent mouseEvent) {
        if (!(interactivePanel instanceof VideoPanel)) {
            return;
        }
        VideoPanel videoPanel = (VideoPanel)interactivePanel;
        switch (videoPanel.getMouseAction()) {
            case 1: {
                if (this.iad == null || !(this.iad instanceof TPoint)) break;
                this.p = (TPoint)this.iad;
                this.bounds = this.p.getBounds(videoPanel);
                this.p.setXY(videoPanel.getMouseX(), videoPanel.getMouseY());
                if (this.bounds != null) {
                    this.bounds.add(this.p.getBounds(videoPanel));
                    videoPanel.repaint(this.bounds);
                    break;
                }
                videoPanel.repaint();
                break;
            }
            case 2: {
                this.p = null;
                this.iad = null;
                break;
            }
            case 3: {
                if (this.p == null) break;
                this.bounds = this.p.getBounds(videoPanel);
                this.p.setXY(videoPanel.getMouseX(), videoPanel.getMouseY());
                if (this.bounds != null) {
                    this.bounds.add(this.p.getBounds(videoPanel));
                    videoPanel.repaint(this.bounds);
                    break;
                }
                videoPanel.repaint();
                break;
            }
            case 7: {
                if (videoPanel.isDrawingInImageSpace()) {
                    this.iad = videoPanel.getInteractive();
                }
                if (this.iad != null && this.iad instanceof TPoint) {
                    videoPanel.setMouseCursor(Cursor.getPredefinedCursor(12));
                    break;
                }
                videoPanel.setMouseCursor(Cursor.getDefaultCursor());
            }
        }
        if (this.p == null) {
            videoPanel.hideMouseBox();
        } else {
            this.p.showCoordinates(videoPanel);
        }
    }
}

