/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.quicktime;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.media.quicktime.QTVideo;
import org.opensourcephysics.media.quicktime.QTVideoRecorder;
import quicktime.QTSession;

public class QTVideoType
implements VideoType {
    protected static TreeSet<VideoFileFilter> qtFileFilters = new TreeSet();
    protected static PropertyChangeListener errorListener;
    protected static boolean isQTAvailable;
    private VideoFileFilter singleTypeFilter;

    static {
        isQTAvailable = true;
        errorListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("qt_error")) {
                    isQTAvailable = false;
                }
            }
        };
        OSPLog.getOSPLog().addPropertyChangeListener(errorListener);
    }

    public QTVideoType() {
        if (!isQTAvailable) {
            throw new Error("QuickTime unavailable");
        }
        boolean bl = OSPLog.isConsoleMessagesLogged();
        try {
            OSPLog.setConsoleMessagesLogged(false);
            QTSession.open();
            OSPLog.setConsoleMessagesLogged(bl);
        }
        catch (Exception exception) {
            OSPLog.setConsoleMessagesLogged(bl);
            throw new Error("QuickTime unavailable");
        }
    }

    public QTVideoType(VideoFileFilter videoFileFilter) {
        this();
        if (videoFileFilter != null) {
            this.singleTypeFilter = videoFileFilter;
            qtFileFilters.add(videoFileFilter);
        }
    }

    public Video getVideo(String string) {
        try {
            QTVideo qTVideo = new QTVideo(string);
            qTVideo.setProperty("video_type", this);
            return qTVideo;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public VideoRecorder getRecorder() {
        return new QTVideoRecorder(this);
    }

    public boolean canRecord() {
        return true;
    }

    public String getDescription() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter.getDescription();
        }
        return MediaRes.getString("QTVideoType.Description");
    }

    public String getDefaultExtension() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter.getDefaultExtension();
        }
        return null;
    }

    public VideoFileFilter[] getFileFilters() {
        if (this.singleTypeFilter != null) {
            return new VideoFileFilter[]{this.singleTypeFilter};
        }
        return qtFileFilters.toArray(new VideoFileFilter[0]);
    }

    public VideoFileFilter getDefaultFileFilter() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter;
        }
        return null;
    }

    public boolean isType(Video video) {
        if (!video.getClass().equals(QTVideo.class)) {
            return false;
        }
        if (this.singleTypeFilter == null) {
            return true;
        }
        String string = (String)video.getProperty("name");
        return this.singleTypeFilter.accept(new File(string));
    }
}

