/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODESolverException;
import org.opensourcephysics.numerics.RK45;

public class RK45MultiStep
extends RK45 {
    private static int maxMessages = 3;
    private double fixedStepSize = 0.1;
    protected int maxIterations = 200;

    public RK45MultiStep(ODE oDE) {
        super(oDE);
    }

    public double step() {
        this.error_code = 0;
        if (this.fixedStepSize > 0.0) {
            return this.fixedStepSize - this.plus();
        }
        return this.fixedStepSize - this.minus();
    }

    public void setMaxIterations(int n) {
        this.maxIterations = Math.max(1, n);
    }

    private double plus() {
        double d = this.fixedStepSize;
        if (super.getStepSize() <= 0.0 || super.getStepSize() > this.fixedStepSize || this.fixedStepSize - super.getStepSize() == this.fixedStepSize) {
            super.setStepSize(this.fixedStepSize);
        }
        int n = 0;
        while (d > this.tol * this.fixedStepSize) {
            ++n;
            double d2 = d;
            if (d < super.getStepSize()) {
                double d3 = super.getStepSize();
                super.setStepSize(d);
                double d4 = super.step();
                d -= d4;
                super.setStepSize(d3);
            } else {
                d -= super.step();
            }
            if (this.error_code == 0 && !(Math.abs(d2 - d) <= (double)1.4E-45f) && !(this.tol * this.fixedStepSize / 10.0 > super.getStepSize()) && n <= this.maxIterations) continue;
            this.error_code = 1;
            if (this.enableExceptions) {
                throw new ODESolverException("RK45 ODE solver did not converge.");
            }
            System.err.println("Warning: RK45MultiStep did not converge. Remainder=" + d);
            if (--maxMessages != 0) break;
            System.err.println("RK45 ODE solver did not converge. Further warnings suppressed.");
            break;
        }
        return d;
    }

    private double minus() {
        double d = this.fixedStepSize;
        if (super.getStepSize() >= 0.0 || super.getStepSize() < this.fixedStepSize || this.fixedStepSize - super.getStepSize() == this.fixedStepSize) {
            super.setStepSize(this.fixedStepSize);
        }
        int n = 0;
        while (d < this.tol * this.fixedStepSize) {
            ++n;
            double d2 = d;
            if (d > super.getStepSize()) {
                double d3 = super.getStepSize();
                super.setStepSize(d);
                double d4 = super.step();
                d -= d4;
                super.setStepSize(d3);
            } else {
                d -= super.step();
            }
            if (this.error_code == 0 && !(Math.abs(d2 - d) <= (double)1.4E-45f) && !(this.tol * this.fixedStepSize / 10.0 < super.getStepSize()) && n <= this.maxIterations) continue;
            this.error_code = 1;
            if (this.enableExceptions) {
                throw new ODESolverException("RK45 ODE solver did not converge.");
            }
            if (maxMessages <= 0) break;
            System.err.println("Warning: RK45MultiStep did not converge. Remainder=" + d);
            if (--maxMessages != 0) break;
            System.err.println("Further warnings surppressed.");
            break;
        }
        return d;
    }

    public void setMaximumNumberOfErrorMessages(int n) {
        maxMessages = n;
    }

    public void initialize(double d) {
        this.fixedStepSize = d;
        super.initialize(d / 2.0);
    }

    public void setStepSize(double d) {
        maxMessages = 4;
        this.fixedStepSize = d;
        if (d < 0.0) {
            super.setStepSize(Math.max(-Math.abs(super.getStepSize()), d));
        } else {
            super.setStepSize(Math.min(super.getStepSize(), d));
        }
        super.setStepSize(d);
    }

    public double getStepSize() {
        return this.fixedStepSize;
    }

    public int getErrorCode() {
        return this.error_code;
    }
}

