/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.approach;

import java.awt.event.WindowListener;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.ejs.control.EjsSimulationControl;
import org.opensourcephysics.stp.approach.BoxApp;
import org.opensourcephysics.stp.approach.BoxWRAppControl;

public class BoxWRApp
extends BoxApp {
    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = BoxWRApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(BoxWRApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                BoxApp boxApp = new BoxApp();
                SimulationControl simulationControl = SimulationControl.createApp(boxApp);
                simulationControl.setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        simulationControl.addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                simulationControl.loadXML(xMLControlElement, true);
                simulationControl.setValue("model", null);
                boxApp.customize();
                boxApp.initialize();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void setParameter() {
        this.plotFrame.clearData();
        this.initialize();
        GUIUtils.repaintOSPFrames();
    }

    public void doStep() {
        super.doStep();
        this.stopRunning();
    }

    public void stopRunning() {
        if (this.control == null) {
            return;
        }
        String string = this.numberFormatTwoDigits.format((double)this.nleftAccumulator / (double)this.zeroedTime);
        String string2 = this.numberFormatTwoDigits.format((double)this.nleftSquaredAccumulator / (double)this.zeroedTime);
        String string3 = this.numberFormatTwoDigits.format((double)this.nleftSquaredAccumulator / (double)this.zeroedTime - (double)this.nleftAccumulator * (double)this.nleftAccumulator / (double)this.zeroedTime / (double)this.zeroedTime);
        ((EjsSimulationControl)this.control).getControl("avgNumber").setProperty("value", string);
        ((EjsSimulationControl)this.control).getControl("avgNumber2").setProperty("value", string2);
        ((EjsSimulationControl)this.control).getControl("sigma").setProperty("value", string3);
    }

    public void zeroAverages() {
        this.nleftAccumulator = 0;
        this.nleftSquaredAccumulator = 0;
        this.zeroedTime = 0;
        this.datasets.clear();
        GUIUtils.repaintOSPFrames();
        if (this.control == null) {
            return;
        }
        ((EjsSimulationControl)this.control).getControl("avgNumber").setProperty("value", "");
        ((EjsSimulationControl)this.control).getControl("avgNumber2").setProperty("value", "");
        ((EjsSimulationControl)this.control).getControl("sigma").setProperty("value", "");
    }

    public static void main(String[] stringArray) {
        BoxWRApp boxWRApp = new BoxWRApp();
        new BoxWRAppControl(boxWRApp, (DrawingFrame)boxWRApp.plotFrame, stringArray);
        boxWRApp.customize();
    }
}

