/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.approach;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;

public class LJgas2box
implements Drawable {
    public double[] x;
    public double[] y;
    public double[] vx;
    public double[] vy;
    public double[] ax;
    public double[] ay;
    public int numberOfParticles = 270;
    public double cellLength;
    public double rho = 0.2;
    public double x0;
    public double temperature = 5.0;
    public int steps = 0;
    public double dt = 0.01;
    public int n0 = 0;
    public int n1 = 0;
    double radius = 0.3;
    public double cut2 = 9.0;
    public double t = 0.0;

    public LJgas2box() {
        this.setArrays();
    }

    public void setArrays() {
        int n = this.numberOfParticles;
        this.x = new double[n];
        this.y = new double[n];
        this.vx = new double[n];
        this.vy = new double[n];
        this.ax = new double[n];
        this.ay = new double[n];
    }

    public void initialize() {
        this.cellLength = Math.sqrt((double)this.numberOfParticles / this.rho);
        this.reset();
        this.setArrays();
        this.setPositions();
        this.setVelocities();
        this.accel();
    }

    public void setPositions() {
        double d = this.cellLength / 2.0;
        int n = 0;
        while (n < this.numberOfParticles) {
            boolean bl;
            do {
                bl = false;
                this.x[n] = d * Math.random();
                this.y[n] = 0.0 + this.cellLength * Math.random();
                int n2 = 0;
                while (n2 < n && !bl) {
                    double d2 = this.x[n] - this.x[n2];
                    double d3 = this.y[n] - this.y[n2];
                    if (d2 * d2 + (d3 = this.pbc(d3)) * d3 < 1.0) {
                        bl = true;
                    }
                    ++n2;
                }
            } while (bl);
            ++n;
        }
    }

    public void setVelocities() {
        double d = Math.PI * 2;
        int n = 0;
        while (n < this.numberOfParticles) {
            double d2 = Math.random();
            double d3 = Math.random() * d;
            this.vx[n] = Math.sqrt(-2.0 * this.temperature * Math.log(d2)) * Math.cos(d3);
            this.vy[n] = Math.sqrt(-2.0 * this.temperature * Math.log(d2)) * Math.sin(d3);
            ++n;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = 0;
        while (n2 < this.numberOfParticles) {
            d4 += this.vx[n2];
            d5 += this.vy[n2];
            ++n2;
        }
        double d6 = d4 / (double)this.numberOfParticles;
        double d7 = d5 / (double)this.numberOfParticles;
        int n3 = 0;
        while (n3 < this.numberOfParticles) {
            int n4 = n3;
            this.vx[n4] = this.vx[n4] - d6;
            int n5 = n3++;
            this.vy[n5] = this.vy[n5] - d7;
        }
    }

    public void reset() {
        this.steps = 0;
        this.t = 0.0;
        this.n0 = 0;
        this.n1 = 0;
        this.x0 = this.cellLength / 2.0;
    }

    public void zeroAverages() {
        this.steps = 0;
        this.n0 = 0;
        this.n1 = 0;
    }

    public void accel() {
        int n = 0;
        while (n < this.numberOfParticles) {
            this.ax[n] = 0.0;
            this.ay[n] = 0.0;
            ++n;
        }
        n = 0;
        while (n < this.numberOfParticles - 1) {
            int n2 = n + 1;
            while (n2 < this.numberOfParticles) {
                double d;
                double d2 = this.pbc(this.x[n] - this.x[n2]);
                double d3 = d2 * d2 + (d = this.pbc(this.y[n] - this.y[n2])) * d;
                if (d3 < this.cut2) {
                    double d4 = 1.0 / d3;
                    double d5 = d4 * d4 * d4;
                    double d6 = 48.0 * d5 * (d5 - 0.5) * d4;
                    double d7 = d6 * d2;
                    double d8 = d6 * d;
                    int n3 = n;
                    this.ax[n3] = this.ax[n3] + d7;
                    int n4 = n;
                    this.ay[n4] = this.ay[n4] + d8;
                    int n5 = n2;
                    this.ax[n5] = this.ax[n5] - d7;
                    int n6 = n2;
                    this.ay[n6] = this.ay[n6] - d8;
                }
                ++n2;
            }
            ++n;
        }
    }

    private double pbc(double d) {
        if (d > 0.5 * this.cellLength) {
            d -= this.cellLength;
        } else if (d < -0.5 * this.cellLength) {
            d += this.cellLength;
        }
        return d;
    }

    private double image(double d) {
        if (d > this.cellLength) {
            d -= this.cellLength;
        } else if (d < 0.0) {
            d += this.cellLength;
        }
        return d;
    }

    public void step() {
        double d = 0.5 * this.dt * this.dt;
        double d2 = 0.5 * this.dt;
        this.n0 = 0;
        this.n1 = 0;
        int n = 0;
        while (n < this.numberOfParticles) {
            int n2 = n;
            this.x[n2] = this.x[n2] + (this.vx[n] * this.dt + this.ax[n] * d);
            int n3 = n;
            this.y[n3] = this.y[n3] + (this.vy[n] * this.dt + this.ay[n] * d);
            this.x[n] = this.image(this.x[n]);
            this.y[n] = this.image(this.y[n]);
            int n4 = n;
            this.vx[n4] = this.vx[n4] + this.ax[n] * d2;
            int n5 = n;
            this.vy[n5] = this.vy[n5] + this.ay[n] * d2;
            if (this.x[n] < this.x0) {
                ++this.n0;
            } else {
                ++this.n1;
            }
            ++n;
        }
        this.accel();
        n = 0;
        while (n < this.numberOfParticles) {
            int n6 = n;
            this.vx[n6] = this.vx[n6] + this.ax[n] * d2;
            int n7 = n;
            this.vy[n7] = this.vy[n7] + this.ay[n] * d2;
            ++n;
        }
        ++this.steps;
        this.t += this.dt;
    }

    public void reverse() {
        int n = 0;
        while (n < this.numberOfParticles) {
            this.vx[n] = -this.vx[n];
            this.vy[n] = -this.vy[n];
            ++n;
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n;
        int n2;
        if (this.x == null) {
            return;
        }
        int n3 = Math.abs(drawingPanel.xToPix(this.radius) - drawingPanel.xToPix(0.0));
        int n4 = Math.abs(drawingPanel.yToPix(this.radius) - drawingPanel.yToPix(0.0));
        if (n3 < 1) {
            n3 = 1;
        }
        if (n4 < 1) {
            n4 = 1;
        }
        int n5 = 0;
        while (n5 < this.numberOfParticles) {
            n2 = drawingPanel.xToPix(this.x[n5]) - n3;
            n = drawingPanel.yToPix(this.y[n5]) - n4;
            Color color = Color.BLACK;
            if (this.x[n5] > this.cellLength / 2.0) {
                color = Color.BLUE;
            }
            graphics.setColor(color);
            graphics.fillOval(n2, n, 2 * n3, 2 * n4);
            ++n5;
        }
        graphics.setColor(Color.black);
        n5 = drawingPanel.xToPix(0.0);
        n2 = drawingPanel.yToPix(this.cellLength);
        n = drawingPanel.xToPix(this.cellLength) - drawingPanel.xToPix(0.0);
        int n6 = drawingPanel.yToPix(0.0) - drawingPanel.yToPix(this.cellLength);
        graphics.drawRect(n5, n2, n, n6);
        graphics.drawLine(n5 + n / 2, n2, n5 + n / 2, n2 + n6);
        graphics.drawLine(n5, n2, n5, n2 + n6);
        graphics.drawLine(n5 + n, n2, n5 + n, n2 + n6);
        graphics.drawLine(n5, n2, n5 + n, n2);
        graphics.drawLine(n5, n2 + n6, n5 + n, n2 + n6);
    }
}

