/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.boltzmann;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.util.Random;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.HistogramFrame;
import org.opensourcephysics.stp.boltzmann.BoltzmannControl;
import org.opensourcephysics.stp.boltzmann.BoltzmannWRApp;

public class BoltzmannApp
extends AbstractCalculation {
    Random random;
    HistogramFrame energyFrame = new HistogramFrame("E", "H(E)", "H(E)");
    HistogramFrame velocityFrame = new HistogramFrame("v", "H(v)", "H(v)");
    double energyAccumulator;
    double velocityAccumulator;
    double beta;
    double velocity;
    double temperature;
    double energy;
    double delta;
    int mcs;
    int numberOfBins;
    int nequil;
    int accept = 0;
    NumberFormat nf;

    public BoltzmannApp() {
        this.velocityFrame.setBinWidth(0.1);
        this.energyFrame.setBinWidth(0.1);
        this.random = new Random(System.currentTimeMillis());
        this.energyFrame.setAutoscaleX(true);
        this.energyFrame.setPreferredMinMaxX(0.0, 50.0);
        this.energyFrame.setAutoscaleY(true);
        this.velocityFrame.setPreferredMinMaxX(-10.0, 10.0);
        this.velocityFrame.setPreferredMinMaxY(0.0, 10.0);
        this.velocityFrame.setAutoscaleX(true);
        this.velocityFrame.setAutoscaleY(true);
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(4);
        this.velocityFrame.setXYColumnNames("velocity", "counts", "Velocity Histogram");
        this.energyFrame.setXYColumnNames("energy", "counts", "Energy Histogram");
    }

    public void calculate() {
        this.clearData();
        this.temperature = this.control.getDouble("Temperature");
        this.beta = 1.0 / this.temperature;
        this.mcs = this.control.getInt("Number of MC steps");
        this.nequil = this.mcs / 10;
        this.velocity = this.control.getDouble("Initial Speed");
        this.energy = 0.5 * this.velocity * this.velocity;
        this.delta = this.control.getDouble("delta");
        int n = 1;
        while (n <= this.mcs) {
            this.metropolis();
            ++n;
        }
        this.accept = 0;
        n = 1;
        while (n <= this.mcs) {
            this.metropolis();
            this.update();
            ++n;
        }
        this.outputResult();
    }

    void outputResult() {
        this.control.println(" running ... ");
        double d = (double)this.accept / (double)this.mcs;
        this.control.println("acceptance probability = " + this.nf.format(d));
        this.control.println("mean velocity = " + this.nf.format(this.velocityAccumulator / (double)this.mcs));
        double d2 = this.energyAccumulator / (double)this.mcs;
        this.control.println("<E> = " + this.nf.format(d2));
    }

    void outputAfterReset() {
        this.control.println("acceptance probability = 0");
        this.control.println("mean velocity = 0");
        this.control.println("<E> = 0");
        this.control.println();
    }

    public void reset() {
        this.control.setValue("Temperature", 1.0);
        this.control.setValue("Number of MC steps", 100000);
        this.control.setValue("Initial Speed", 1.0);
        this.control.setValue("delta", 4.0);
        this.control.clearMessages();
        this.clearData();
        this.outputAfterReset();
    }

    public void clearData() {
        this.velocityFrame.clearData();
        this.energyFrame.clearData();
        this.energyAccumulator = 0.0;
        this.velocityAccumulator = 0.0;
        this.accept = 0;
        this.velocityFrame.repaint();
        this.energyFrame.repaint();
    }

    public void metropolis() {
        double d = (2.0 * this.random.nextDouble() - 1.0) * this.delta;
        double d2 = this.velocity + d;
        double d3 = 0.5 * (d2 * d2 - this.velocity * this.velocity);
        if (d3 > 0.0 && Math.exp(-this.beta * d3) < this.random.nextDouble()) {
            return;
        }
        this.velocity = d2;
        this.energy += d3;
        ++this.accept;
    }

    public void update() {
        this.energyAccumulator += this.energy;
        this.velocityAccumulator += this.velocity;
        this.velocityFrame.append(this.velocity);
        this.energyFrame.append(this.energy);
    }

    public void switchGUI() {
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = BoltzmannApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(BoltzmannApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                BoltzmannWRApp boltzmannWRApp = new BoltzmannWRApp();
                BoltzmannControl boltzmannControl = new BoltzmannControl(boltzmannWRApp, boltzmannWRApp.energyFrame, null);
                boltzmannControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        boltzmannControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                boltzmannControl.loadXML(xMLControlElement, true);
                boltzmannWRApp.customize();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoltzmannApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.energyFrame);
        this.addChildFrame(this.velocityFrame);
    }

    public static void main(String[] stringArray) {
        BoltzmannApp boltzmannApp = new BoltzmannApp();
        CalculationControl.createApp(boltzmannApp, stringArray);
        boltzmannApp.customize();
    }
}

