/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.boltzmann;

import java.awt.event.WindowListener;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.ejs.control.EjsCalculationControl;
import org.opensourcephysics.stp.boltzmann.BoltzmannApp;
import org.opensourcephysics.stp.boltzmann.BoltzmannControl;

public class BoltzmannWRApp
extends BoltzmannApp {
    public void switchGUI() {
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = BoltzmannWRApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(BoltzmannWRApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                BoltzmannApp boltzmannApp = new BoltzmannApp();
                CalculationControl calculationControl = CalculationControl.createApp(boltzmannApp);
                calculationControl.setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        calculationControl.addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                calculationControl.loadXML(xMLControlElement, true);
                calculationControl.setValue("model", null);
                boltzmannApp.customize();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void outputResult() {
        if (this.control == null) {
            return;
        }
        double d = this.energyAccumulator / (double)this.mcs;
        ((EjsCalculationControl)this.control).getControl("meanV").setProperty("value", this.nf.format(this.velocityAccumulator / (double)this.mcs));
        ((EjsCalculationControl)this.control).getControl("meanE").setProperty("value", this.nf.format(d));
    }

    void outputAfterReset() {
        if (this.control == null) {
            return;
        }
        ((EjsCalculationControl)this.control).getControl("meanV").setProperty("value", "0");
        ((EjsCalculationControl)this.control).getControl("meanE").setProperty("value", "0");
    }

    public static void main(String[] stringArray) {
        BoltzmannWRApp boltzmannWRApp = new BoltzmannWRApp();
        new BoltzmannControl(boltzmannWRApp, boltzmannWRApp.energyFrame, stringArray);
        boltzmannWRApp.customize();
    }
}

