/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.carnot;

import java.awt.Color;
import java.awt.event.MouseEvent;
import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.carnot.Vertex;

public class CarnotApp
extends AbstractCalculation
implements InteractiveMouseHandler {
    double dr2 = 4.0;
    Vertex[] V;
    double v0;
    double v1;
    double v2;
    double v3;
    double p0;
    double p1;
    double p2;
    double p3;
    double g = 1.3333333333333333;
    double dv = 0.01;
    PlotFrame plotFrame = new PlotFrame("V", "P", "P-V Diagram");

    public CarnotApp() {
        this.V = new Vertex[4];
        int n = 0;
        while (n < 4) {
            this.V[n] = new Vertex(1.0, 1.0);
            ++n;
        }
        this.plotFrame.setMarkerColor(0, Color.red);
        this.plotFrame.setMarkerColor(1, Color.red);
        this.plotFrame.setMarkerColor(2, Color.GREEN);
        this.plotFrame.setMarkerColor(3, Color.GREEN);
    }

    public void calculate() {
        this.drawCurves();
    }

    public void drawCurves() {
        this.plotFrame.clearData();
        this.addCurve(this.V[0], this.V[1], this.g, 0);
        this.addCurve(this.V[2], this.V[3], this.g, 1);
        this.addCurve(this.V[0], this.V[2], 1.0, 2);
        this.addCurve(this.V[1], this.V[3], 1.0, 3);
        this.plotFrame.render();
    }

    public void addCurve(Vertex vertex, Vertex vertex2, double d, int n) {
        double d2 = vertex.v;
        double d3 = vertex.getProd(d);
        double d4 = this.dv;
        if (vertex2.v < vertex.v) {
            d4 = -this.dv;
        }
        while (Math.abs(d2 - vertex2.v) > this.dv) {
            double d5 = d3 * Math.pow(d2, -d);
            this.plotFrame.append(n, d2, d5);
            d2 += d4;
        }
    }

    public void resetCalculation() {
        this.control.clearMessages();
        this.plotFrame.clearData();
        this.p0 = 5.0;
        this.v0 = 2.0;
        this.p3 = 2.0;
        this.v3 = 3.0;
        this.V[0].set(this.p0, this.v0);
        this.V[3].set(this.p3, this.v3);
        this.update(1, 2);
        this.plotFrame.repaint();
        this.plotFrame.setInteractiveMouseHandler(this);
    }

    public void handleMouseAction(InteractivePanel interactivePanel, MouseEvent mouseEvent) {
        int n = -1;
        interactivePanel.getMouseAction();
        if (interactivePanel.getMouseAction() == 3) {
            double d = interactivePanel.getMouseX();
            double d2 = interactivePanel.getMouseY();
            n = this.MouseOnCurve(d, d2);
            System.out.println(String.valueOf(n) + "\t" + d + "\t" + d2);
            if (d > 0.0 && d2 > 0.0) {
                this.drawCurve(n, d, d2);
            }
        }
        if (interactivePanel.getMouseAction() == 2) {
            this.plotFrame.setMessage("");
        }
    }

    public int MouseOnCurve(double d, double d2) {
        int n = 0;
        while (n < 4) {
            double d3 = this.V[n].v;
            double d4 = d3 - d;
            double d5 = this.V[n].p;
            double d6 = d5 - d2;
            if (d4 * d4 + d6 * d6 < this.dr2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void drawCurve(int n, double d, double d2) {
        if (!this.check(d2, d)) {
            return;
        }
        if (n == 0 || n == 3) {
            Vertex vertex = new Vertex(this.V[n].p, this.V[n].v);
            this.V[n].set(d2, d);
            if (!this.update(1, 2)) {
                this.V[n].set(vertex);
            }
        } else if (n == 1 || n == 2) {
            Vertex vertex = new Vertex(this.V[n].p, this.V[n].v);
            this.V[n].set(d2, d);
            if (!this.update(0, 3)) {
                this.V[n].set(vertex);
            }
        }
        this.drawCurves();
    }

    public boolean check(Vertex vertex) {
        return !(vertex.v > 10.0) && !(vertex.p > 10.0);
    }

    public boolean check(double d, double d2) {
        return !(d > 20.0) && !(d2 > 20.0);
    }

    public boolean update(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (n == 1 && n2 == 2) {
            n3 = 0;
            n4 = 3;
        }
        if (n == 0 && n2 == 3) {
            n3 = 1;
            n4 = 2;
        }
        this.v1 = Math.pow(this.V[n3].getProd(this.g) / this.V[n4].getProd(), 1.0 / (this.g - 1.0));
        this.p1 = this.V[n4].getProd() / this.v1;
        this.v2 = Math.pow(this.V[n4].getProd(this.g) / this.V[n3].getProd(), 1.0 / (this.g - 1.0));
        this.p2 = this.V[n3].getProd() / this.v2;
        if (!this.check(this.p1, this.v1)) {
            return false;
        }
        if (!this.check(this.p2, this.v2)) {
            return false;
        }
        this.V[n].set(this.p1, this.v1);
        this.V[n2].set(this.p2, this.v2);
        return true;
    }

    public static void main(String[] stringArray) {
        CalculationControl.createApp(new CarnotApp(), stringArray);
    }
}

