/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.cointoss;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.util.Random;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.HistogramFrame;
import org.opensourcephysics.stp.cointoss.MultipleCoinTossWRApp;
import org.opensourcephysics.stp.cointoss.MultipleCoinTossWRAppControl;

public class MultipleCoinTossApp
extends AbstractSimulation {
    Random random;
    int totalFlips;
    double sumHeads = 0.0;
    double sum2Heads = 0.0;
    double probability;
    double coinsToFlip;
    double time;
    double dt;
    HistogramFrame histogramFrame = new HistogramFrame("Heads", "Occurences", "Histogram");
    NumberFormat nf;

    public MultipleCoinTossApp() {
        this.random = new Random();
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(3);
    }

    public void initialize() {
        this.probability = this.control.getDouble("probability");
        this.coinsToFlip = this.control.getInt("coins to flip");
        this.random.setSeed(System.currentTimeMillis());
        this.histogramFrame.setPreferredMinMaxX(0.0, this.coinsToFlip);
        this.histogramFrame.setPreferredMinMaxY(0.0, 10.0);
        this.histogramFrame.setAutoscaleY(true);
        this.histogramFrame.clearData();
        this.histogramFrame.repaint();
        this.totalFlips = 0;
        this.sumHeads = 0.0;
        this.sum2Heads = 0.0;
        this.stopRunning();
    }

    public void start() {
        this.probability = this.control.getDouble("probability");
    }

    public void reset() {
        this.control.setValue("probability", 0.5);
        this.control.setValue("coins to flip", 100);
        this.control.clearMessages();
        this.initialize();
        this.enableStepsPerDisplay(true);
    }

    protected void doStep() {
        this.probability = this.control.getDouble("probability");
        int n = 0;
        int n2 = 0;
        while ((double)n2 < this.coinsToFlip) {
            if (this.random.nextDouble() < this.probability) {
                ++n;
            }
            ++n2;
        }
        ++this.totalFlips;
        this.histogramFrame.append(n);
        this.sumHeads += (double)n;
        this.sum2Heads += (double)(n * n);
    }

    public void stopRunning() {
        this.control.clearMessages();
        double d = this.totalFlips > 0 ? this.sumHeads / (double)this.totalFlips : 0.0;
        double d2 = this.totalFlips > 0 ? this.sum2Heads / (double)this.totalFlips : 0.0;
        this.control.println("<H> = " + this.nf.format(d));
        this.control.println("<H*H> = " + this.nf.format(d2));
        double d3 = Math.sqrt(d2 - d * d);
        if (this.totalFlips > 0) {
            this.control.println("sigma = " + this.nf.format(d3));
        } else {
            this.control.println("sigma = undefined");
        }
        this.control.println("number of trials= " + this.totalFlips);
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = MultipleCoinTossApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(MultipleCoinTossApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                MultipleCoinTossWRApp multipleCoinTossWRApp = new MultipleCoinTossWRApp();
                MultipleCoinTossWRAppControl multipleCoinTossWRAppControl = new MultipleCoinTossWRAppControl(multipleCoinTossWRApp, (DrawingFrame)multipleCoinTossWRApp.histogramFrame, null);
                multipleCoinTossWRAppControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        multipleCoinTossWRAppControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                multipleCoinTossWRAppControl.loadXML(xMLControlElement, true);
                multipleCoinTossWRApp.customize();
                multipleCoinTossWRAppControl.resetSimulation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultipleCoinTossApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.histogramFrame);
    }

    public static void main(String[] stringArray) {
        MultipleCoinTossApp multipleCoinTossApp = new MultipleCoinTossApp();
        SimulationControl.createApp(multipleCoinTossApp, stringArray);
        multipleCoinTossApp.customize();
    }
}

