/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.demon.demonlattice;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.numerics.PBC;

public class DemonLattice
implements Drawable {
    public int arraySize;
    public int[][] s;
    public int[] realSpace;
    public int L;
    public int Lp;
    public int pmax;
    public int steps = 0;
    public int e = 0;
    public int n = 0;
    public int E;
    public int N;
    public int[][] p;
    public int[] ke;
    public int accept;
    public int mcs;
    public double nsum;
    public double esum;
    public double nave;
    public double eave;
    public double Eave;
    public double Esum;
    public double Nave;
    public double Nsum;
    public int hc = 0;
    public int well = 0;

    public void initialize() {
        this.arraySize = this.N;
        this.Lp = 2 * this.pmax + 1;
        this.ke = new int[this.Lp];
        this.s = new int[this.L][this.Lp];
        this.realSpace = new int[this.L];
        int n = 0;
        while (n < this.Lp) {
            this.ke[n] = (n - this.pmax) * (n - this.pmax);
            ++n;
        }
        this.reset();
        n = this.E;
        this.E = 0;
        int n2 = 0;
        while (n2 < this.N) {
            int n3 = (int)(Math.random() * (double)this.L);
            int n4 = (int)(Math.random() * (double)this.Lp);
            while (this.ke[n4] + this.pe(n3, 1) > n || this.s[n3][n4] == 1) {
                n3 = (int)(Math.random() * (double)this.L);
                n4 = (int)(Math.random() * (double)this.Lp);
            }
            int n5 = this.ke[n4] + this.pe(n3, 0);
            n -= n5;
            this.E += n5;
            this.s[n3][n4] = 1;
            int n6 = n3;
            this.realSpace[n6] = this.realSpace[n6] + 1;
            ++n2;
        }
    }

    public int pe(int n, int n2) {
        int n3 = 0;
        if (n2 == 1) {
            n3 = this.realSpace[n] * this.hc * 100000;
        }
        int n4 = PBC.position(n - 1, this.L);
        int n5 = PBC.position(n + 1, this.L);
        return n3 -= (this.realSpace[n4] + this.realSpace[n5]) * this.well;
    }

    public void reset() {
        this.e = 0;
        this.n = 0;
        this.mcs = 0;
        this.steps = 0;
        this.nsum = 0.0;
        this.esum = 0.0;
        this.Esum = 0.0;
        this.Nsum = 0.0;
        this.accept = 0;
        this.p = new int[this.arraySize][this.arraySize];
    }

    public void averages() {
        this.Eave = this.Esum * 1.0 / (double)this.steps;
        this.Nave = this.Nsum * 1.0 / (double)this.steps;
        this.eave = this.esum / (double)this.steps;
        this.nave = this.nsum / (double)this.steps;
    }

    public void demonStep() {
        int n = 0;
        while (n < this.L * this.Lp) {
            int n2;
            int n3;
            int n4 = (int)(Math.random() * (double)this.L);
            if (this.s[n4][n3 = (int)(Math.random() * (double)this.Lp)] == 0) {
                n2 = this.pe(n4, 1);
                if (this.n > 0 && this.ke[n3] + n2 <= this.e) {
                    this.s[n4][n3] = 1;
                    int n5 = n4;
                    this.realSpace[n5] = this.realSpace[n5] + 1;
                    this.e -= this.ke[n3] + n2;
                    --this.n;
                    this.E += this.ke[n3] + n2;
                    ++this.N;
                    ++this.accept;
                }
            } else {
                n2 = this.pe(n4, 0);
                if (-n2 - this.ke[n3] <= this.e) {
                    this.s[n4][n3] = 0;
                    int n6 = n4;
                    this.realSpace[n6] = this.realSpace[n6] - 1;
                    this.e += this.ke[n3] + n2;
                    ++this.n;
                    this.E -= this.ke[n3] + n2;
                    --this.N;
                    ++this.accept;
                }
            }
            if (this.e < this.arraySize && this.n < this.arraySize && this.e >= 0) {
                int[] nArray = this.p[this.e];
                int n7 = this.n;
                nArray[n7] = nArray[n7] + 1;
            }
            ++this.steps;
            this.nsum += (double)this.n;
            this.esum += (double)this.e;
            this.Esum += (double)this.E;
            this.Nsum += (double)this.N;
            ++n;
        }
        ++this.mcs;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.s == null) {
            return;
        }
        int n = Math.abs(drawingPanel.xToPix(0.5) - drawingPanel.xToPix(0.0));
        int n2 = Math.abs(drawingPanel.yToPix(0.5) - drawingPanel.yToPix(0.0));
        graphics.setColor(Color.red);
        int n3 = 0;
        while (n3 < this.L) {
            int n4 = 0;
            while (n4 < this.Lp) {
                if (this.s[n3][n4] != 0) {
                    int n5 = drawingPanel.xToPix((double)n3 * 1.0) - n;
                    int n6 = drawingPanel.yToPix(n4 - this.pmax) - n2;
                    graphics.fillRect(n5, n6, 2 * n, 2 * n2);
                }
                ++n4;
            }
            ++n3;
        }
    }
}

