/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.demon.extra;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.demon.extra.EinsteinWRApp;
import org.opensourcephysics.stp.demon.extra.EinsteinWRAppControl;

public class EinsteinApp
extends AbstractSimulation {
    boolean logScale;
    int[] E;
    double[] histogram;
    int N;
    int systemEnergy;
    int demonEnergy;
    int mcs = 0;
    int demonEnergyAccumulator = 0;
    int acceptedMoves = 0;
    double systemEnergyAccumulator = 0.0;
    PlotFrame histogramFrame = new PlotFrame("Ed", "ln P(Ed)", "Demon Energy Distribution");
    JButton logButton;
    NumberFormat nf;

    public void doStep() {
        int n = 0;
        while (n < 10000 / this.N) {
            int n2 = 0;
            while (n2 < this.N) {
                int n3;
                int n4 = (int)(Math.random() * (double)this.N);
                int n5 = n3 = Math.random() < 0.5 ? 1 : -1;
                if (this.demonEnergy - n3 >= 0 && this.E[n4] + n3 >= 0) {
                    this.demonEnergy -= n3;
                    int n6 = n4;
                    this.E[n6] = this.E[n6] + n3;
                    this.systemEnergy += n3;
                    ++this.acceptedMoves;
                }
                this.systemEnergyAccumulator += (double)this.systemEnergy;
                this.demonEnergyAccumulator += this.demonEnergy;
                int n7 = this.demonEnergy;
                this.histogram[n7] = this.histogram[n7] + 1.0;
                ++n2;
            }
            this.histogramFrame.clearData();
            ++this.mcs;
            n2 = 0;
            while (n2 < this.systemEnergy + 1) {
                if (this.histogram[n2] > 0.0) {
                    this.histogramFrame.append(0, n2, Math.log(1.0 * this.histogram[n2] / (double)(this.mcs * this.N)));
                }
                ++n2;
            }
            ++n;
        }
    }

    public void stopRunning() {
        double d = this.mcs * this.N > 0 ? 1.0 / (double)(this.mcs * this.N) : 0.0;
        this.control.println("mcs = " + this.nf.format(this.mcs));
        this.control.println("<Ed> = " + this.nf.format((double)this.demonEnergyAccumulator * d));
        this.control.println("<E> = " + this.nf.format(this.systemEnergyAccumulator * d));
        this.control.println("acceptance ratio = " + this.nf.format((double)this.acceptedMoves * d));
        this.control.println();
    }

    public void initialize() {
        this.N = this.control.getInt("N");
        this.systemEnergy = this.control.getInt("system energy");
        this.histogram = new double[this.systemEnergy + 1];
        this.E = new int[this.N];
        int n = 0;
        while (n < this.N) {
            int n2 = n++;
            this.E[n2] = this.E[n2] + this.systemEnergy / this.N;
        }
        this.E[0] = this.E[0] + this.systemEnergy % this.N;
        this.demonEnergy = 0;
        this.mcs = 0;
        this.systemEnergyAccumulator = 0.0;
        this.demonEnergyAccumulator = 0;
        this.acceptedMoves = 0;
        this.control.clearMessages();
        this.histogramFrame.clearData();
    }

    public void reset() {
        this.control.setValue("N", 40);
        this.control.setValue("system energy", 120);
        this.control.clearMessages();
        this.histogramFrame.clearData();
        this.enableStepsPerDisplay(true);
        this.initialize();
    }

    public void zeroAverages() {
        this.mcs = 0;
        this.systemEnergyAccumulator = 0.0;
        this.demonEnergyAccumulator = 0;
        this.acceptedMoves = 0;
        this.histogramFrame.clearData();
        this.histogramFrame.repaint();
        this.control.clearMessages();
    }

    public EinsteinApp() {
        this.histogramFrame.setPreferredMinMax(0.0, 5.0, 0.0, 1.0);
        this.histogramFrame.setAutoscaleX(true);
        this.histogramFrame.setAutoscaleY(true);
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(3);
    }

    public void switchGUI() {
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = EinsteinApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(EinsteinApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                EinsteinWRApp einsteinWRApp = new EinsteinWRApp();
                EinsteinWRAppControl einsteinWRAppControl = new EinsteinWRAppControl(einsteinWRApp, (DrawingFrame)einsteinWRApp.histogramFrame, null);
                einsteinWRAppControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        einsteinWRAppControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                einsteinWRAppControl.loadXML(xMLControlElement, true);
                einsteinWRApp.customize();
                einsteinWRAppControl.resetSimulation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EinsteinApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.histogramFrame);
    }

    public static void main(String[] stringArray) {
        EinsteinApp einsteinApp = new EinsteinApp();
        SimulationControl simulationControl = SimulationControl.createApp(einsteinApp);
        simulationControl.addButton("zeroAverages", "Zero averages");
        einsteinApp.customize();
    }
}

