/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.demon.mdDemon;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.HistogramFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.demon.mdDemon.LJParticlesDemon;
import org.opensourcephysics.stp.demon.mdDemon.LJParticlesDemonAppControl;
import org.opensourcephysics.stp.demon.mdDemon.LJParticlesDemonLoader;
import org.opensourcephysics.stp.demon.mdDemon.LJParticlesDemonWRApp;

public class LJParticlesDemonApp
extends AbstractSimulation {
    LJParticlesDemon md = new LJParticlesDemon();
    PlotFrame pressureData = new PlotFrame("time", "PA/NkT", "Mean pressure");
    PlotFrame demonPlot = new PlotFrame("E", "ln (P(E))", "Demon energy distribution");
    PlotFrame temperatureData = new PlotFrame("time", "temperature", "Kinetic temperature");
    HistogramFrame xVelocityHistogram = new HistogramFrame("vx", "H(vx)", "Velocity histogram");
    DisplayFrame display = new DisplayFrame("x", "y", "Lennard-Jones system");
    DrawingPanel drawingPanel = this.display.getDrawingPanel();

    public void initialize() {
        if (this.control == null) {
            return;
        }
        String string = this.control.getString("number of particles");
        this.md.N = string.equals("64") ? 64 : (string.equals("144") ? 144 : 256);
        this.md.initialKineticEnergy = this.control.getDouble("initial kinetic energy per particle");
        this.md.dv = 2.0 * this.control.getDouble("maximum change in velocity component");
        this.md.L = this.control.getDouble("L");
        this.md.initialConfiguration = this.control.getString("initial configuration");
        this.md.dt = this.control.getDouble("\u0394t");
        this.md.initialize();
        this.drawingPanel.addDrawable(this.md);
        this.drawingPanel.setPreferredMinMax(0.0, this.md.L, 0.0, this.md.L);
        this.xVelocityHistogram.setBinWidth(2.0 * this.md.initialKineticEnergy / (double)this.md.N);
        this.xVelocityHistogram.setPreferredMinMaxY(0.0, 10.0);
        this.xVelocityHistogram.setAutoscaleY(true);
        this.demonPlot.setPreferredMinMaxX(0.0, 10.0);
        this.demonPlot.setPreferredMinMaxY(0.0, 10.0);
        this.demonPlot.setAutoscaleX(true);
        this.demonPlot.setAutoscaleY(true);
        this.temperatureData.setPreferredMinMaxX(0.0, 10.0);
        this.temperatureData.setPreferredMinMaxY(0.0, 10.0);
        this.temperatureData.setAutoscaleX(true);
        this.temperatureData.setAutoscaleY(true);
        this.pressureData.setAutoscaleX(true);
        this.pressureData.setAutoscaleY(true);
        this.pressureData.limitAutoscaleX(0.0, 10.0);
        this.pressureData.limitAutoscaleY(0.0, 10.0);
    }

    public void doStep() {
        this.md.step(this.xVelocityHistogram);
        this.pressureData.append(0, this.md.t, this.md.getMeanPressure());
        this.temperatureData.append(0, this.md.t, this.md.getMeanTemperature());
        if (this.md.steps % 10 == 1) {
            this.demonPlot.clearData();
            int n = 0;
            while (n < 100) {
                if (this.md.demonP[n] > 0.0) {
                    this.demonPlot.append(0, n, Math.log(this.md.demonP[n]));
                }
                ++n;
            }
        }
    }

    public void stopRunning() {
        if (this.control == null || this.md == null) {
            return;
        }
        this.control.println("Density = " + this.decimalFormat.format(this.md.rho));
        this.control.println("Number of time steps = " + this.md.steps);
        this.control.println("<Kinetic Temperature>= " + this.decimalFormat.format(this.md.getMeanTemperature()));
        this.control.println("Mean Demon Energy = " + this.decimalFormat.format(this.md.demonEnergyAccumulator / (double)this.md.steps));
        this.demonPlot.clearData();
        int n = 0;
        while (n < 100) {
            if (this.md.demonP[n] > 0.0) {
                this.demonPlot.append(0, n, Math.log(this.md.demonP[n]));
            }
            ++n;
        }
    }

    public void startRunning() {
        this.md.dt = this.control.getDouble("\u0394t");
        double d = this.control.getDouble("L");
        if (d != this.md.L) {
            this.md.L = d;
            this.md.computeAcceleration();
            this.drawingPanel.setPreferredMinMax(0.0, d, 0.0, d);
            this.resetData();
        }
    }

    public void reset() {
        OSPCombo oSPCombo = new OSPCombo(new String[]{"64", "144", "256"}, 0);
        this.control.setValue("number of particles", oSPCombo);
        this.control.setAdjustableValue("L", 30);
        this.control.setValue("initial kinetic energy per particle", 1.0);
        this.control.setAdjustableValue("\u0394t", 0.01);
        OSPCombo oSPCombo2 = new OSPCombo(new String[]{"rectangular", "triangular"}, 0);
        this.control.setValue("initial configuration", oSPCombo2);
        this.control.setValue("maximum change in velocity component", 0.2);
        this.enableStepsPerDisplay(true);
        super.setStepsPerDisplay(10);
        this.drawingPanel.setSquareAspect(true);
        this.delayTime = 0;
        this.resetData();
    }

    public void resetData() {
        this.md.resetAverages();
        GUIUtils.clearDrawingFrameData(false);
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = LJParticlesDemonApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(LJParticlesDemonApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                LJParticlesDemonWRApp lJParticlesDemonWRApp = new LJParticlesDemonWRApp();
                LJParticlesDemonAppControl lJParticlesDemonAppControl = new LJParticlesDemonAppControl(lJParticlesDemonWRApp, (DrawingFrame)lJParticlesDemonWRApp.display, null);
                lJParticlesDemonAppControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        lJParticlesDemonAppControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                lJParticlesDemonAppControl.loadXML(xMLControlElement, true);
                lJParticlesDemonWRApp.customize();
                lJParticlesDemonAppControl.resetSimulation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LJParticlesDemonApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.display);
        this.addChildFrame(this.pressureData);
        this.addChildFrame(this.demonPlot);
        this.addChildFrame(this.temperatureData);
        this.addChildFrame(this.xVelocityHistogram);
    }

    public static XML.ObjectLoader getLoader() {
        return new LJParticlesDemonLoader();
    }

    public static void main(String[] stringArray) {
        LJParticlesDemonApp lJParticlesDemonApp = new LJParticlesDemonApp();
        SimulationControl simulationControl = SimulationControl.createApp(lJParticlesDemonApp);
        simulationControl.addButton("resetData", "Zero Averages");
        lJParticlesDemonApp.customize();
    }
}

