/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.demon.mdDemon;

import java.awt.event.WindowListener;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.ejs.control.EjsSimulationControl;
import org.opensourcephysics.stp.demon.mdDemon.LJParticlesDemonApp;
import org.opensourcephysics.stp.demon.mdDemon.LJParticlesDemonAppControl;

public class LJParticlesDemonWRApp
extends LJParticlesDemonApp {
    public LJParticlesDemonWRApp() {
        this.pressureData.setKeepHidden(true);
        this.pressureData.dispose();
        this.xVelocityHistogram.setKeepHidden(true);
        this.xVelocityHistogram.dispose();
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = LJParticlesDemonWRApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(LJParticlesDemonWRApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                LJParticlesDemonApp lJParticlesDemonApp = new LJParticlesDemonApp();
                SimulationControl simulationControl = SimulationControl.createApp(lJParticlesDemonApp);
                simulationControl.setDefaultCloseOperation(n);
                simulationControl.addButton("resetData", "Reset Data");
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        simulationControl.addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                simulationControl.loadXML(xMLControlElement, true);
                simulationControl.setValue("model", null);
                lJParticlesDemonApp.customize();
                lJParticlesDemonApp.initialize();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void doStep() {
        super.doStep();
        this.stopRunning();
    }

    public void stopRunning() {
        if (this.control == null || this.md == null) {
            return;
        }
        ((EjsSimulationControl)this.control).getControl("TNumber").setProperty("value", ControlUtils.f4(this.md.getMeanTemperature()));
        ((EjsSimulationControl)this.control).getControl("edNumber").setProperty("value", ControlUtils.f4(this.md.getMeanEnergy()));
        this.demonPlot.clearData();
        int n = 0;
        while (n < 100) {
            if (this.md.demonP != null && this.md.demonP[n] > 0.0) {
                this.demonPlot.append(0, n, Math.log(this.md.demonP[n]));
            }
            ++n;
        }
    }

    public void setParameter() {
        this.resetData();
        this.initialize();
        this.stopRunning();
        GUIUtils.repaintOSPFrames();
    }

    public static void main(String[] stringArray) {
        LJParticlesDemonWRApp lJParticlesDemonWRApp = new LJParticlesDemonWRApp();
        new LJParticlesDemonAppControl(lJParticlesDemonWRApp, (DrawingFrame)lJParticlesDemonWRApp.display, stringArray);
        lJParticlesDemonWRApp.customize();
    }
}

