/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.diffusion;

import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.diffusion.LatticeGas;

public class LatticeGasApp
extends AbstractSimulation {
    int L;
    double L_2;
    int N;
    final int OCCUPIED = 1;
    final int EMPTY = 0;
    double t;
    LatticeGas latticegas;
    PlotFrame plotFrame = new PlotFrame("time", "<R2>", "Mean squared displacement");
    DisplayFrame displayFrame = new DisplayFrame("Lattice Display");

    public LatticeGasApp() {
        this.latticegas = new LatticeGas();
        this.displayFrame.setSquareAspect(true);
        this.displayFrame.addDrawable(this.latticegas);
        this.plotFrame.setPreferredMinMaxX(0.0, 10.0);
        this.plotFrame.setAutoscaleX(true);
        this.plotFrame.setPreferredMinMaxY(0.0, 10.0);
        this.plotFrame.setAutoscaleY(true);
    }

    public void initialize() {
        this.L = this.control.getInt("L");
        this.N = this.control.getInt("N");
        this.latticegas.initialize(this.L, this.N);
        if (this.N > this.L * this.L) {
            this.control.println("N must be less than L*L");
            return;
        }
        this.t = 0.0;
        this.latticegas.fillLattice();
        this.displayFrame.setPreferredMinMax(-1.0, this.L + 1, this.L + 1, -1.0);
    }

    public void reset() {
        this.control.setValue("L", 40);
        this.control.setValue("N", 500);
        this.plotFrame.render();
        this.displayFrame.render();
        this.displayFrame.clearData();
        this.enableStepsPerDisplay(true);
    }

    protected void doStep() {
        this.latticegas.move();
        double d = this.latticegas.computeR2Bar();
        this.t += 1.0;
        this.plotFrame.append(0, this.t, d);
        this.plotFrame.render();
        this.displayFrame.render();
    }

    public static void main(String[] stringArray) {
        SimulationControl.createApp(new LatticeGasApp(), stringArray);
    }
}

