/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.einsteinsolid;

import java.text.NumberFormat;
import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.frames.TableFrame;

public class EinsteinSolid
extends AbstractCalculation {
    int Ea;
    int Eb;
    int Na;
    int Nb;
    PlotFrame plotFrame = new PlotFrame("Ea", "P(Ea)", "Probability");
    TableFrame tableFrame = new TableFrame("Table");
    NumberFormat numberFormat = NumberFormat.getInstance();

    public EinsteinSolid() {
        this.numberFormat.setMaximumFractionDigits(4);
        this.plotFrame.setXYColumnNames(0, "E_a", "P");
        this.tableFrame.setColumnNames(0, "E_a");
        this.tableFrame.setColumnNames(1, "P");
    }

    public double binom(int n, int n2) {
        double d = 1.0;
        int n3 = n;
        int n4 = n2;
        while (n3 >= n - n2 + 1 && n4 >= 1) {
            d *= (double)n3;
            d /= (double)n4;
            --n4;
            --n3;
        }
        return d;
    }

    public void addPoints() {
        int n = this.Ea + this.Eb;
        double[] dArray = new double[n + 1];
        double[] dArray2 = new double[n + 1];
        double d = 0.0;
        int n2 = 0;
        while (n2 <= n) {
            dArray[n2] = this.binom(n2 + this.Na - 1, n2);
            dArray2[n2] = this.binom(n - n2 + this.Nb - 1, n - n2);
            d += dArray[n2] * dArray2[n2];
            ++n2;
        }
        this.plotFrame.setPreferredMinMaxX(0.0, n);
        this.plotFrame.repaint();
        double d2 = 0.0;
        int n3 = -1;
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = 0;
        while (n4 <= n) {
            double d5 = dArray[n4] * dArray2[n4] / d;
            if (n4 < this.Ea) {
                d4 += d5;
            }
            if (d5 > d2) {
                d2 = d5;
                n3 = n4;
            }
            d3 += (double)n4 * d5;
            this.plotFrame.append(0, n4, d5);
            Object[] objectArray = new String[]{this.numberFormat.format(n4), this.numberFormat.format(d5)};
            this.tableFrame.appendRow(objectArray);
            ++n4;
        }
        this.control.println("Most probable Ea = " + this.numberFormat.format(n3));
        this.control.println("Mean Ea = " + this.numberFormat.format(d3));
        this.control.println("Hot to cold probability = " + this.numberFormat.format(d4));
    }

    public void reset() {
        this.plotFrame.clearData();
        this.tableFrame.clearData();
        this.control.clearMessages();
        this.tableFrame.refreshTable();
        this.plotFrame.repaint();
        this.Ea = 10;
        this.Eb = 2;
        this.Na = 4;
        this.Nb = 4;
        this.control.setValue("Ea", this.Ea);
        this.control.setValue("Eb", this.Eb);
        this.control.setValue("Na", this.Na);
        this.control.setValue("Nb", this.Nb);
    }

    public void calculate() {
        this.Ea = this.control.getInt("Ea");
        this.Eb = this.control.getInt("Eb");
        this.Na = this.control.getInt("Na");
        this.Nb = this.control.getInt("Nb");
        this.addPoints();
        this.tableFrame.refreshTable();
    }

    public static void main(String[] stringArray) {
        CalculationControl.createApp(new EinsteinSolid());
    }
}

