/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.einsteinsolid;

import java.awt.event.WindowListener;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.ejs.control.EjsCalculationControl;
import org.opensourcephysics.stp.einsteinsolid.EinsteinSolidApp;
import org.opensourcephysics.stp.einsteinsolid.EinsteinSolidControl;

public class EinsteinSolidWRApp
extends EinsteinSolidApp {
    public void switchGUI() {
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = EinsteinSolidWRApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(EinsteinSolidWRApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                EinsteinSolidApp einsteinSolidApp = new EinsteinSolidApp();
                CalculationControl calculationControl = CalculationControl.createApp(einsteinSolidApp);
                calculationControl.setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        calculationControl.addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                calculationControl.loadXML(xMLControlElement, true);
                einsteinSolidApp.customize();
                einsteinSolidApp.resetCalculation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void setParameter() {
        this.calculate();
        GUIUtils.repaintOSPFrames();
    }

    void outputResult(double d, double d2, double d3) {
        if (this.control == null) {
            return;
        }
        ((EjsCalculationControl)this.control).getControl("omegaA").setProperty("value", this.numberFormat.format(this.binom(this.Ea + this.Na - 1, this.Ea)));
        ((EjsCalculationControl)this.control).getControl("omegaB").setProperty("value", this.numberFormat.format(this.binom(this.Eb + this.Nb - 1, this.Eb)));
        ((EjsCalculationControl)this.control).getControl("pAB").setProperty("value", this.numberFormat.format(d3));
    }

    public static void main(String[] stringArray) {
        EinsteinSolidWRApp einsteinSolidWRApp = new EinsteinSolidWRApp();
        new EinsteinSolidControl(einsteinSolidWRApp, einsteinSolidWRApp.plotFrame, stringArray);
        einsteinSolidWRApp.customize();
        einsteinSolidWRApp.calculate();
        GUIUtils.repaintOSPFrames();
    }
}

