/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.einsteinsolid;

import java.awt.event.WindowListener;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.ejs.control.EjsSimulationControl;
import org.opensourcephysics.stp.einsteinsolid.EinsteinsolidMCApp;
import org.opensourcephysics.stp.einsteinsolid.EinsteinsolidMCControl;

public class EinsteinsolidMCWRApp
extends EinsteinsolidMCApp {
    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = EinsteinsolidMCWRApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(EinsteinsolidMCWRApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                EinsteinsolidMCApp einsteinsolidMCApp = new EinsteinsolidMCApp();
                SimulationControl simulationControl = SimulationControl.createApp(einsteinsolidMCApp);
                simulationControl.setDefaultCloseOperation(n);
                simulationControl.addButton("acceptResults", "Accept E and C");
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        simulationControl.addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                simulationControl.loadXML(xMLControlElement, true);
                einsteinsolidMCApp.customize();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void doStep() {
        super.doStep();
        this.stopRunning();
    }

    public void stopRunning() {
        if (this.control == null) {
            return;
        }
        ((EjsSimulationControl)this.control).getControl("meanE").setProperty("value", this.nf.format(this.meanE()));
        ((EjsSimulationControl)this.control).getControl("C").setProperty("value", this.nf.format(this.heatCapacity()));
    }

    public static void main(String[] stringArray) {
        EinsteinsolidMCWRApp einsteinsolidMCWRApp = new EinsteinsolidMCWRApp();
        new EinsteinsolidMCControl(einsteinsolidMCWRApp, (DrawingFrame)einsteinsolidMCWRApp.plotFrame, stringArray);
        einsteinsolidMCWRApp.customize();
    }
}

