/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.entropy;

import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.frames.PlotFrame;

public class EinsteinSolidChemicalPotentialApp
extends AbstractCalculation {
    int Ea;
    int Eb;
    int Na;
    int Nb;
    int E;
    int N;
    PlotFrame plotFrame = new PlotFrame("Na", "Total Number of States", "");

    public EinsteinSolidChemicalPotentialApp() {
        this.plotFrame.setXYColumnNames(0, "N_a", "omegaA");
        this.plotFrame.setXYColumnNames(1, "N_a", "log omegaA");
        this.plotFrame.setXYColumnNames(2, "N_a", "muA/kT");
        this.plotFrame.setXYColumnNames(3, "N_a", "Nb");
        this.plotFrame.setXYColumnNames(4, "N_a", "omegaB");
        this.plotFrame.setXYColumnNames(5, "N_a", "log omegaA");
        this.plotFrame.setXYColumnNames(6, "N_a", "muB/kT");
        this.plotFrame.setXYColumnNames(7, "N_a", "# states");
        this.plotFrame.showDataTable(true);
        int n = 0;
        while (n < 8) {
            if (n != 7) {
                this.plotFrame.setMarkerSize(n, 0);
            }
            ++n;
        }
        this.plotFrame.setMarkerSize(7, 2);
    }

    public double binom(int n, int n2) {
        double d = 1.0;
        int n3 = n;
        int n4 = n2;
        while (n3 >= n - n2 + 1 && n4 >= 1) {
            d *= (double)n3;
            d /= (double)n4;
            --n4;
            --n3;
        }
        return d;
    }

    public void addPoints() {
        int n = 0;
        int n2 = 1;
        while (n2 < this.N) {
            double d;
            int n3 = this.N - n2;
            double d2 = this.binom(this.Ea + n2 - 1, this.Ea);
            double d3 = Math.log(d2);
            double d4 = this.binom(this.Eb + n3 - 1, this.Eb);
            double d5 = Math.log(d4);
            double d6 = d2 * d4;
            this.plotFrame.append(0, n2, d2);
            this.plotFrame.append(1, n2, d3);
            if (n2 > 1 && n2 < this.N - 1) {
                d = -0.5 * (Math.log(this.binom(this.Ea + n2, this.Ea)) - Math.log(this.binom(this.Ea + n2 - 2, this.Ea)));
                this.plotFrame.append(2, n2, d);
            } else {
                this.plotFrame.append(2, n2, 0.0);
            }
            this.plotFrame.append(3, n2, n3);
            this.plotFrame.append(4, n2, d4);
            this.plotFrame.append(5, n2, d5);
            if (n3 > 1 && n3 < this.N - 1) {
                d = -0.5 * (Math.log(this.binom(this.Eb + n3, this.Eb)) - Math.log(this.binom(this.Eb + n3 - 2, this.Eb)));
                this.plotFrame.append(6, n2, d);
            } else {
                this.plotFrame.append(6, n2, 0.0);
            }
            this.plotFrame.append(7, n2, d6);
            n = (int)((double)n + d6);
            ++n2;
        }
        System.out.println("total number of states = " + n);
    }

    public void resetCalculation() {
        this.plotFrame.clearData();
        this.Ea = 8;
        this.Eb = 5;
        this.N = 10;
        this.control.setValue("Ea", this.Ea);
        this.control.setValue("Eb", this.Eb);
        this.control.setValue("N", this.N);
        this.control.clearMessages();
    }

    public void calculate() {
        this.plotFrame.clearData();
        this.Ea = this.control.getInt("Ea");
        this.Eb = this.control.getInt("Eb");
        this.N = this.control.getInt("N");
        this.E = this.Ea + this.Eb;
        this.addPoints();
    }

    public static void main(String[] stringArray) {
        CalculationControl.createApp(new EinsteinSolidChemicalPotentialApp(), stringArray);
    }
}

