/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.entropy;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.util.MyMath;

public class EntropyApp
extends AbstractCalculation
implements InteractiveMouseHandler {
    boolean showTable = false;
    int E;
    int Na;
    int Nb;
    int cid = 0;
    static final int MAXIMUM_NUMERATOR = 20;
    PlotFrame plotFrame = new PlotFrame("E_a", "Entropy", "Entropy");

    public EntropyApp() {
        this.plotFrame.setMarkerColor(0, Color.red);
        this.plotFrame.setMarkerColor(1, Color.blue);
        this.plotFrame.setMarkerColor(2, Color.GREEN);
    }

    public void addPoints() {
        int n = 0;
        while (n <= this.E) {
            int n2 = n;
            int n3 = this.E - n2;
            double d = 0.0;
            double d2 = 0.0;
            d = n2 + this.Na - 1 > 20 ? MyMath.stirling(n2 + this.Na - 1) - MyMath.stirling(n2) - MyMath.stirling(this.Na - 1) : Math.log(EntropyApp.factorial(n2 + this.Na - 1, n2, this.Na - 1));
            d2 = n3 + this.Nb - 1 > 20 ? MyMath.stirling(n3 + this.Nb - 1) - MyMath.stirling(n3) - MyMath.stirling(this.Nb - 1) : Math.log(EntropyApp.factorial(n3 + this.Nb - 1, n3, this.Nb - 1));
            double d3 = d + d2;
            this.plotFrame.append(0, n2, d3);
            this.plotFrame.append(1, n2, d);
            this.plotFrame.append(2, n2, d2);
            ++n;
        }
        this.plotFrame.repaint();
    }

    public void getStotal() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(5);
        Dataset dataset = this.plotFrame.getDataset(0);
        double d = 0.0;
        double d2 = dataset.getYMax();
        int n = 0;
        while (n < dataset.getRowCount()) {
            d += Math.exp(dataset.getValidYPoints()[n] - d2);
            ++n;
        }
        this.control.clearMessages();
        this.control.println("Relative error due to keeping only the largest term\n in the total entropy: " + numberFormat.format(Math.log(d) / d2));
    }

    public static double factorial(int n, int n2, int n3) {
        if (n < Math.max(n2, n3)) {
            throw new IllegalArgumentException("A must be greater than Math.max(B,C)");
        }
        int n4 = 0;
        int n5 = 0;
        if (n2 > n3) {
            n4 = n2;
            n5 = n3;
        } else {
            n4 = n3;
            n5 = n2;
        }
        double d = n;
        int n6 = n - 1;
        while (n6 > n4) {
            d *= (double)n6;
            --n6;
        }
        return d / (double)MyMath.factorial(n5);
    }

    public void resetCalculation() {
        this.control.clearMessages();
        this.plotFrame.clearData();
        this.plotFrame.repaint();
        this.E = 200;
        this.Na = 50;
        this.Nb = 50;
        this.control.setValue("E", this.E);
        this.control.setValue("Na", this.Na);
        this.control.setValue("Nb", this.Nb);
        this.control.println("Blue: S(E_a)");
        this.control.println("Green: S(E_b)");
        this.control.println("Red: S_total(E_a)");
        this.plotFrame.setInteractiveMouseHandler(this);
    }

    public void handleMouseAction(InteractivePanel interactivePanel, MouseEvent mouseEvent) {
        if (interactivePanel.getMouseAction() == 1) {
            double d = this.MouseOnCurve(interactivePanel.getMouseX(), interactivePanel.getMouseY());
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(3);
            if (d != Double.MIN_VALUE) {
                String string = "";
                switch (this.cid) {
                    case 0: {
                        string = "T = ";
                        break;
                    }
                    case 1: {
                        string = "Ta = ";
                        this.plotFrame.setMessage(String.valueOf(string) + numberFormat.format(d));
                        break;
                    }
                    case 2: {
                        string = "Tb = ";
                        this.plotFrame.setMessage(String.valueOf(string) + numberFormat.format(d));
                    }
                }
            }
        }
        if (interactivePanel.getMouseAction() == 2) {
            this.plotFrame.setMessage("");
        }
    }

    public double MouseOnCurve(double d, double d2) {
        int n = 0;
        while (n < 3) {
            Dataset dataset = this.plotFrame.getDataset(n);
            double[][] dArray = dataset.getPoints();
            int n2 = 0;
            while (n2 < dArray.length) {
                double d3 = dArray[n2][0];
                double d4 = d3 - d;
                double d5 = dArray[n2][1];
                double d6 = d5 - d2;
                if (d4 * d4 + d6 * d6 < 10.0 && n2 > 0) {
                    double d7 = dArray[n2][1] - dArray[n2 - 1][1];
                    d7 /= dArray[n2][0] - dArray[n2 - 1][0];
                    this.cid = n;
                    if (n == 2) {
                        d7 = -d7;
                    }
                    return 1.0 / d7;
                }
                ++n2;
            }
            ++n;
        }
        return Double.MIN_VALUE;
    }

    public void calculate() {
        this.E = this.control.getInt("E");
        this.Na = this.control.getInt("Na");
        this.Nb = this.control.getInt("Nb");
        this.addPoints();
        this.getStotal();
    }

    public static void main(String[] stringArray) {
        CalculationControl.createApp(new EntropyApp(), stringArray);
    }
}

