/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.entropy;

import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.frames.TableFrame;
import org.opensourcephysics.stp.entropy.EntropyApp;
import org.opensourcephysics.stp.util.MyMath;

public class EntropyApp2
extends AbstractCalculation {
    boolean showTable = false;
    int E;
    int Na;
    int Nb;
    static final int MAXIMUM_NUMERATOR = 20;
    TableFrame tableFrame = new TableFrame("table");
    PlotFrame plotFrame = new PlotFrame("E", "S(E)", "Entropy");

    public EntropyApp2() {
        this.tableFrame.setColumnNames(0, "S");
        this.tableFrame.setColumnNames(0, "Ln of omega_a");
        this.tableFrame.setColumnNames(0, "Ln of omega_b");
    }

    public void addPoints() {
        int n = 0;
        while (n <= this.E) {
            int n2 = n;
            int n3 = this.E - n2;
            double d = 0.0;
            double d2 = 0.0;
            d = n2 + this.Na - 1 > 20 ? MyMath.stirling(n2 + this.Na - 1) - MyMath.stirling(n2) - MyMath.stirling(this.Na - 1) : Math.log(EntropyApp.factorial(n2 + this.Na - 1, n2, this.Na - 1));
            d2 = n3 + this.Nb - 1 > 20 ? MyMath.stirling(n3 + this.Nb - 1) - MyMath.stirling(n3) - MyMath.stirling(this.Nb - 1) : Math.log(EntropyApp.factorial(n3 + this.Nb - 1, n3, this.Nb - 1));
            double d3 = d + d2;
            this.tableFrame.appendRow(new double[]{d3, d, d2});
            this.plotFrame.append(0, n2, d3);
            this.plotFrame.append(0, n2, d);
            this.plotFrame.append(0, n2, d2);
            ++n;
        }
        this.plotFrame.setPreferredMinMaxX(0.0, this.E);
        this.plotFrame.repaint();
    }

    public static int factorial(int n, int n2, int n3) {
        if (n < Math.max(n2, n3)) {
            throw new IllegalArgumentException("A must be greater than Math.max(B,C)");
        }
        int n4 = 0;
        int n5 = 0;
        if (n2 > n3) {
            n4 = n2;
            n5 = n3;
        } else {
            n4 = n3;
            n5 = n2;
        }
        int n6 = n;
        int n7 = n - 1;
        while (n7 > n4) {
            n6 *= n7;
            --n7;
        }
        return n6 / MyMath.factorial(n5);
    }

    public void resetCalculation() {
        this.plotFrame.clearData();
        this.plotFrame.repaint();
        this.tableFrame.clearData();
        this.tableFrame.refreshTable();
        this.E = 12;
        this.Na = 4;
        this.Nb = 8;
        this.control.setValue("E", this.E);
        this.control.setValue("Na", this.Na);
        this.control.setValue("Nb", this.Nb);
    }

    public void calculate() {
        this.E = this.control.getInt("E");
        this.Na = this.control.getInt("Na");
        this.Nb = this.control.getInt("Nb");
        this.addPoints();
        this.tableFrame.refreshTable();
    }

    public static void main(String[] stringArray) {
        CalculationControl.createApp(new EntropyApp2(), stringArray);
    }
}

