/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.estimation;

import java.awt.event.WindowListener;
import java.text.DecimalFormat;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.ejs.control.EjsCalculationControl;
import org.opensourcephysics.stp.estimation.MonteCarloEstimationApp;
import org.opensourcephysics.stp.estimation.MonteCarloEstimationControl;

public class MonteCarloEstimationWRApp
extends MonteCarloEstimationApp {
    DecimalFormat f10 = new DecimalFormat("#0.000000000000000");

    public void switchGUI() {
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = MonteCarloEstimationWRApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(MonteCarloEstimationWRApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                MonteCarloEstimationApp monteCarloEstimationApp = new MonteCarloEstimationApp();
                CalculationControl calculationControl = CalculationControl.createApp(monteCarloEstimationApp);
                calculationControl.setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        calculationControl.addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                calculationControl.loadXML(xMLControlElement, true);
                calculationControl.setValue("model", null);
                monteCarloEstimationApp.customize();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                calculationControl.clearMessages();
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void calculate() {
        this.control.setValue("seed", String.valueOf(System.currentTimeMillis()));
        this.seed = Long.parseLong(this.control.getString("seed"));
        super.calculate();
    }

    public void displayArea(long l) {
        if (this.control == null) {
            return;
        }
        double d = (double)l * (this.b - this.a) * this.ymax / (double)this.n;
        ((EjsCalculationControl)this.control).getControl("errorNumber").setProperty("value", this.f10.format(d));
    }

    public static void main(String[] stringArray) {
        MonteCarloEstimationWRApp monteCarloEstimationWRApp = new MonteCarloEstimationWRApp();
        new MonteCarloEstimationControl(monteCarloEstimationWRApp, (DrawingFrame)monteCarloEstimationWRApp.plotFrame, stringArray);
        monteCarloEstimationWRApp.customize();
    }
}

