/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.fpu;

import java.awt.Color;
import java.text.NumberFormat;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.fpu.FPU;

public class FPUApp
extends AbstractSimulation {
    FPU fpu = new FPU();
    DisplayFrame displayFrame = new DisplayFrame("Displacements");
    PlotFrame energyFrame = new PlotFrame("time", "Energy", "Energy in different modes");
    PlotFrame metricFrame = new PlotFrame("time", "Inverse metric", "Metric versus time");
    int kmode;
    double[] EkAccum = new double[4];
    int nAccum = 0;
    NumberFormat numberFormatFourDigits = NumberFormat.getInstance();

    public void doStep() {
        int n = 0;
        while (n < 100) {
            this.fpu.doStep();
            ++n;
        }
        this.fpu.getEnergy();
        if (this.kmode != 0) {
            n = 0;
            int n2 = this.kmode - 1;
            while (n2 < this.kmode + 2 + 1) {
                if (n2 >= 0 && n2 < this.fpu.N) {
                    this.energyFrame.append(n, this.fpu.t, this.fpu.Ek[n2]);
                    int n3 = n;
                    this.EkAccum[n3] = this.EkAccum[n3] + this.fpu.Ek[n2];
                    ++this.nAccum;
                }
                ++n;
                ++n2;
            }
        } else {
            this.energyFrame.append(1, this.fpu.t, this.fpu.Ek[1]);
        }
        this.metricFrame.append(0, this.fpu.t, 1.0 / this.fpu.peMetric.metric);
        if ((int)this.fpu.t % 100000 == 0) {
            this.control.println("t = " + this.fpu.t);
            this.control.println("E/N = " + this.fpu.E / (double)this.fpu.N);
            this.control.println("KE/N = " + this.fpu.KE / (double)this.fpu.N);
            this.control.println();
        }
    }

    public void initialize() {
        int n = 0;
        while (n < 4) {
            this.EkAccum[n] = 0.0;
            ++n;
        }
        this.nAccum = 0;
        int n2 = this.control.getInt("N");
        double d = 0.25;
        double d2 = this.control.getDouble("b");
        this.kmode = this.control.getInt("mode");
        double d3 = this.control.getDouble("\u0394t");
        double d4 = 0.1;
        if (this.kmode < 1) {
            this.control.println("Initial mode must be positive integer");
            return;
        }
        this.fpu.initialize(n2, this.kmode, d, d2, d3, d4);
        this.displayFrame.addDrawable(this.fpu);
        this.control.clearMessages();
        this.displayFrame.setPreferredMinMax(-0.1 * this.fpu.L, 1.1 * this.fpu.L, -0.2 * this.fpu.L, 0.2 * this.fpu.L);
        this.energyFrame.setMarkerColor(1, Color.green);
        this.energyFrame.setMarkerColor(2, Color.blue);
        this.energyFrame.setMarkerColor(3, Color.red);
        this.energyFrame.setPreferredMinMax(0.0, 10.0, 0.0, 10.0);
        this.metricFrame.setPreferredMinMax(0.0, 10.0, 0.0, 10.0);
        this.energyFrame.setAutoscaleX(true);
        this.energyFrame.setAutoscaleY(true);
        this.metricFrame.setAutoscaleX(true);
        this.metricFrame.setAutoscaleY(true);
        this.delayTime = 0;
    }

    public void stop() {
        int n = this.kmode - 1;
        if (n > 0 && n < this.fpu.N) {
            this.control.println("Average energy in mode " + n + " = " + this.numberFormatFourDigits.format(this.EkAccum[1] / (double)this.nAccum));
        }
        if ((n = this.kmode) > 0 && n < this.fpu.N) {
            this.control.println("Average energy in mode " + n + " = " + this.numberFormatFourDigits.format(this.EkAccum[2] / (double)this.nAccum));
        }
        if ((n = this.kmode + 1) > 0 && n < this.fpu.N) {
            this.control.println("Average energy in mode " + n + " = " + this.numberFormatFourDigits.format(this.EkAccum[3] / (double)this.nAccum));
        }
    }

    public void reset() {
        this.control.setValue("N", "18");
        this.control.setValue("mode", 1);
        this.control.setValue("b", 0.25);
        this.control.setValue("\u0394t", 0.05);
        this.delayTime = 0;
        this.energyFrame.clearData();
        this.metricFrame.clearData();
        this.fpu.t = 0.0;
        this.enableStepsPerDisplay(true);
    }

    public void resetMetric() {
        this.metricFrame.clearData();
        this.energyFrame.clearData();
        this.fpu.resetMetric();
        int n = 0;
        while (n < 4) {
            this.EkAccum[n] = 0.0;
            ++n;
        }
        this.nAccum = 0;
    }

    public FPUApp() {
        this.numberFormatFourDigits.setMinimumFractionDigits(4);
        this.metricFrame.setMarkerColor(0, Color.RED);
    }

    public static void main(String[] stringArray) {
        SimulationControl simulationControl = SimulationControl.createApp(new FPUApp());
        simulationControl.addButton("resetMetric", "Zero averages");
    }
}

