/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.fpu;

public class Metric {
    int numOfPoints;
    double[] data;
    double[] data_av;
    int counter;
    double metric;
    double m0 = 1.0;

    public Metric(int n) {
        this.numOfPoints = n;
        this.data = new double[n];
        this.data_av = new double[n];
        int n2 = 1;
        while (n2 < n) {
            this.data_av[n2] = 0.0;
            this.data[n2] = 0.0;
            ++n2;
        }
        this.counter = 0;
    }

    public double append(double[] dArray) {
        ++this.counter;
        int n = 1;
        while (n < dArray.length) {
            int n2 = n;
            this.data[n2] = this.data[n2] + dArray[n];
            this.data_av[n] = this.data[n] / (double)this.counter;
            ++n;
        }
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 1;
        while (n3 < dArray.length) {
            d += this.data_av[n3];
            d2 += this.data_av[n3] * this.data_av[n3];
            ++n3;
        }
        this.metric = (d2 /= (double)(dArray.length - 1)) - (d /= (double)(dArray.length - 1)) * d;
        this.metric /= (double)dArray.length;
        this.metric /= this.m0;
        return this.metric;
    }

    public void setM0(double d) {
        this.m0 = d;
    }

    public void zeroData() {
        int n = 0;
        while (n < this.numOfPoints) {
            this.data_av[n] = 0.0;
            this.data[n] = 0.0;
            ++n;
        }
    }

    public void reset() {
        this.zeroData();
        this.counter = 0;
        this.m0 = 1.0;
    }
}

