/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.harddisk;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Random;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Histogram;

public class HD
implements Drawable {
    double[] velocityX;
    double[] velocityY;
    double[] positionX;
    double[] positionY;
    double[] collisionTime;
    double[] timeOfLastCollision;
    double mfpAccumulator;
    int[] partner;
    int N;
    double Lx;
    double Ly;
    public String initialConfiguration;
    static double TIME_BIG = 1000000.0;
    int minimumCollisionI;
    int minimumCollisionJ;
    double virial;
    double virialAccumulator;
    double time;
    double tenCollisionTime;
    double tenCollisionVirial;
    double velocityMax;
    double area = 1.0;
    double totalKineticEnergyAccumulator;
    double totalKineticEnergySquaredAccumulator;
    int collisions;
    double rho;
    double radius = 0.5;
    Random random;
    int steps;
    Histogram velocityHistogram = new Histogram();

    public HD() {
        this.random = new Random(System.currentTimeMillis());
        this.setLx(10.0);
        this.setLy(10.0);
        this.setNumberOfDisks(10);
        this.setVelocityMax(2.0);
    }

    public double getTime() {
        return this.time;
    }

    public int getSteps() {
        return this.steps;
    }

    public double getCollisions() {
        return this.collisions;
    }

    public double getMeanPressure() {
        double d = this.virialAccumulator / this.time;
        return 1.0 + 0.5 * d / ((double)this.N * this.getMeanTemperature());
    }

    public double getInstantanousPressure() {
        return 1.0 + 0.5 * this.tenCollisionVirial / (this.tenCollisionTime * this.getInstaneousKineticEnergy());
    }

    public double getHeatCapacity() {
        double d = this.getMeanTemperature();
        double d2 = this.totalKineticEnergySquaredAccumulator / (double)this.steps;
        double d3 = d2 - d * d;
        double d4 = d3 / ((double)this.N * d * d) - 1.0;
        return (double)this.N / d4;
    }

    public void initialize() {
        if (this.initialConfiguration.equals("crystal")) {
            this.setCrystalPositions();
        } else {
            this.setRandomPositions();
        }
        this.adjustMomentum();
        this.initializeAuxiliaryArrays();
        this.clearData();
        this.velocityHistogram.setBinWidth(2.0 * this.velocityMax / (double)this.N);
        this.velocityHistogram.setBinOffset(this.velocityMax / (double)this.N);
        int n = 0;
        while (n < this.N) {
            this.positionX[n] = this.pbc(this.positionX[n], this.Lx);
            this.positionY[n] = this.pbc(this.positionY[n], this.Ly);
            ++n;
        }
    }

    public void setRandomPositions() {
        int n = 0;
        while (n < this.N) {
            boolean bl;
            do {
                bl = false;
                this.positionX[n] = this.Lx * Math.random();
                this.positionY[n] = this.Ly * Math.random();
                int n2 = 0;
                while (n2 < n && !bl) {
                    double d;
                    double d2 = this.seperation(this.positionX[n] - this.positionX[n2], this.Lx);
                    if (d2 * d2 + (d = this.seperation(this.positionY[n] - this.positionY[n2], this.Ly)) * d < 1.0) {
                        bl = true;
                    }
                    ++n2;
                }
            } while (bl);
            ++n;
        }
        n = 0;
        while (n < this.N) {
            double d = Math.PI * 2 * this.random.nextDouble();
            this.velocityX[n] = this.velocityMax * Math.cos(d);
            this.velocityY[n] = this.velocityMax * Math.sin(d);
            this.timeOfLastCollision[n] = 0.0;
            ++n;
        }
    }

    public void setCrystalPositions() {
        int n;
        int n2;
        double d = Math.sqrt(this.N);
        if (d - (double)(n2 = (int)d) > 0.001) {
            ++n2;
        }
        double d2 = this.Lx / (double)n2;
        double d3 = this.Ly / (double)n2;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.N) {
            n = 0;
            while (n < n2) {
                if (n3 < this.N) {
                    this.positionY[n3] = d3 * ((double)n4 + 0.5);
                    this.positionX[n3] = n4 % 2 == 0 ? d2 * ((double)n + 0.25) : d2 * ((double)n + 0.75);
                    ++n3;
                }
                ++n;
            }
            ++n4;
        }
        n = 0;
        while (n < this.N) {
            double d4 = Math.PI * 2 * this.random.nextDouble();
            this.velocityX[n] = this.velocityMax * Math.cos(d4);
            this.velocityY[n] = this.velocityMax * Math.sin(d4);
            this.timeOfLastCollision[n] = 0.0;
            ++n;
        }
    }

    public void step() {
        this.tenCollisionTime = 0.0;
        this.tenCollisionVirial = 0.0;
        int n = 0;
        while (n < 10) {
            double d = this.getMinimumCollisionTime();
            this.move(d);
            this.time += d;
            this.tenCollisionTime += d;
            ++this.collisions;
            this.updateMFP(this.minimumCollisionI, this.minimumCollisionJ);
            this.contact(this.minimumCollisionI, this.minimumCollisionJ);
            this.virialAccumulator += this.virial;
            this.tenCollisionVirial += this.virial;
            this.totalKineticEnergyAccumulator += this.getInstaneousKineticEnergy();
            this.totalKineticEnergySquaredAccumulator += this.getInstaneousKineticEnergy() * this.getInstaneousKineticEnergy();
            this.resetList(this.minimumCollisionI, this.minimumCollisionJ);
            this.checkOverlap();
            int n2 = 0;
            while (n2 < this.N) {
                this.appendVelocityPoint(n2);
                ++n2;
            }
            ++this.steps;
            ++n;
        }
    }

    public void updateMFP(int n, int n2) {
        double d = this.time - this.timeOfLastCollision[n];
        double d2 = this.time - this.timeOfLastCollision[n2];
        double d3 = this.velocityX[n] * d;
        double d4 = this.velocityY[n] * d;
        this.mfpAccumulator += Math.sqrt(d3 * d3 + d4 * d4);
        d3 = this.velocityX[n2] * d2;
        d4 = this.velocityY[n2] * d2;
        this.mfpAccumulator += Math.sqrt(d3 * d3 + d4 * d4);
        this.timeOfLastCollision[n] = this.time;
        this.timeOfLastCollision[n2] = this.time;
    }

    public double getMFP() {
        return this.mfpAccumulator / 2.0 / (double)this.collisions;
    }

    public double getMFT() {
        return (double)this.N * this.time / (double)this.collisions;
    }

    public double getMeanTemperature() {
        return this.totalKineticEnergyAccumulator / (double)(this.N * this.steps);
    }

    public double getInstantaneousTemperature() {
        return this.getInstaneousKineticEnergy() / (double)this.N;
    }

    public void clearData() {
        this.time = 0.0;
        this.virialAccumulator = 0.0;
        this.collisions = 0;
        this.totalKineticEnergyAccumulator = 0.0;
        this.totalKineticEnergySquaredAccumulator = 0.0;
        this.steps = 0;
        this.mfpAccumulator = 0.0;
        this.velocityHistogram.clear();
    }

    public void zeroAverages() {
        this.velocityHistogram.clear();
        this.mfpAccumulator = 0.0;
        this.collisions = 0;
        this.totalKineticEnergyAccumulator = 0.0;
        this.totalKineticEnergySquaredAccumulator = 0.0;
        this.virialAccumulator = 0.0;
    }

    public void appendVelocityPoint(int n) {
        this.velocityHistogram.append(this.velocityX[n]);
    }

    public double getMeanKineticEnergy() {
        return this.totalKineticEnergyAccumulator / (double)this.steps;
    }

    public double getTemperature() {
        return this.getInstaneousKineticEnergy() / (double)this.N;
    }

    public void initializeAuxiliaryArrays() {
        int n = 0;
        while (n < this.N) {
            this.partner[n] = this.N - 1;
            ++n;
        }
        this.collisionTime[this.N - 1] = TIME_BIG;
        n = 0;
        while (n < this.N) {
            this.uplist(n);
            ++n;
        }
    }

    public void setLx(double d) {
        this.Lx = d;
        this.area = this.Lx * this.Ly;
        this.rho = (double)this.N / this.area;
    }

    public void setLy(double d) {
        this.Ly = d;
        this.area = this.Lx * this.Ly;
        this.rho = (double)this.N / this.area;
    }

    public void setNumberOfDisks(int n) {
        this.N = n;
        this.velocityX = new double[n];
        this.velocityY = new double[n];
        this.positionX = new double[n];
        this.positionY = new double[n];
        this.collisionTime = new double[n];
        this.timeOfLastCollision = new double[n];
        this.partner = new int[n];
        this.rho = (double)n / this.area;
    }

    public void setVelocityMax(double d) {
        this.velocityMax = Math.sqrt(2.0 * d);
    }

    public void setLatticeSpacing() {
        double d;
        double d2 = d = Math.floor(Math.sqrt(this.N));
        double d3 = this.Lx / d;
        double d4 = this.Ly / d2;
        int n = 0;
        double d5 = Math.PI;
        int n2 = 0;
        while ((double)n2 < d) {
            int n3 = 0;
            while ((double)n3 < d2) {
                this.positionX[n] = ((double)n2 - 0.5) * d3;
                this.positionY[n] = ((double)n3 - 0.5) * d4;
                double d6 = 2.0 * d5 * this.random.nextDouble();
                this.velocityX[n] = this.velocityMax * Math.cos(d6);
                this.velocityY[n] = this.velocityMax * Math.sin(d6);
                this.timeOfLastCollision[n] = 0.0;
                ++n;
                ++n3;
            }
            ++n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.N) {
            stringBuffer.append(String.valueOf(n) + " x " + this.positionX[n] + " y " + this.positionY[n] + " vx " + this.velocityX[n] + " vy " + this.velocityY[n] + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public double getInstaneousKineticEnergy() {
        double d = 0.0;
        int n = 0;
        while (n < this.N) {
            d += this.velocityX[n] * this.velocityX[n] + this.velocityY[n] * this.velocityY[n];
            ++n;
        }
        return d /= 2.0;
    }

    public void adjustMomentum() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.getTemperature();
        int n = 0;
        while (n < this.N) {
            d += this.velocityX[n];
            d2 += this.velocityY[n];
            ++n;
        }
        double d4 = d / (double)this.N;
        double d5 = d2 / (double)this.N;
        int n2 = 0;
        while (n2 < this.N) {
            this.velocityX[n2] = this.velocityX[n2] - d4;
            this.velocityY[n2] = this.velocityY[n2] - d5;
            ++n2;
        }
        double d6 = d3 / this.getTemperature();
        d6 = Math.sqrt(d6);
        int n3 = 0;
        while (n3 < this.N) {
            int n4 = n3;
            this.velocityX[n4] = this.velocityX[n4] * d6;
            int n5 = n3++;
            this.velocityY[n5] = this.velocityY[n5] * d6;
        }
    }

    public Histogram getVelocityHistogram() {
        return this.velocityHistogram;
    }

    public void checkCollision(int n, int n2) {
        int n3 = -1;
        while (n3 <= 1) {
            int n4 = -1;
            while (n4 <= 1) {
                double d;
                double d2;
                double d3;
                double d4;
                double d5 = this.positionX[n] - this.positionX[n2] + (double)n3 * this.Lx;
                double d6 = this.velocityX[n] - this.velocityX[n2];
                double d7 = this.positionY[n] - this.positionY[n2] + (double)n4 * this.Ly;
                double d8 = this.velocityY[n] - this.velocityY[n2];
                double d9 = d5 * d6 + d7 * d8;
                if (d9 < 0.0 && (d4 = d9 * d9 - (d3 = d6 * d6 + d8 * d8) * ((d2 = d5 * d5 + d7 * d7) - 1.0)) > 0.0 && (d = (-d9 - Math.sqrt(d4)) / d3) < this.collisionTime[n]) {
                    this.collisionTime[n] = d;
                    this.partner[n] = n2;
                }
                ++n4;
            }
            ++n3;
        }
    }

    public double getMinimumCollisionTime() {
        double d = TIME_BIG;
        int n = 0;
        while (n < this.N) {
            if (this.collisionTime[n] < d) {
                d = this.collisionTime[n];
                this.minimumCollisionI = n;
            }
            ++n;
        }
        this.minimumCollisionJ = this.partner[this.minimumCollisionI];
        return d;
    }

    public void move(double d) {
        int n = 0;
        while (n < this.N) {
            this.collisionTime[n] = this.collisionTime[n] - d;
            int n2 = n;
            this.positionX[n2] = this.positionX[n2] + this.velocityX[n] * d;
            int n3 = n;
            this.positionY[n3] = this.positionY[n3] + this.velocityY[n] * d;
            this.positionX[n] = this.pbc(this.positionX[n], this.Lx);
            this.positionY[n] = this.pbc(this.positionY[n], this.Ly);
            ++n;
        }
    }

    public double pbc(double d, double d2) {
        if (d >= d2) {
            return d - d2;
        }
        if (d < 0.0) {
            return d + d2;
        }
        return d;
    }

    public void contact(int n, int n2) {
        double d = this.seperation(this.positionX[n] - this.positionX[n2], this.Lx);
        double d2 = this.seperation(this.positionY[n] - this.positionY[n2], this.Ly);
        double d3 = this.velocityX[n] - this.velocityX[n2];
        double d4 = this.velocityY[n] - this.velocityY[n2];
        double d5 = d * d3 + d2 * d4;
        double d6 = -d5 * d;
        double d7 = -d5 * d2;
        this.velocityX[n] = this.velocityX[n] + d6;
        this.velocityX[n2] = this.velocityX[n2] - d6;
        this.velocityY[n] = this.velocityY[n] + d7;
        this.velocityY[n2] = this.velocityY[n2] - d7;
        this.virial = d6 * d + d7 * d2;
    }

    public double seperation(double d, double d2) {
        if (d > 0.5 * d2) {
            return d - d2;
        }
        if (d < -0.5 * d2) {
            return d + d2;
        }
        return d;
    }

    public void resetList(int n, int n2) {
        int n3 = 0;
        while (n3 < this.N) {
            int n4 = this.partner[n3];
            if (n3 == n || n4 == n || n3 == n2 || n4 == n2) {
                this.uplist(n3);
            }
            ++n3;
        }
        this.downlist(n);
        this.downlist(n2);
    }

    public void downlist(int n) {
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.checkCollision(n2, n);
            ++n2;
        }
    }

    public void uplist(int n) {
        if (n == this.N - 1) {
            return;
        }
        this.collisionTime[n] = TIME_BIG;
        int n2 = n + 1;
        while (n2 < this.N) {
            this.checkCollision(n, n2);
            ++n2;
        }
    }

    public void checkOverlap() {
        double d = 1.0E-5;
        int n = 0;
        while (n < this.N - 1) {
            int n2 = n + 1;
            while (n2 < this.N) {
                double d2;
                double d3;
                double d4;
                double d5 = this.seperation(this.positionX[n] - this.positionX[n2], this.Lx);
                double d6 = d5 * d5 + (d4 = this.seperation(this.positionY[n] - this.positionY[n2], this.Ly)) * d4;
                if (d6 < 1.0 && (d3 = 1.0 - (d2 = Math.sqrt(d6))) > d) {
                    System.err.println("particles " + n + "  " + n2 + " overlap");
                }
                ++n2;
            }
            ++n;
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.positionX == null) {
            return;
        }
        int n = Math.abs(drawingPanel.xToPix(this.radius) - drawingPanel.xToPix(0.0));
        int n2 = Math.abs(drawingPanel.yToPix(this.radius) - drawingPanel.yToPix(0.0));
        graphics.setColor(Color.blue);
        int n3 = drawingPanel.xToPix(this.positionX[0]) - n;
        int n4 = drawingPanel.yToPix(this.positionY[0]) - n2;
        graphics.fillOval(n3, n4, 2 * n, 2 * n2);
        graphics.setColor(Color.red);
        int n5 = 1;
        while (n5 < this.N) {
            n3 = drawingPanel.xToPix(this.positionX[n5]) - n;
            n4 = drawingPanel.yToPix(this.positionY[n5]) - n2;
            graphics.fillOval(n3, n4, 2 * n, 2 * n2);
            ++n5;
        }
        graphics.setColor(Color.black);
        n3 = drawingPanel.xToPix(0.0);
        n4 = drawingPanel.yToPix(this.Ly);
        n5 = drawingPanel.xToPix(this.Lx) - drawingPanel.xToPix(0.0);
        int n6 = drawingPanel.yToPix(0.0) - drawingPanel.yToPix(this.Ly);
        graphics.drawRect(n3, n4, n5, n6);
    }
}

