/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.harddisk;

import java.text.NumberFormat;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.HistogramFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.harddisk.HD;
import org.opensourcephysics.stp.util.Rdf;

public class HDApp
extends AbstractSimulation {
    PlotFrame temperatureFrame = new PlotFrame("time", "Temperature", "Temperature versus time");
    PlotFrame pressureFrame = new PlotFrame("time", "pressure", "Pressure versus time");
    DisplayFrame displayFrame = new DisplayFrame("HD Display");
    HistogramFrame histogramFrame = new HistogramFrame("v_x", "H(v_x)", "H(v_x) versus v_x");
    Rdf gr = new Rdf();
    PlotFrame grFrame = new PlotFrame("r", "g(r)", "Radial distribution function");
    HD hd;
    NumberFormat numberFormatTwoDigits = NumberFormat.getInstance();
    NumberFormat numberFormatFourDigits = NumberFormat.getInstance();

    public HDApp() {
        this.numberFormatTwoDigits.setMaximumFractionDigits(2);
        this.numberFormatTwoDigits.setMinimumFractionDigits(2);
        this.numberFormatFourDigits.setMaximumFractionDigits(4);
        this.numberFormatFourDigits.setMinimumFractionDigits(4);
        this.hd = new HD();
        this.displayFrame.setPreferredMinMax(-0.1 * this.hd.Lx, 1.1 * this.hd.Lx, -0.1 * this.hd.Lx, 1.1 * this.hd.Lx);
        this.displayFrame.addDrawable(this.hd);
        this.temperatureFrame.setPreferredMinMaxX(0.0, 10.0);
        this.temperatureFrame.setAutoscaleX(true);
        this.temperatureFrame.setPreferredMinMaxY(0.0, 10.0);
        this.temperatureFrame.setAutoscaleY(true);
        this.pressureFrame.setPreferredMinMaxX(0.0, 10.0);
        this.pressureFrame.setAutoscaleX(true);
        this.pressureFrame.setPreferredMinMaxY(0.0, 2.0);
        this.histogramFrame.setAutoscaleX(true);
        this.histogramFrame.setPreferredMinMaxY(0.0, 10.0);
        this.histogramFrame.setAutoscaleY(true);
        this.histogramFrame.addDrawable(this.hd.getVelocityHistogram());
        this.grFrame.setPreferredMinMaxX(0.0, 10.0);
        this.grFrame.setAutoscaleX(true);
        this.grFrame.setPreferredMinMaxY(0.0, 10.0);
        this.grFrame.setAutoscaleY(true);
    }

    public void initialize() {
        this.hd.setNumberOfDisks(this.control.getInt("N"));
        this.hd.setLx(this.control.getDouble("Lx"));
        this.hd.setLy(this.control.getDouble("Ly"));
        this.hd.setVelocityMax(this.control.getDouble("temperature"));
        this.hd.initialConfiguration = this.control.getString("initial configuration");
        this.hd.initialize();
        this.temperatureFrame.clearData();
        this.pressureFrame.clearData();
        this.gr.initialize(this.hd.Lx, this.hd.Ly, 0.1);
        this.displayFrame.setPreferredMinMax(-0.1 * this.hd.Lx, 1.1 * this.hd.Lx, -0.1 * this.hd.Lx, 1.1 * this.hd.Lx);
    }

    public void renderPanels() {
        this.temperatureFrame.append(0, this.hd.getTime(), this.hd.getInstantaneousTemperature());
        this.pressureFrame.append(0, this.hd.getTime(), this.hd.getInstantanousPressure());
        this.displayFrame.setPreferredMinMax(-0.1 * this.hd.Lx, 1.1 * this.hd.Lx, -0.1 * this.hd.Lx, 1.1 * this.hd.Lx);
        this.histogramFrame.render();
    }

    public void doStep() {
        this.hd.step();
        this.gr.append(this.hd.positionX, this.hd.positionY);
        this.gr.normalize();
        this.grFrame.clearData();
        this.grFrame.append(0, this.gr.rx, this.gr.ngr);
        this.grFrame.render();
        this.renderPanels();
    }

    public void reset() {
        this.control.clearMessages();
        this.control.setValue("N", 64);
        this.control.setValue("Lx", 18.0);
        this.control.setValue("Ly", 18.0);
        this.control.setValue("temperature", 1.0);
        OSPCombo oSPCombo = new OSPCombo(new String[]{"crystal", "random"}, 0);
        this.control.setValue("initial configuration", oSPCombo);
        this.gr.reset();
        this.delayTime = 0;
        this.enableStepsPerDisplay(true);
    }

    public void zeroAverages() {
        this.hd.zeroAverages();
        this.control.clearMessages();
    }

    public void stop() {
        this.output();
    }

    public void output() {
        this.control.println("Temperature = " + this.numberFormatFourDigits.format(this.hd.getTemperature()));
        this.control.println("<PA/NkT> = " + this.numberFormatFourDigits.format(this.hd.getMeanPressure()));
        this.control.println("Mean free path = " + this.numberFormatFourDigits.format(this.hd.getMFP()));
        this.control.println("Mean collision time = " + this.numberFormatFourDigits.format(this.hd.getMFT()));
    }

    public static void main(String[] stringArray) {
        SimulationControl simulationControl = SimulationControl.createApp(new HDApp(), stringArray);
        simulationControl.addButton("zeroAverages", "Zero averages");
    }
}

