/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.hdmc;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Random;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;

public class HDMC
implements Drawable {
    public double[] x;
    public double[] y;
    public int N;
    public double L;
    public double equivL;
    public double rho;
    public int steps;
    public double mcs;
    public String initialConfiguration;
    public double radius;
    public double beta;
    public double stepSize;
    Random r;
    public double s;
    public int accept;

    public HDMC() {
        this.rho = (double)this.N / (this.L * this.L);
        this.steps = 0;
        this.radius = 0.5;
        this.r = new Random();
        this.accept = 0;
    }

    public void initialize() {
        this.accept = 0;
        this.mcs = 0.0;
        this.rho = (double)this.N / (this.L * this.L);
        this.x = new double[this.N];
        this.y = new double[this.N];
        this.equivL = this.L;
        this.steps = 0;
        this.radius = 0.5;
        if (this.initialConfiguration.equals("hexagonal")) {
            this.setHexagonalLattice();
        } else if (this.initialConfiguration.equals("rectangular")) {
            this.setRectangularLattice();
        } else {
            this.setRandomPositions();
        }
    }

    public void setRandomPositions() {
        double d = 1.0;
        int n = 0;
        while (n < this.N) {
            boolean bl;
            do {
                bl = false;
                this.x[n] = this.L * Math.random();
                this.y[n] = this.L * Math.random();
                int n2 = 0;
                while (n2 < n && !bl) {
                    double d2;
                    double d3 = this.pbcSeparation(this.x[n] - this.x[n2], this.L);
                    double d4 = d3 * d3 + (d2 = this.pbcSeparation(this.y[n] - this.y[n2], this.L)) * d2;
                    if (d4 < d) {
                        bl = true;
                    }
                    ++n2;
                }
            } while (bl);
            ++n;
        }
    }

    public void setRectangularLattice() {
        double d;
        int n;
        int n2 = n = (int)Math.sqrt(this.N);
        double d2 = d = this.L / (double)n;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = n3 + n4 * n2;
                this.x[n5] = d * ((double)n3 + 0.5);
                this.y[n5] = d2 * ((double)n4 + 0.5);
                ++n4;
            }
            ++n3;
        }
    }

    public void setHexagonalLattice() {
        int n;
        double d = Math.sqrt(this.N);
        if (d - (double)(n = (int)d) > 0.001) {
            ++n;
        }
        double d2 = this.L / (double)n;
        double d3 = this.L / (double)n;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.N) {
            int n4 = 0;
            while (n4 < n) {
                if (n2 < this.N) {
                    this.y[n2] = d3 * ((double)n3 + 0.5);
                    this.x[n2] = n3 % 2 == 0 ? d2 * ((double)n4 + 0.25) : d2 * ((double)n4 + 0.75);
                    ++n2;
                }
                ++n4;
            }
            ++n3;
        }
    }

    public boolean checkOverlap(int n, double d, double d2) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.N) {
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            if (n != n2 && (d7 = Math.sqrt(d6 = (d5 = this.pbcSeparation(d - this.x[n2], this.L)) * d5 + (d4 = this.pbcSeparation(d2 - this.y[n2], this.L)) * d4)) < (d3 = 2.0 * this.radius)) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public void compress() {
        this.radius = this.s * this.radius;
        if (this.s > 1.0) {
            double d = this.L;
            int n = 0;
            while (n < this.N - 1) {
                int n2 = n + 1;
                while (n2 < this.N) {
                    double d2;
                    double d3 = this.pbcSeparation(this.x[n] - this.x[n2], this.L);
                    double d4 = d3 * d3 + (d2 = this.pbcSeparation(this.y[n] - this.y[n2], this.L)) * d2;
                    double d5 = Math.sqrt(d4);
                    if (d5 < d) {
                        d = d5;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.radius > 0.5 * d) {
                this.radius = 0.5 * d;
            }
        }
        this.equivL = this.L * Math.sqrt(0.25 / (this.radius * this.radius));
    }

    /*
     * Unable to fully structure code
     */
    private double pbcSeparation(double var1_1, double var3_2) {
        block2: {
            if (!(var1_1 > 0.0)) ** GOTO lbl7
            while (var1_1 > 0.5 * var3_2) {
                var1_1 -= var3_2;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var1_1 += var3_2;
lbl7:
                // 2 sources

                ** while (var1_1 < -0.5 * var3_2)
            }
        }
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    private double pbcPosition(double var1_1, double var3_2) {
        block2: {
            if (!(var1_1 > 0.0)) ** GOTO lbl7
            while (var1_1 > var3_2) {
                var1_1 -= var3_2;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var1_1 += var3_2;
lbl7:
                // 2 sources

                ** while (var1_1 < 0.0)
            }
        }
        return var1_1;
    }

    public TrialMove makeTrialMove() {
        TrialMove trialMove = new TrialMove();
        trialMove.n = this.r.nextInt(this.N);
        double d = 2.0 * this.stepSize * (Math.random() - 0.5);
        double d2 = 2.0 * this.stepSize * (Math.random() - 0.5);
        trialMove.xTry = this.pbcPosition(this.x[trialMove.n] + d, this.L);
        trialMove.yTry = this.pbcPosition(this.y[trialMove.n] + d2, this.L);
        trialMove.overlap = this.checkOverlap(trialMove.n, trialMove.xTry, trialMove.yTry);
        return trialMove;
    }

    public void step() {
        TrialMove trialMove = this.makeTrialMove();
        if (!trialMove.overlap) {
            this.x[trialMove.n] = trialMove.xTry;
            this.y[trialMove.n] = trialMove.yTry;
            ++this.accept;
        }
        ++this.steps;
    }

    public void oneMCstep() {
        int n = 0;
        while (n < this.N) {
            this.step();
            ++n;
        }
        this.mcs += 1.0;
        this.compress();
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n;
        int n2;
        if (this.x == null || this.y == null) {
            return;
        }
        int n3 = Math.abs(drawingPanel.xToPix(this.radius) - drawingPanel.xToPix(0.0));
        int n4 = Math.abs(drawingPanel.yToPix(this.radius) - drawingPanel.yToPix(0.0));
        graphics.setColor(Color.red);
        int n5 = 0;
        while (n5 < this.N) {
            n2 = drawingPanel.xToPix(this.x[n5]) - n3;
            n = drawingPanel.yToPix(this.y[n5]) - n4;
            graphics.fillOval(n2, n, 2 * n3, 2 * n4);
            ++n5;
        }
        graphics.setColor(Color.black);
        n5 = drawingPanel.xToPix(0.0);
        n2 = drawingPanel.yToPix(this.L);
        n = drawingPanel.xToPix(this.L) - drawingPanel.xToPix(0.0);
        int n6 = drawingPanel.yToPix(0.0) - drawingPanel.yToPix(this.L);
        graphics.drawRect(n5, n2, n, n6);
    }

    public class TrialMove {
        int n;
        double xTry;
        double yTry;
        boolean overlap;
    }
}

