/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.idealgas;

import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.util.MathPlus;

public class IdealGasApp
extends AbstractSimulation {
    PlotFrame densityPlot = new PlotFrame("ln E", "ln \u03c9(E)", "Density of States for an Ideal Gas");
    PlotFrame histogramPlot;
    int mcs;
    int N;
    double[] v;
    double vdel;
    double E;
    double E_max;
    int E_bins;
    int[] H;
    double[] g;
    double f;

    int energyIndex(double d) {
        return (int)(d * (double)this.E_bins / this.E_max);
    }

    void perturbParticles() {
        int n = 0;
        while (n < this.N) {
            int n2 = MathPlus.randomInt(0, this.N - 1);
            double d = MathPlus.random(-this.vdel, this.vdel);
            double d2 = d * d + 2.0 * d * this.v[n2];
            if (this.E + d2 < this.E_max && Math.random() < Math.exp(this.g[this.energyIndex(this.E)] - this.g[this.energyIndex(this.E + d2)])) {
                int n3 = n2;
                this.v[n3] = this.v[n3] + d;
                this.E += d2;
            }
            int n4 = this.energyIndex(this.E);
            this.g[n4] = this.g[n4] + Math.log(this.f);
            int n5 = this.energyIndex(this.E);
            this.H[n5] = this.H[n5] + 1;
            ++n;
        }
    }

    boolean isFlat() {
        double d = (double)this.sum(this.H) / (double)this.E_bins;
        int n = 0;
        while (n < this.E_bins) {
            if (this.H[n] == 0 || (double)this.H[n] < 0.8 * d || (double)this.H[n] > 1.2 * d) {
                return false;
            }
            ++n;
        }
        return true;
    }

    int sum(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.E_bins) {
            n += nArray[n2];
            ++n2;
        }
        return n;
    }

    public void doStep() {
        int n = this.mcs + Math.max(10000 / this.N, 1);
        while (this.mcs < n) {
            this.perturbParticles();
            ++this.mcs;
        }
        if (this.isFlat() && this.f > 1.0001) {
            this.f = Math.sqrt(this.f);
            this.control.println("f = " + ControlUtils.f4(this.f) + "   mcs = " + this.mcs / this.N);
        }
        this.densityPlot.clearData();
        this.densityPlot.setMessage("mcs = " + this.mcs / this.N);
        this.histogramPlot.clearData();
        int n2 = 0;
        while (n2 < this.E_bins) {
            this.densityPlot.append(0, Math.log((double)n2 * this.E_max / (double)this.E_bins), this.g[n2]);
            this.histogramPlot.append(0, (double)n2 * this.E_max / (double)this.E_bins, this.H[n2]);
            ++n2;
        }
    }

    public void initialize() {
        this.mcs = 0;
        this.N = this.control.getInt("num. particles") * this.control.getInt("num. dimensions");
        this.v = new double[this.N];
        this.E = 0.0;
        this.E_bins = this.control.getInt("num. energy bins");
        this.E_max = this.control.getDouble("maximum energy");
        this.vdel = this.control.getDouble("\u2206 velocity");
        this.control.clearMessages();
        this.H = new int[this.E_bins];
        this.g = new double[this.E_bins];
        this.f = Math.exp(1.0);
        this.control.println("f = " + ControlUtils.f4(this.f));
    }

    public void reset() {
        this.control.setValue("num. particles", 4);
        this.control.setValue("num. dimensions", 1);
        this.control.setValue("num. energy bins", 128);
        this.control.setValue("maximum energy", 10);
        this.control.setValue("\u2206 velocity", 0.4);
        this.densityPlot.clearDataAndRepaint();
        this.histogramPlot.clearDataAndRepaint();
        this.enableStepsPerDisplay(true);
    }

    public IdealGasApp() {
        this.densityPlot.setAnimated(true);
        this.histogramPlot = new PlotFrame("E", "H(E)", "Histogram for an Ideal Gas");
        this.histogramPlot.setAnimated(true);
    }

    public static void main(String[] stringArray) {
        SimulationControl.createApp(new IdealGasApp(), stringArray);
    }
}

